/*
 * Decompiled with CFR 0.152.
 */
package apm.notification;

import apm.notification.IssueEvent;
import apm.notification.NotificationConfig;
import apm.notification.Notifications;
import cn.DB;
import cn.Log;
import cn.SapUser;
import cn.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class Scheduler {
    public static boolean schedule() {
        Log.log("Starting APM scheduling.");
        Log.log("Starting to process que (APM_Notification_Issue::processQueue)");
        ArrayList<String> ids = new ArrayList<String>();
        ResultSet rs = DB.getData("SELECT * FROM queue_issue_notification;");
        try {
            while (rs.next()) {
                String unikid = rs.getString("issue_guid");
                NotificationConfig config = Scheduler.getConfig(unikid);
                if (config.active) {
                    IssueEvent event = IssueEvent.readSingleEvent(rs.getString("issue_event_id"));
                    switch (event.type) {
                        case 2: {
                            Log.log("apm.Scheduler schedule found a CONFIRM event.");
                            Notifications.sendConfirm(event, config);
                            break;
                        }
                        case 4: {
                            Log.log("apm.Scheduler schedule found a RESPONSIBLE event.");
                            Notifications.sendResponsible(event, config);
                            break;
                        }
                        case 3: {
                            Log.log("apm.Scheduler schedule found a STATUS event.");
                            Notifications.sendStatus(event, config);
                            break;
                        }
                        default: {
                            Log.log("apm.Scheduler had an event type not relevant for notification, type: '" + event.type + "' unikid: '" + unikid + "'");
                        }
                    }
                }
                ids.add(rs.getString("id"));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("apm.Scheduler schedule failed while sending mails in schedule()");
            Log.logException(e);
            return false;
        }
        Log.log(ids.size() + " notification(s) processed");
        if (ids.size() > 0) {
            String idstring = String.join((CharSequence)",", ids.toArray(Utils.EMPTYSTRINGARRAY));
            DB.update("DELETE FROM queue_issue_notification WHERE id IN (" + idstring + ");");
            Log.log("Deleted processed que items.");
        }
        Log.log("APM scheduling done!");
        return true;
    }

    private static NotificationConfig getConfig(String unikid) {
        SapUser su = Scheduler.getSapUser(unikid);
        return NotificationConfig.getBySystemClient(su.system, su.client);
    }

    private static SapUser getSapUser(String unikid) {
        SapUser sapUser = null;
        ResultSet rs = DB.getData("SELECT `user`, `system`, `client` FROM cehior_auth_header WHERE unikid='" + unikid + "';");
        try {
            if (rs.next()) {
                sapUser = new SapUser(rs.getString("user"), rs.getString("system"), rs.getString("client"));
            } else {
                Log.log("apm.Scheduler getSapUser FAILED! Could not find issue with id '" + unikid + "'");
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("apm.Scheduler getSapUser ResultSet FAILED!");
            Log.logException(e);
        }
        return sapUser;
    }
}

