/*
 * Decompiled with CFR 0.152.
 */
package apm.notification;

import apm.notification.IssueEvent;
import apm.notification.NotificationConfig;
import apm.notification.NotificationContent;
import cn.Email;
import cn.Log;
import cn.Translator;
import cn.Utils;
import javax.mail.internet.InternetAddress;

class Notifications {
    Notifications() {
    }

    static boolean sendConfirm(IssueEvent event, NotificationConfig config) {
        InternetAddress[] receivers;
        Log.log("apm.Notifications sendConfirm for event id " + event.id);
        Translator translator = config.translator;
        String[] toList = config.toList;
        if (event.getResponsible() != null) {
            toList = new String[]{event.getResponsibleEmail()};
        }
        if ((receivers = Email.convertEmailList(toList)) != null) {
            if (receivers.length == 0) {
                Log.log("apm.Notifications No 'receiver' addresses for event id " + event.id);
                return false;
            }
        } else {
            Log.log("apm.Notifications No 'receiver' addresses for event id " + event.id);
            return false;
        }
        if (!Utils.isEmpty(config.from) && Email.isValidEmail(config.from)) {
            String body;
            String subject = "CN APM " + event.user.system + "/" + event.user.client + ": " + translator.getText("New issue") + " " + event.issueId;
            Email mail = new Email(config.from, receivers, subject, body = NotificationContent.buildBody(event, translator));
            if (!mail.send()) {
                Log.log("apm.Notifications failed to send confirm email for event id " + event.id);
            } else {
                Log.log("apm.Notifications created confirm email for event id " + event.id + ". Subject: " + subject);
            }
        } else {
            Log.log("apm.Notifications No 'from' address for event id " + event.id);
            return false;
        }
        return true;
    }

    static boolean sendResponsible(IssueEvent event, NotificationConfig config) {
        Log.log("apm.Notifications sendResponsible for event id " + event.id);
        Translator translator = config.translator;
        InternetAddress[] receivers = null;
        if (event.getResponsible() != null) {
            String[] toList = new String[]{event.getResponsibleEmail()};
            receivers = Email.convertEmailList(toList);
        }
        if (receivers != null) {
            if (receivers.length == 0) {
                Log.log("apm.Notifications sendResponsible for event id " + event.id + " responsible has no email or event has no responsible.");
                return false;
            }
        } else {
            Log.log("apm.Notifications sendResponsible for event id " + event.id + " responsible has no email or event has no responsible.");
            return false;
        }
        if (!Utils.isEmpty(config.from) && Email.isValidEmail(config.from)) {
            String body;
            String subject = "CN APM " + event.user.system + "/" + event.user.client + ": " + translator.getText("Assigned issue") + event.issueId;
            Email mail = new Email(config.from, receivers, subject, body = NotificationContent.buildIntro(event, translator) + NotificationContent.buildBody(event, translator));
            if (!mail.send()) {
                Log.log("apm.Notifications failed to send responsible email for event id " + event.id);
            } else {
                Log.log("apm.Notifications created responsible email for event id " + event.id + ". Subject: " + subject);
            }
        } else {
            Log.log("apm.Notifications No 'from' address for event id " + event.id);
            return false;
        }
        return true;
    }

    static boolean sendStatus(IssueEvent event, NotificationConfig config) {
        Log.log("apm.Notifications sendStatus for event id " + event.id);
        Translator translator = config.translator;
        InternetAddress[] receivers = null;
        if (event.getResponsible() != null) {
            String[] toList = new String[]{event.getResponsibleEmail()};
            receivers = Email.convertEmailList(toList);
        }
        if (receivers != null) {
            if (receivers.length == 0) {
                Log.log("apm.Notifications sendStatus for event id " + event.id + " responsible has no email or event has no responsible.");
                return false;
            }
        } else {
            Log.log("apm.Notifications sendStatus for event id " + event.id + " responsible has no email or event has no responsible.");
            return false;
        }
        if (!Utils.isEmpty(config.from) && Email.isValidEmail(config.from)) {
            String body;
            String subject = "CN APM " + event.user.system + "/" + event.user.client + ": " + translator.getText("Status changed") + event.issueId;
            Email mail = new Email(config.from, receivers, subject, body = NotificationContent.buildStatusIntro(event, translator) + NotificationContent.buildBody(event, translator));
            if (!mail.send()) {
                Log.log("apm.Notifications failed to send status email for event id " + event.id);
            } else {
                Log.log("apm.Notifications created status email for event id " + event.id + ". Subject: " + subject);
            }
        } else {
            Log.log("apm.Notifications No 'from' address for event id " + event.id);
            return false;
        }
        return true;
    }
}

