/*
 * Decompiled with CFR 0.152.
 */
package apm.notification;

import apm.notification.IssueDetails;
import apm.notification.IssueEvent;
import cn.EmailContent;
import cn.Translator;
import cn.Utils;
import java.util.Map;

class NotificationContent {
    private static final String SEPARATOR = "\n<hr /><br />\n\n";
    private static final String BREAKER = "<br />\n<br />\n";

    NotificationContent() {
    }

    static String buildBody(IssueEvent ie, Translator translator) {
        IssueEvent[] events;
        StringBuilder body = new StringBuilder();
        IssueDetails d = IssueDetails.getIssueDetails(ie.issueId);
        body.append(EmailContent.makeTableHeader(new String[]{translator.getText("Username"), translator.getText("First name"), translator.getText("Last name"), translator.getText("Transaction"), translator.getText("Object")}, translator));
        body.append("<tr>");
        body.append(EmailContent.makeTableCell(d.user, null));
        body.append(EmailContent.makeTableCell(d.firstname, null));
        body.append(EmailContent.makeTableCell(d.lastname, null));
        body.append(EmailContent.makeTableCell(d.tcode, null));
        body.append(EmailContent.makeTableCell(d.object, null));
        body.append("</tr>");
        body.append("</table>");
        body.append(EmailContent.makeTableHeader(new String[]{translator.getText("Field"), translator.getText("Value")}, translator));
        for (Map.Entry<String, String> e : d.fields.entrySet()) {
            body.append(EmailContent.makeTableCell(e.getKey(), null));
            body.append(EmailContent.makeTableCell(e.getValue(), null));
        }
        block5: for (IssueEvent event : events = IssueEvent.readEventsForIssue(d.unikid)) {
            switch (event.type) {
                case 5: {
                    body.append(SEPARATOR + NotificationContent.getEventHeader(event));
                    body.append(BREAKER);
                    body.append(event.comment);
                    continue block5;
                }
                case 2: {
                    body.append(SEPARATOR + NotificationContent.getEventHeader(event));
                    body.append(BREAKER);
                    body.append(d.userText);
                    continue block5;
                }
            }
        }
        return body.toString();
    }

    static String buildIntro(IssueEvent event, Translator translator) {
        StringBuilder body = new StringBuilder();
        body.append(NotificationContent.getEventHeader(event));
        body.append(BREAKER);
        String prevResp = NotificationContent.getPrevResponsible(event);
        if (Utils.isEmpty(prevResp)) {
            body.append(translator.getText("Changed responsible to") + " ");
            body.append(event.getResponsible());
        } else {
            body.append(translator.getText("Changed responsible from {1} to {2}", new String[]{prevResp, event.getResponsible()}));
        }
        body.append(SEPARATOR);
        return body.toString();
    }

    static String buildStatusIntro(IssueEvent event, Translator translator) {
        StringBuilder body = new StringBuilder();
        body.append(NotificationContent.getEventHeader(event));
        body.append(BREAKER);
        body.append(translator.getText("Changed status to") + " ");
        body.append(Utils.titleCase(translator.getText(event.getStatusText())));
        body.append(SEPARATOR);
        return body.toString();
    }

    private static String getEventHeader(IssueEvent event) {
        return event.user.username + ", " + event.timestamp.toString() + " (UTC)";
    }

    private static String getPrevResponsible(IssueEvent event) {
        IssueEvent[] eventLog;
        String resp = null;
        for (IssueEvent ie : eventLog = IssueEvent.readEventsForIssue(event.issueId)) {
            if (ie.type != 4 || event.id == ie.id) continue;
            resp = ie.getResponsible();
        }
        return resp;
    }
}

