/*
 * Decompiled with CFR 0.152.
 */
package apm.notification;

import cn.DB;
import cn.Log;
import cn.SapUser;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

class IssueEvent {
    static final int TYPE_CREATE = 1;
    static final int TYPE_CONFIRM = 2;
    static final int TYPE_STATUS = 3;
    static final int TYPE_RESPONSIBLE = 4;
    static final int TYPE_COMMENT = 5;
    static final int TYPE_CREATETASK = 6;
    static final int TYPE_EXECUTETASK = 7;
    static final int TYPE_STATUSTASK = 8;
    static final int TYPE_EXECUTESUBTASK = 9;
    static final int TYPE_LINK = 10;
    final long id;
    final String issueId;
    final Timestamp timestamp;
    final SapUser user;
    final int type;
    private String responsible = null;
    String comment;

    IssueEvent(long id, String issueId, Timestamp timestamp, SapUser user, int type) {
        this.id = id;
        this.issueId = issueId;
        this.timestamp = timestamp;
        this.user = user;
        this.type = type;
        if (this.type == 5) {
            this.comment = DB.getOne("SELECT comment FROM issue_comment WHERE issue_event_id = " + this.id + ";");
        }
    }

    String getResponsible() {
        if (this.responsible == null) {
            this.responsible = DB.getOne("SELECT responsible FROM cehior_auth_header WHERE unikid = '" + this.issueId + "'");
        }
        return this.responsible;
    }

    String getResponsibleEmail() {
        return DB.getOne("SELECT email FROM cehior_auth_resp WHERE responsible = '" + this.getResponsible() + "';");
    }

    String getStatusText() {
        return DB.getOne("SELECT * FROM issue_status WHERE issue_event_id = " + this.id);
    }

    static IssueEvent[] readEventsForIssue(String issueId) {
        ArrayList<IssueEvent> events = new ArrayList<IssueEvent>();
        ResultSet rs = DB.getData("SELECT * FROM issue_event WHERE issue_id = '" + issueId + "' ORDER BY `timestamp` DESC;");
        try {
            while (rs.next()) {
                events.add(IssueEvent.rowToEvent(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("apm.IssueEvent readEventsForIssue '" + issueId + "' FAILED!");
            Log.logException(e);
        }
        return events.toArray(new IssueEvent[0]);
    }

    static IssueEvent readSingleEvent(String eventId) {
        ResultSet rs = DB.getData("SELECT * FROM issue_event WHERE id = '" + eventId + "' ORDER BY `timestamp`;");
        try {
            if (rs.next()) {
                return IssueEvent.rowToEvent(rs);
            }
            Log.log("apm.IssueEvent readSingleEvent FAILED to find issue event with eventId '" + eventId + "'");
            rs.close();
        }
        catch (SQLException e) {
            Log.log("apm.IssueEvent readSingleEvent FAILED on eventId '" + eventId + "'");
            Log.logException(e);
        }
        return null;
    }

    private static IssueEvent rowToEvent(ResultSet rs) {
        try {
            return new IssueEvent(rs.getLong("id"), rs.getString("issue_id"), rs.getTimestamp("timestamp"), new SapUser(rs.getString("user"), rs.getString("system"), rs.getString("client")), rs.getInt("event_type"));
        }
        catch (SQLException e) {
            Log.log("IssueEvent rowToEvent FAILED!");
            Log.logException(e);
            return null;
        }
    }
}

