/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class ViolationJsonMerge {
    ViolationJsonMerge() {
    }

    public static HashMap<Integer, JSONObject> mergeActivitiesAndRoles(HashMap<Integer, JSONObject> inputMap) {
        HashMap<Integer, JSONObject> mergedMap = new HashMap<Integer, JSONObject>();
        for (Map.Entry<Integer, JSONObject> entry : inputMap.entrySet()) {
            int key = entry.getKey();
            JSONObject inputObject = entry.getValue();
            JSONArray activities = inputObject.getJSONArray("acts");
            HashMap<Integer, JSONObject> mergedActivities = new HashMap<Integer, JSONObject>();
            for (int i = 0; i < activities.length(); ++i) {
                JSONObject activity = activities.getJSONObject(i);
                int actId = activity.getInt("a_id");
                if (mergedActivities.containsKey(actId)) {
                    JSONObject mergedActivity = (JSONObject)mergedActivities.get(actId);
                    ViolationJsonMerge.mergeRoles(mergedActivity.getJSONArray("role"), activity.getJSONArray("role"));
                    continue;
                }
                mergedActivities.put(actId, activity);
            }
            JSONArray mergedActivitiesArray = new JSONArray(mergedActivities.values());
            JSONObject mergedObject = new JSONObject(inputObject.toString());
            mergedObject.put("acts", (Object)mergedActivitiesArray);
            mergedMap.put(key, mergedObject);
        }
        return mergedMap;
    }

    private static void mergeRoles(JSONArray target, JSONArray source) {
        for (int i = 0; i < source.length(); ++i) {
            JSONObject sourceRole = source.getJSONObject(i);
            if (ViolationJsonMerge.targetContainsRoleWithSameId(target, sourceRole)) continue;
            target.put((Object)sourceRole);
        }
    }

    private static boolean targetContainsRoleWithSameId(JSONArray target, JSONObject sourceRole) {
        for (int i = 0; i < target.length(); ++i) {
            JSONObject targetRole = target.getJSONObject(i);
            if (targetRole.getInt("r_id") != sourceRole.getInt("r_id") || targetRole.getInt("c_id") != sourceRole.getInt("c_id")) continue;
            ViolationJsonMerge.mergeJsonArray(targetRole.getJSONArray("r_auth"), sourceRole.getJSONArray("r_auth"));
            return true;
        }
        return false;
    }

    private static boolean targetContainsObjectWithSameId(JSONArray target, JSONObject sourceObject) {
        for (int i = 0; i < target.length(); ++i) {
            JSONObject targetObject = target.getJSONObject(i);
            if (targetObject.getInt("o_id") != sourceObject.getInt("o_id") || targetObject.getInt("f_id") != sourceObject.getInt("f_id") || !targetObject.getString("low").equals(sourceObject.getString("low")) || !targetObject.getString("high").equals(sourceObject.getString("high"))) continue;
            return true;
        }
        return false;
    }

    private static void mergeJsonArray(JSONArray target, JSONArray source) {
        for (int i = 0; i < source.length(); ++i) {
            JSONObject sourceObject = source.getJSONObject(i);
            if (ViolationJsonMerge.targetContainsObjectWithSameId(target, sourceObject)) continue;
            target.put((Object)sourceObject);
        }
    }

    public static JSONArray combineCauses(JSONArray inputArray) {
        JSONArray combinedArray = new JSONArray();
        JSONArray causesArray = new JSONArray();
        for (int i = 0; i < inputArray.length(); ++i) {
            JSONObject obj = inputArray.getJSONObject(i);
            JSONArray causes = obj.getJSONArray("cause");
            for (int j = 0; j < causes.length(); ++j) {
                causesArray.put((Object)causes.getJSONObject(j));
            }
        }
        JSONObject causesObject = new JSONObject();
        causesObject.put("cause", (Object)causesArray);
        combinedArray.put((Object)causesObject);
        return combinedArray;
    }
}

