/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.risk.Activity;
import ac.risk.ViolatingAuthorizationEntry;
import ac.risk.ViolatingRole;
import ac.risk.ViolatingTcodeEntry;
import ac.risk.Violation;
import ac.risk.ViolationCause;
import ac.risk.ViolationJsonMerge;
import cn.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

class ViolationJSON {
    ViolationJSON() {
    }

    static String createJSONCauses(Violation v) {
        JSONArray causeList = new JSONArray();
        HashMap<Integer, JSONObject> hashMap = new HashMap<Integer, JSONObject>();
        switch (v.risk.type) {
            case "sod_func": {
                ViolatingAuthorizationEntry[][] violatingAuthorizationEntryArray = v.violatingAuthorizationEntries;
                int n = violatingAuthorizationEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    ViolatingAuthorizationEntry[] ves;
                    for (ViolatingAuthorizationEntry ve : ves = violatingAuthorizationEntryArray[i]) {
                        JSONObject cause;
                        ViolationCause c = new ViolationCause();
                        Activity act = ve.activity;
                        c.role_id = ve.violatingEntry.role.id;
                        c.composite_id = ve.violatingEntry.fromComposite == null ? -1 : ve.violatingEntry.fromComposite.id;
                        c.authorizations = new ArrayList<Authorization>(Arrays.asList(ve.violatingAuthorizations));
                        int key = act.functionality.id;
                        if (hashMap.containsKey(key)) {
                            cause = ViolationJSON.mainJsonMethod(c, act);
                            hashMap.get(key).getJSONArray("acts").put((Object)cause);
                            continue;
                        }
                        cause = ViolationJSON.mainJsonMethod(c, act);
                        JSONArray causesArray = new JSONArray();
                        causesArray.put((Object)cause);
                        JSONObject funcObject = new JSONObject();
                        funcObject.put("func_id", key);
                        funcObject.put("acts", (Object)causesArray);
                        hashMap.put(key, funcObject);
                    }
                }
                break;
            }
            case "crit_tcode": {
                for (ViolatingTcodeEntry vte : v.causesTcode) {
                    JSONObject outerObject = new JSONObject();
                    JSONArray jsonArray = new JSONArray();
                    outerObject.put("tcode", (Object)vte.tcodeAuthorization.low);
                    for (AuthorizationEntry ae : vte.violatingEntry) {
                        ViolationCause c = new ViolationCause();
                        c.role_id = ae.role.id;
                        c.composite_id = ae.fromComposite == null ? -1 : ae.fromComposite.id;
                        c.authorizations = Utils.addArrayToArrayList(new ArrayList(), vte.violatingAuthorizations);
                        JSONObject causeJSON = ViolationJSON.createTCodeObject(c);
                        jsonArray.put((Object)causeJSON);
                    }
                    outerObject.put("role", (Object)jsonArray);
                    causeList.put((Object)outerObject);
                }
                break;
            }
            case "crit_role": {
                for (ViolatingRole vr : v.causesRole[0]) {
                    JSONObject causeJSON = new JSONObject();
                    causeJSON.put("r_id", vr.role.id);
                    causeJSON.put("c_id", vr.composite == null ? -1 : vr.composite.id);
                    causeJSON.put("assign", true);
                    causeList.put((Object)causeJSON);
                }
                break;
            }
            case "sod_role2": {
                for (ViolatingRole[] vrs : v.causesRole) {
                    JSONArray outerArray = new JSONArray();
                    for (ViolatingRole vr : vrs) {
                        JSONObject causeJSON = new JSONObject();
                        causeJSON.put("r_id", vr.role.id);
                        causeJSON.put("c_id", vr.composite == null ? -1 : vr.composite.id);
                        causeJSON.put("assign", true);
                        outerArray.put((Object)causeJSON);
                    }
                    causeList.put((Object)outerArray);
                }
                break;
            }
        }
        if (hashMap.isEmpty()) {
            return causeList.toString();
        }
        hashMap = ViolationJsonMerge.mergeActivitiesAndRoles(hashMap);
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>(hashMap.values());
        JSONArray jsonArray = new JSONArray(resultList);
        return jsonArray.toString();
    }

    private static JSONObject createTCodeObject(ViolationCause violationCause) {
        JSONObject causeJSON = new JSONObject();
        causeJSON.put("r_id", violationCause.role_id);
        causeJSON.put("c_id", violationCause.composite_id);
        causeJSON.put("assign", violationCause.assigned);
        causeJSON.put("r_auth", (Object)ViolationJSON.authJsonArray(violationCause.authorizations));
        return causeJSON;
    }

    private static JSONObject mainJsonMethod(ViolationCause violationCause, Activity activity) {
        JSONObject causeJSON = new JSONObject();
        causeJSON.put("a_id", activity.id);
        causeJSON.put("role", (Object)ViolationJSON.createRole(violationCause));
        return causeJSON;
    }

    private static JSONArray createRole(ViolationCause violationCause) {
        JSONObject object = new JSONObject();
        JSONArray roleArray = new JSONArray();
        object.put("r_id", violationCause.role_id);
        object.put("c_id", violationCause.composite_id);
        object.put("assign", violationCause.assigned);
        object.put("r_auth", (Object)ViolationJSON.authJsonArray(violationCause.authorizations));
        roleArray.put((Object)object);
        return roleArray;
    }

    private static JSONArray authJsonArray(ArrayList<Authorization> auths) {
        JSONArray jsonArray = new JSONArray();
        for (Authorization auth : auths) {
            JSONObject authObject = new JSONObject();
            authObject.put("o_id", auth.object_id);
            authObject.put("f_id", auth.field_id);
            authObject.put("low", (Object)auth.low);
            authObject.put("high", (Object)auth.high);
            jsonArray.put((Object)authObject);
        }
        return jsonArray;
    }
}

