/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.risk.Risk;
import ac.risk.RiskCriticalTcodes;
import ac.risk.RiskSoDFunctionalities;
import ac.risk.RiskSoDRoles;
import ac.risk.ViolatingAuthorizationEntry;
import ac.risk.ViolatingRole;
import ac.risk.ViolatingTcodeEntry;
import ac.risk.ViolationJSON;
import java.util.ArrayList;

public class Violation {
    public static final Violation[] EMPTYARRAY = new Violation[0];
    public final Risk risk;
    public final ViolatingRole[][] causesRole;
    public final ViolatingTcodeEntry[] causesTcode;
    public final ViolatingAuthorizationEntry[][] violatingAuthorizationEntries;

    public String getAsJSON() {
        return ViolationJSON.createJSONCauses(this);
    }

    private Violation(Risk risk, ViolatingRole[][] causes) {
        this.risk = risk;
        this.causesRole = causes;
        this.causesTcode = null;
        this.violatingAuthorizationEntries = null;
    }

    private Violation(Risk risk, ViolatingTcodeEntry[] causes) {
        this.risk = risk;
        this.causesRole = null;
        this.causesTcode = causes;
        this.violatingAuthorizationEntries = null;
    }

    private Violation(Risk risk, ViolatingAuthorizationEntry[][] causes) {
        this.risk = risk;
        this.causesRole = null;
        this.causesTcode = null;
        this.violatingAuthorizationEntries = causes;
    }

    static Violation create(Risk risk, ViolatingRole[] vrs) {
        ViolatingRole[][] violatingRoles = new ViolatingRole[1][vrs.length];
        violatingRoles[0] = vrs;
        return new Violation(risk, violatingRoles);
    }

    static final Violation createSoDRoles2(RiskSoDRoles risk, ArrayList<ArrayList<ViolatingRole>> vrss) {
        int longest = 0;
        for (ArrayList<ViolatingRole> vrs : vrss) {
            if (vrs.size() <= longest) continue;
            longest = vrs.size();
        }
        ViolatingRole[][] violatingRoles = new ViolatingRole[vrss.size()][longest];
        for (int i = 0; i < violatingRoles.length; ++i) {
            violatingRoles[i] = vrss.get(i).toArray(ViolatingRole.EMPTYARRAY);
        }
        return new Violation((Risk)risk, violatingRoles);
    }

    static final Violation createCriticalTcode(RiskCriticalTcodes risk, ViolatingTcodeEntry[] causes) {
        return new Violation((Risk)risk, causes);
    }

    static final Violation createSoDFunctionality(RiskSoDFunctionalities risk, ArrayList<ArrayList<ViolatingAuthorizationEntry>> functionalitycauses) {
        ViolatingAuthorizationEntry[][] violationCauses = new ViolatingAuthorizationEntry[functionalitycauses.size()][];
        for (int i = 0; i < functionalitycauses.size(); ++i) {
            violationCauses[i] = functionalitycauses.get(i).toArray(new ViolatingAuthorizationEntry[0]);
        }
        return new Violation((Risk)risk, violationCauses);
    }
}

