/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.risk.Activity;
import java.util.ArrayList;

public class ViolatingAuthorizationEntry {
    public final Activity activity;
    public final AuthorizationEntry violatingEntry;
    public final Authorization[] violatingAuthorizations;

    ViolatingAuthorizationEntry(Activity activity, AuthorizationEntry violatingEntry, Authorization[] violatingAuthorizations) {
        this.activity = activity;
        this.violatingEntry = violatingEntry;
        this.violatingAuthorizations = violatingAuthorizations;
    }

    public String toString() {
        String s = this.activity.toString() + "\t" + this.violatingEntry.role.name + "\t";
        for (Authorization a : this.violatingAuthorizations) {
            s = s + a.toString() + ", ";
        }
        return s;
    }

    public boolean isInList(ArrayList<ViolatingAuthorizationEntry> listOfViolatingEntries) {
        for (ViolatingAuthorizationEntry vae : listOfViolatingEntries) {
            if (this.activity != vae.activity || this.violatingEntry != vae.violatingEntry || this.violatingAuthorizations.length != vae.violatingAuthorizations.length) continue;
            boolean sameAuthorizations = true;
            for (Authorization a : this.violatingAuthorizations) {
                boolean inList = false;
                for (Authorization vaea : vae.violatingAuthorizations) {
                    if (vaea != a) continue;
                    inList = true;
                }
                if (inList) continue;
                sameAuthorizations = false;
            }
            if (!sameAuthorizations) continue;
            return true;
        }
        return false;
    }
}

