/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AnalysisRole;
import ac.analysis.AnalysisUser;
import ac.risk.Risk;
import ac.risk.ViolatingRole;
import ac.risk.Violation;
import cn.DB;
import cn.Log;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class RiskSoDRoles
extends Risk {
    private static final ArrayList<ArrayList<ViolatingRole>> violatingRoles = new ArrayList();
    private ArrayList<ArrayList<Integer>> roleIds = new ArrayList();

    @Override
    public Violation checkViolations(AnalysisUser user) {
        return RiskSoDRoles.checkForViolations(this, user.roles);
    }

    private static Violation checkForViolations(RiskSoDRoles risk, AnalysisRole[] roles) {
        violatingRoles.clear();
        int list = 0;
        for (ArrayList<Integer> roleIds : risk.roleIds) {
            boolean needEntry = true;
            for (int roleId : roleIds) {
                for (AnalysisRole assignedRole : roles) {
                    if (roleId == assignedRole.id) {
                        if (needEntry) {
                            violatingRoles.add(new ArrayList());
                            needEntry = false;
                        }
                        violatingRoles.get(list).add(ViolatingRole.direct(assignedRole));
                        continue;
                    }
                    if (!assignedRole.isComposite) continue;
                    for (AnalysisRole roleIndirect : assignedRole.compositeChildren) {
                        if (roleId != roleIndirect.id) continue;
                        if (needEntry) {
                            violatingRoles.add(new ArrayList());
                            needEntry = false;
                        }
                        violatingRoles.get(list).add(ViolatingRole.indirect(roleIndirect, assignedRole));
                    }
                }
            }
            if (violatingRoles.size() >= ++list) continue;
            return null;
        }
        if (violatingRoles.size() >= risk.roleIds.size()) {
            return Violation.createSoDRoles2(risk, violatingRoles);
        }
        return null;
    }

    protected RiskSoDRoles() {
    }

    @Override
    public boolean loadAuth() {
        ResultSet rs = DB.getData("SELECT role_id, `list` FROM sod_role WHERE rule_id = " + this.id + " ORDER BY list;");
        int currentList = -1;
        try {
            while (rs.next()) {
                int list = rs.getInt("list");
                if (list != currentList) {
                    currentList = list;
                    this.roleIds.add(new ArrayList());
                }
                this.roleIds.get(currentList).add(rs.getInt("role_id"));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Failed while retrieving roles for critical roles risk #" + this.id);
            Log.logException(e);
        }
        return this.roleIds.size() > 0;
    }
}

