/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AnalysisUser;
import ac.analysis.AuthorizationEntry;
import ac.risk.Activity;
import ac.risk.AuthorizationBag;
import ac.risk.Functionality;
import ac.risk.Risk;
import ac.risk.ViolatingAuthorizationEntry;
import ac.risk.Violation;
import cn.Config;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class RiskSoDFunctionalities
extends Risk {
    private static final boolean OrgLvlAnalysis = Config.isFeature("orglvl_analysis", false);
    private static final ArrayList<ArrayList<ViolatingAuthorizationEntry>> functionalityCauses = new ArrayList();
    private static final ArrayList<ArrayList<ViolatingAuthorizationEntry>> tmpCauses = new ArrayList();
    Functionality[] functionalities;
    private static PreparedStatement PS_FUNCTIONALITIES = DB.prepareStatement("SELECT sod_func_id AS id FROM sod_sod_func_func WHERE risk_id = ?");
    private HashMap<Integer, Boolean> relevantObjects = new HashMap();

    @Override
    public Violation checkViolations(AnalysisUser user) {
        if (OrgLvlAnalysis && user.hasOrgLevels) {
            ArrayList<AuthorizationBag> bagsOfAuthorizations = AuthorizationBag.getBags(user.hash, user.roles, this);
            if (bagsOfAuthorizations.size() > 0) {
                return RiskSoDFunctionalities.checkForViolationsOrgLevels(this, bagsOfAuthorizations);
            }
            return RiskSoDFunctionalities.checkForViolations(this, bagsOfAuthorizations.get(0));
        }
        return RiskSoDFunctionalities.checkForViolations(this, AuthorizationBag.getBag(user.hash, user.roles));
    }

    private static Violation checkForViolations(RiskSoDFunctionalities risk, AuthorizationBag bagOfAuthorizations) {
        functionalityCauses.clear();
        for (Functionality functionality : risk.functionalities) {
            ArrayList<ViolatingAuthorizationEntry> activityCauses = new ArrayList<ViolatingAuthorizationEntry>();
            if (!Functionality.isGranted(functionality, bagOfAuthorizations, activityCauses)) {
                return null;
            }
            functionalityCauses.add(activityCauses);
        }
        return Violation.createSoDFunctionality(risk, functionalityCauses);
    }

    private static Violation checkForViolationsOrgLevels(RiskSoDFunctionalities risk, ArrayList<AuthorizationBag> bagsOfAuthorizations) {
        functionalityCauses.clear();
        for (int i = 0; i < bagsOfAuthorizations.size(); ++i) {
            AuthorizationBag bagOfAuthorizations = bagsOfAuthorizations.get(i);
            boolean riskAccess = true;
            tmpCauses.clear();
            for (Functionality functionality : risk.functionalities) {
                if (!riskAccess) continue;
                ArrayList<ViolatingAuthorizationEntry> activityCauses = new ArrayList<ViolatingAuthorizationEntry>();
                if (Functionality.isGranted(functionality, bagOfAuthorizations, activityCauses)) {
                    tmpCauses.add(activityCauses);
                    continue;
                }
                tmpCauses.clear();
                riskAccess = false;
            }
            if (!riskAccess || tmpCauses.size() <= 0) continue;
            Log.debug("RiskSoDFunctionalities " + risk.toString() + " found " + tmpCauses.size() + " causes in bag " + i + ".");
            for (ArrayList arrayList : tmpCauses) {
                functionalityCauses.add(arrayList);
            }
        }
        if (functionalityCauses.size() == 0) {
            return null;
        }
        RiskSoDFunctionalities.uniqueSoDFuncCauses(functionalityCauses);
        return Violation.createSoDFunctionality(risk, functionalityCauses);
    }

    private static void uniqueSoDFuncCauses(ArrayList<ArrayList<ViolatingAuthorizationEntry>> functionalitycauses) {
        ArrayList<ViolatingAuthorizationEntry> alreadyUsed = new ArrayList<ViolatingAuthorizationEntry>();
        ArrayList<ViolatingAuthorizationEntry> duplicates = new ArrayList<ViolatingAuthorizationEntry>();
        for (ArrayList<ViolatingAuthorizationEntry> vaes : functionalitycauses) {
            for (ViolatingAuthorizationEntry vae : vaes) {
                if (!vae.isInList(alreadyUsed)) {
                    alreadyUsed.add(vae);
                    continue;
                }
                duplicates.add(vae);
            }
            if (duplicates.size() <= 0) continue;
            vaes.removeAll(duplicates);
        }
    }

    protected RiskSoDFunctionalities() {
    }

    @Override
    public boolean loadAuth() {
        ArrayList<Functionality> funcs = new ArrayList<Functionality>();
        try {
            PS_FUNCTIONALITIES.setInt(1, this.id);
            ResultSet rs = PS_FUNCTIONALITIES.executeQuery();
            while (rs.next()) {
                funcs.add(Functionality.getById(rs.getInt(1)));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Failed while retrieving authorizations for sod_func risk #" + this.id);
            Log.logException(e);
        }
        this.functionalities = funcs.toArray(new Functionality[0]);
        boolean hasAuthorizations = false;
        for (Functionality f : this.functionalities) {
            for (Activity a : f.activities) {
                if (a.authorizationsMap.size() <= 0 && a.isNoneTcode) continue;
                hasAuthorizations = true;
            }
        }
        return this.functionalities.length > 0 && hasAuthorizations;
    }

    boolean isOrgLevelEntriesRelevant(AuthorizationEntry ae) {
        if (!this.relevantObjects.containsKey(ae.authObject_id)) {
            boolean isInActivty = false;
            for (Functionality functionality : this.functionalities) {
                for (Activity activity : functionality.activities) {
                    if (!activity.authorizationsMap.containsKey(ae.authObject_id)) continue;
                    isInActivty = true;
                }
            }
            this.relevantObjects.put(ae.authObject_id, isInActivty);
        }
        return this.relevantObjects.get(ae.authObject_id);
    }
}

