/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AnalysisRole;
import ac.analysis.AnalysisUser;
import ac.analysis.AuthObject;
import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.risk.Risk;
import ac.risk.ViolatingTcodeEntry;
import ac.risk.Violation;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class RiskCriticalTcodes
extends Risk {
    private static final ArrayList<ViolatingTcodeEntry> violationCauses = new ArrayList();
    private static final ArrayList<AuthorizationEntry> tmpAuthEntries = new ArrayList();
    private static final ArrayList<Authorization> tmpViolatingAuthorizations = new ArrayList();
    private Authorization[] tcodeAuths;
    private static final PreparedStatement PS_TCODES = DB.prepareStatement("SELECT tcode FROM sod_crit_tcode AS ct JOIN um_tcode AS t ON ct.tcode_id = t.id AND t.um_delete = 0 WHERE rule_id = ?;");
    private static int S_TCODE_ID = -1;
    private static int TCD_ID = -1;

    @Override
    public Violation checkViolations(AnalysisUser user) {
        return RiskCriticalTcodes.checkForViolationsOrgLevels(this, user.roles);
    }

    private static Violation checkForViolationsOrgLevels(RiskCriticalTcodes risk, AnalysisRole[] roles) {
        violationCauses.clear();
        for (Authorization riskAuth : risk.tcodeAuths) {
            for (AnalysisRole role : roles) {
                if (role.isComposite) {
                    for (AnalysisRole child : role.compositeChildren) {
                        for (AuthorizationEntry ae : child.authorizationEntries) {
                            if (ae.authObject_id != S_TCODE_ID) continue;
                            for (Authorization roleAuth : ae.authorizations) {
                                if (!AuthObject.isS_Field(roleAuth.field_id) || !Authorization.isGranted(roleAuth, riskAuth)) continue;
                                tmpAuthEntries.add(ae);
                                tmpViolatingAuthorizations.add(roleAuth);
                            }
                        }
                    }
                    continue;
                }
                for (AuthorizationEntry ae : role.authorizationEntries) {
                    if (ae.authObject_id != S_TCODE_ID) continue;
                    for (Authorization roleAuth : ae.authorizations) {
                        if (!AuthObject.isS_Field(roleAuth.field_id) || !Authorization.isGranted(roleAuth, riskAuth)) continue;
                        tmpAuthEntries.add(ae);
                        tmpViolatingAuthorizations.add(roleAuth);
                    }
                }
            }
            if (tmpAuthEntries.size() <= 0) continue;
            violationCauses.add(new ViolatingTcodeEntry(riskAuth, tmpAuthEntries.toArray(AuthorizationEntry.EMPTYARRAY), tmpViolatingAuthorizations.toArray(Authorization.EMPTYARRAY)));
            tmpAuthEntries.clear();
            tmpViolatingAuthorizations.clear();
        }
        return violationCauses.size() > 0 ? Violation.createCriticalTcode(risk, violationCauses.toArray(ViolatingTcodeEntry.EMPTYARRAY)) : null;
    }

    protected RiskCriticalTcodes() {
    }

    @Override
    public boolean loadAuth() {
        if (S_TCODE_ID <= 0) {
            S_TCODE_ID = AuthObject.getIdFromName("S_TCODE", this.system, this.client);
            TCD_ID = AuthObject.getFieldIdByObjectNumber(S_TCODE_ID, 1);
        }
        ArrayList<Authorization> authorizations = new ArrayList<Authorization>();
        try {
            PS_TCODES.setInt(1, this.id);
            ResultSet rs = PS_TCODES.executeQuery();
            while (rs.next()) {
                authorizations.add(Authorization.create(S_TCODE_ID, TCD_ID, rs.getString("tcode"), null));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Failed while retrieving tcodes for critical tcodes risk #" + this.id);
            Log.logException(e);
        }
        this.tcodeAuths = authorizations.toArray(Authorization.EMPTYARRAY);
        return this.tcodeAuths.length > 0;
    }

    public static String[] getActiveCritTcodes(String system, String client) {
        String[] tcodes = DB.getOneTextColumn("SELECT um_tcode.tcode AS tcode FROM um_tcode INNER JOIN sod_crit_tcode ON sod_crit_tcode.tcode_id = um_tcode.id INNER JOIN sod_rule ON sod_rule.id = sod_crit_tcode.rule_id WHERE um_tcode.system = '" + system + "' AND um_tcode.client = '" + client + "' AND \tum_tcode.um_delete = 0 AND status = 'Active' AND rule_type = 'crit_tcode';");
        return tcodes;
    }
}

