/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AnalysisRole;
import ac.analysis.AnalysisUser;
import ac.risk.Risk;
import ac.risk.ViolatingRole;
import ac.risk.Violation;
import cn.DB;
import cn.Log;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class RiskCriticalRoles
extends Risk {
    private static final ArrayList<ViolatingRole> violatingRoles = new ArrayList();
    private int[] roleIds = null;

    @Override
    public Violation checkViolations(AnalysisUser user) {
        return RiskCriticalRoles.checkForViolations(this, user.roles);
    }

    private static Violation checkForViolations(RiskCriticalRoles risk, AnalysisRole[] roles) {
        violatingRoles.clear();
        for (int roleid : risk.roleIds) {
            for (AnalysisRole assignedRole : roles) {
                if (roleid == assignedRole.id) {
                    violatingRoles.add(ViolatingRole.direct(assignedRole));
                }
                if (!assignedRole.isComposite) continue;
                for (AnalysisRole roleIndirect : assignedRole.compositeChildren) {
                    if (roleid != roleIndirect.id) continue;
                    violatingRoles.add(ViolatingRole.indirect(roleIndirect, assignedRole));
                }
            }
        }
        if (violatingRoles.size() > 0) {
            return Violation.create(risk, violatingRoles.toArray(ViolatingRole.EMPTYARRAY));
        }
        return null;
    }

    protected RiskCriticalRoles() {
    }

    @Override
    public boolean loadAuth() {
        ResultSet rs = DB.getData("SELECT role_id FROM sod_crit_role WHERE rule_id = " + this.id + ";");
        ArrayList<Integer> roleIds = new ArrayList<Integer>();
        try {
            while (rs.next()) {
                roleIds.add(rs.getInt("role_id"));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Failed while retrieving roles for critical roles risk #" + this.id);
            Log.logException(e);
        }
        this.roleIds = new int[roleIds.size()];
        for (int i = 0; i < this.roleIds.length; ++i) {
            this.roleIds[i] = (Integer)roleIds.get(i);
        }
        return this.roleIds.length > 0;
    }
}

