/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AnalysisUser;
import ac.analysis.AuthObject;
import ac.risk.Approver;
import ac.risk.AuthorizationBag;
import ac.risk.Group;
import ac.risk.RiskCriticalRoles;
import ac.risk.RiskCriticalTcodes;
import ac.risk.RiskSoDFunctionalities;
import ac.risk.RiskSoDRoles;
import ac.risk.Violation;
import cn.DB;
import cn.Log;
import cn.SapUser;
import cn.TaskParameters;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public abstract class Risk {
    private static final Risk[] EMPTYARRAY = new Risk[0];
    public static final String TYPE_SoD_Functionalities = "sod_func";
    public static final String TYPE_Critical_Tcodes = "crit_tcode";
    public static final String TYPE_Critical_Roles = "crit_role";
    public static final String TYPE_SoD_Roles = "sod_role2";
    public static final int WARNING_NONE = 0;
    public static final int WARNING_DISPLAY = 1;
    public static final int WARNING_DOCUMENTATION = 2;
    public static final int WARNING_PREVENT = 3;
    public static final int WARNING_WORKFLOW = 4;
    public int id;
    public int group_id;
    public String name;
    public String signature;
    public String system;
    public String client;
    public String mitigation;
    public String description;
    public String level;
    public int warning;
    public int text_response_id;
    public int approver_id;
    public int[] multi_approver = null;
    public int approver_minimum = 0;
    public String type;
    public boolean active;
    public boolean isAutoWorkflow = false;
    public int workflow_frequency;
    public int count;
    public String origin;
    private static HashMap<String, ArrayList<Integer>> RISK_APPROVED_USERS = null;
    private static final HashMap<Integer, Risk> LoadedRisks = new HashMap();
    private static final PreparedStatement PS_MULTIAPPROVER_IDS = DB.prepareStatement("SELECT approver_id FROM sod_risk_approver WHERE risk_id = ?;");

    public abstract Violation checkViolations(AnalysisUser var1);

    public abstract boolean loadAuth();

    public Group getGroup() {
        return Group.getById(this.group_id);
    }

    public String getMitigation() {
        return this.mitigation != null ? this.mitigation : "";
    }

    public Approver[] getMultiApprovers() {
        ArrayList<Approver> approvers = new ArrayList<Approver>();
        for (int approver_id : this.multi_approver) {
            Approver approver = Approver.getById(approver_id);
            if (approver != null) {
                approvers.add(approver);
                continue;
            }
            Log.log("Risk.getMultiApprovers retrived NULL on id " + approver_id);
        }
        return approvers.toArray(new Approver[0]);
    }

    public String toString() {
        return this.id + ", " + this.name;
    }

    public static boolean isUserApprovedForRisk(int risk_id, SapUser user) {
        if (RISK_APPROVED_USERS == null) {
            RISK_APPROVED_USERS = new HashMap();
            ResultSet rs = DB.getData("SELECT risk_id, username FROM sod_approved_user WHERE `system` = '" + user.system + "' AND `client` = '" + user.client + "';");
            try {
                while (rs.next()) {
                    String db_username = rs.getString(2);
                    int db_risk_id = rs.getInt(1);
                    if (!RISK_APPROVED_USERS.containsKey(db_username)) {
                        RISK_APPROVED_USERS.put(db_username, new ArrayList());
                    }
                    RISK_APPROVED_USERS.get(db_username).add(db_risk_id);
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("RiskUtils failed at getting approved users.");
                Log.logException(e);
            }
        }
        if (RISK_APPROVED_USERS.containsKey(user.username)) {
            for (int db_risk_id : RISK_APPROVED_USERS.get(user.username)) {
                if (db_risk_id != risk_id) continue;
                return true;
            }
        }
        return false;
    }

    public static void disApproveForRisk(int risk_id, SapUser user) {
        DB.update("DELETE FROM `sod_approved_user` WHERE risk_id = " + risk_id + " AND username = '" + user.username + "' AND `system` = '" + user.system + "' AND `client` = '" + user.client + "';");
    }

    public static String formatId(int risk_id) {
        return String.format("%05d", risk_id);
    }

    public static String[] getTypes() {
        String[] riskTypes = new String[]{TYPE_Critical_Roles, TYPE_Critical_Tcodes, TYPE_SoD_Functionalities, TYPE_SoD_Roles};
        return riskTypes;
    }

    public static String riskTypeLookUp(String risk_type) {
        switch (risk_type) {
            case "crit_role": {
                return "Critical Roles";
            }
            case "sod_role2": {
                return "SoD role";
            }
            case "crit_tcode": {
                return "Critical T-code";
            }
            case "sod_func": {
                return "SoD functionalities";
            }
        }
        return "Unknown";
    }

    public static Risk getById(int risk_id) {
        if (!LoadedRisks.containsKey(risk_id)) {
            LoadedRisks.put(risk_id, null);
            Risk[] risks = Risk.getListFromIds(new int[]{risk_id});
            if (risks != null) {
                if (risks.length > 0) {
                    if (risks[0] != null) {
                        LoadedRisks.put(risk_id, risks[0]);
                    }
                } else {
                    Log.log("ac.risk.Risk getById(" + risk_id + ") is returning empty array!");
                }
            } else {
                Log.log("ac.risk.Risk getById(" + risk_id + ") is returning NULL!");
            }
        }
        return LoadedRisks.get(risk_id);
    }

    public static Risk[] getListFromSignatures(String[] signatures, String system, String client) {
        return Risk.getListFromIds(DB.getOneNumberColumn("SELECT id FROM sod_rule WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND `signature` IN ('" + String.join((CharSequence)"','", signatures) + "');"));
    }

    public static Risk[] getListFromIds(int[] ids) {
        if (ids.length > 0) {
            String myIds = Arrays.stream(ids).mapToObj(String::valueOf).reduce((a, b) -> a.concat(",").concat((String)b)).get();
            try {
                ResultSet rs = DB.getData("SELECT sod_rule.* FROM sod_rule WHERE id IN (" + myIds + ") ORDER BY id;");
                ArrayList<RiskSoDFunctionalities> risks = new ArrayList<RiskSoDFunctionalities>();
                while (rs.next()) {
                    Risk risk;
                    String type = rs.getString("rule_type");
                    int risk_id = rs.getInt("id");
                    switch (type) {
                        case "sod_func": {
                            risk = new RiskSoDFunctionalities();
                            break;
                        }
                        case "sod_role2": {
                            risk = new RiskSoDRoles();
                            break;
                        }
                        case "crit_tcode": {
                            risk = new RiskCriticalTcodes();
                            break;
                        }
                        case "crit_role": {
                            risk = new RiskCriticalRoles();
                            break;
                        }
                        default: {
                            risk = null;
                            Log.log("ac.risk.Risk getById(" + risk_id + ") failed! Risk type (" + type + ") was not recoqnized.");
                        }
                    }
                    if (risk == null) {
                        Log.log("ac.risk.Risk getListByIds failed on id " + risk_id + " is returning NULL!");
                        continue;
                    }
                    risk.id = risk_id;
                    risk.name = rs.getString("name");
                    risk.signature = rs.getString("signature");
                    risk.system = rs.getString("system");
                    risk.client = rs.getString("client");
                    risk.group_id = rs.getInt("group_id");
                    risk.type = type;
                    risk.mitigation = rs.getString("mitigation");
                    risk.description = rs.getString("description");
                    risk.level = rs.getString("risk_level");
                    risk.warning = rs.getInt("warning_id");
                    risk.text_response_id = rs.getInt("text_response_id");
                    risk.approver_id = rs.getInt("approver_id");
                    risk.origin = rs.getString("origin");
                    risk.active = rs.getString("status").equalsIgnoreCase("Active");
                    risk.isAutoWorkflow = rs.getBoolean("workflow_autostart");
                    risk.workflow_frequency = rs.getInt("workflow_frequency");
                    risk.approver_minimum = rs.getInt("approver_minimum");
                    if (risk.warning == 4) {
                        ArrayList<Integer> approvers = new ArrayList<Integer>();
                        PS_MULTIAPPROVER_IDS.setInt(1, risk_id);
                        ResultSet app_rs = PS_MULTIAPPROVER_IDS.executeQuery();
                        while (app_rs.next()) {
                            approvers.add(app_rs.getInt(1));
                        }
                        app_rs.close();
                        risk.multi_approver = approvers.stream().mapToInt(q -> q).toArray();
                    }
                    LoadedRisks.put(risk_id, risk);
                    risks.add((RiskSoDFunctionalities)risk);
                }
                rs.close();
                return risks.toArray(EMPTYARRAY);
            }
            catch (SQLException e) {
                Log.log("ac.risk.Risk getListByIds failed! Error code: " + e.getErrorCode());
                Log.logException(e);
            }
        }
        return new Risk[0];
    }

    public static final Risk[] getActiveReportRisks(TaskParameters params) {
        Log.log("Loading S_Objects and fields.");
        AuthObject.loadS_OBJECTS(params.system, params.client);
        AuthObject.loadS_FIELDS(params.system, params.client);
        Risk[] loadedRisks = Risk.getRisksFromSettings(params);
        Log.log("Loading risk definitions for " + loadedRisks.length + " risks.");
        ArrayList<Risk> activeRisks = new ArrayList<Risk>();
        for (Risk risk : loadedRisks) {
            boolean hasDefinition = risk.loadAuth();
            if (hasDefinition) {
                activeRisks.add(risk);
                continue;
            }
            Log.log("No definition for risk " + risk.id + " " + risk.name + " " + risk.type + " though it is suppossed to be 'Active'.");
        }
        Log.log("Loaded " + activeRisks.size() + " active risks.");
        return activeRisks.toArray(new Risk[0]);
    }

    private static final Risk[] getRisksFromSettings(TaskParameters params) {
        CharSequence[] approvers;
        CharSequence[] warning_ids;
        CharSequence[] text_response_ids;
        String[] risklevels;
        CharSequence[] group_ids;
        ArrayList<Integer> retrieved_ids = new ArrayList<Integer>();
        CharSequence[] risk_signatures = params.getStringArray("rule");
        if (risk_signatures.length > 0) {
            Log.log("Loading risk signatures " + String.join((CharSequence)", ", risk_signatures) + ".");
            return Risk.getListFromSignatures((String[])risk_signatures, params.system, params.client);
        }
        Log.log("Loading risk.");
        String sql = "SELECT DISTINCT(id) AS `id` FROM sod_rule \nWHERE `system` = '" + params.system + "' AND `client` = '" + params.client + "' AND `status` = 'Active' \n";
        ArrayList<String> ruleTypes = new ArrayList<String>();
        if (params.getBoolean(TYPE_Critical_Roles)) {
            ruleTypes.add("'crit_role'");
        }
        if (params.getBoolean(TYPE_SoD_Roles)) {
            ruleTypes.add("'sod_role2'");
        }
        if (params.getBoolean(TYPE_Critical_Tcodes)) {
            ruleTypes.add("'crit_tcode'");
        }
        if (params.getBoolean(TYPE_SoD_Functionalities)) {
            ruleTypes.add("'sod_func'");
        }
        if (ruleTypes.size() > 0) {
            sql = sql + " AND `rule_type` IN (" + String.join((CharSequence)",", ruleTypes.toArray(Utils.EMPTYSTRINGARRAY)) + ")\n";
        }
        if ((group_ids = params.getStringArray("risk_groups")).length > 0) {
            sql = sql + " AND `group_id` IN (" + String.join((CharSequence)",", group_ids) + ")\n";
        }
        if ((risklevels = params.getStringArray("risklevels")).length > 0) {
            sql = sql + " AND `risk_level` IN (" + Utils.toQuotedString(risklevels) + ")\n";
        }
        if ((text_response_ids = params.getStringArray("messages")).length > 0) {
            sql = sql + " AND `text_response_id` IN (" + String.join((CharSequence)",", text_response_ids) + ")\n";
        }
        if ((warning_ids = params.getStringArray("systemreaction")).length > 0) {
            sql = sql + " AND `warning_id` IN (" + String.join((CharSequence)",", warning_ids) + ")\n";
        }
        if ((approvers = params.getStringArray("approvers")).length > 0) {
            sql = sql + " AND (`approver_id` IN (" + String.join((CharSequence)",", approvers) + ") OR ";
            sql = sql + " `id` IN (SELECT risk_id FROM sod_risk_approver WHERE approver_id IN (" + String.join((CharSequence)",", approvers) + "))";
            sql = sql + ")\n";
        }
        sql = sql + "ORDER BY `id`;";
        Log.log("Retrieving risk via statement: " + sql);
        ResultSet rs = DB.getData(sql);
        try {
            while (rs.next()) {
                retrieved_ids.add(rs.getInt(1));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("ac.report.tools.Report failed to get users from DB.");
            Log.logException(e);
        }
        int[] ids = new int[retrieved_ids.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (Integer)retrieved_ids.get(i);
        }
        return Risk.getListFromIds(ids);
    }

    public static long getTimeSpentMakingBags() {
        return TimeUnit.NANOSECONDS.toMillis(AuthorizationBag.timeSpentMakingBags);
    }
}

