/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AuthorizationEntry;
import cn.Log;
import cn.Memory;
import cn.Utils;
import java.util.ArrayList;
import java.util.HashMap;

class OrgLevelNode {
    static final OrgLevelNode[] EMPTYARRAY = new OrgLevelNode[0];
    private OrgLevelNode[] childNodes = null;
    private final AuthorizationEntry masterEntry;
    private final ArrayList<AuthorizationEntry> authorizationEntries;

    static OrgLevelNode createBaseNode(ArrayList<AuthorizationEntry> baseAuths) {
        Log.debug(Memory.statement("Creating base node with " + baseAuths.size() + " auth objects."));
        return new OrgLevelNode(baseAuths);
    }

    static OrgLevelNode[] createLevelNodes(ArrayList<AuthorizationEntry> orgLevelEntries) {
        ArrayList<OrgLevelNode> nodes = new ArrayList<OrgLevelNode>();
        for (AuthorizationEntry ae : orgLevelEntries) {
            nodes.add(new OrgLevelNode(ae, orgLevelEntries));
        }
        return nodes.toArray(EMPTYARRAY);
    }

    private OrgLevelNode(ArrayList<AuthorizationEntry> baseAuthorizationEntries) {
        this.masterEntry = null;
        this.authorizationEntries = baseAuthorizationEntries;
    }

    private OrgLevelNode(AuthorizationEntry masterEntry, ArrayList<AuthorizationEntry> orgLevelEntries) {
        this.masterEntry = masterEntry;
        this.authorizationEntries = new ArrayList();
        for (AuthorizationEntry ae : orgLevelEntries) {
            if (!ae.currentConflictingOrgLevelEntries.contains(masterEntry)) {
                this.authorizationEntries.add(ae);
                continue;
            }
            if (!Log.isDebug()) continue;
            Log.debug(Memory.statement("OrgLevelNode NOT adding conflicting entry " + masterEntry.toString() + " conflicting entry: " + ae.toString()));
        }
    }

    static void distributeToNextLevel(OrgLevelNode baseNode, ArrayList<AuthorizationEntry> levelData, String identifier) {
        Utils.uniquefyArrayList(levelData);
        if (baseNode.childNodes == null) {
            baseNode.childNodes = OrgLevelNode.createLevelNodes(levelData);
        } else {
            for (OrgLevelNode childNode : baseNode.childNodes) {
                boolean canDistribute = true;
                for (AuthorizationEntry ae : childNode.masterEntry.currentConflictingOrgLevelEntries) {
                    if (!levelData.contains(ae)) continue;
                    canDistribute = false;
                }
                if (!canDistribute) continue;
                OrgLevelNode.distributeToNextLevel(childNode, levelData, identifier);
            }
        }
    }

    ArrayList<HashMap<Integer, ArrayList<AuthorizationEntry>>> getAuthorizationEntryMaps() {
        ArrayList<HashMap<Integer, ArrayList<AuthorizationEntry>>> map = new ArrayList<HashMap<Integer, ArrayList<AuthorizationEntry>>>();
        HashMap<Integer, ArrayList<AuthorizationEntry>> nodeMap = this.mapAuthorizationEntries();
        if (this.childNodes == null) {
            map.add(nodeMap);
            return map;
        }
        for (OrgLevelNode oln : this.childNodes) {
            ArrayList<HashMap<Integer, ArrayList<AuthorizationEntry>>> childMaps = oln.getAuthorizationEntryMaps();
            for (HashMap<Integer, ArrayList<AuthorizationEntry>> childMap : childMaps) {
                for (int entry_object_id : nodeMap.keySet()) {
                    if (childMap.containsKey(entry_object_id)) {
                        for (AuthorizationEntry ae : nodeMap.get(entry_object_id)) {
                            if (childMap.get(entry_object_id).contains(ae)) continue;
                            childMap.get(entry_object_id).add(ae);
                        }
                        continue;
                    }
                    childMap.put(entry_object_id, nodeMap.get(entry_object_id));
                }
            }
            map.addAll(childMaps);
        }
        return map;
    }

    private HashMap<Integer, ArrayList<AuthorizationEntry>> mapAuthorizationEntries() {
        HashMap<Integer, ArrayList<AuthorizationEntry>> nodeMap = new HashMap<Integer, ArrayList<AuthorizationEntry>>();
        for (AuthorizationEntry ae : this.authorizationEntries) {
            if (!nodeMap.containsKey(ae.authObject_id)) {
                nodeMap.put(ae.authObject_id, new ArrayList());
            }
            nodeMap.get(ae.authObject_id).add(ae);
        }
        return nodeMap;
    }

    public String toString() {
        return this.masterEntry == null ? "BaseNode" : this.masterEntry.toString();
    }
}

