/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.risk.Risk;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class Group {
    private static final HashMap<Integer, Group> LoadedGroups = new HashMap();
    public final int id;
    public final String name;
    public final String system;
    public final String client;
    public final String rule_type;
    public int span = 0;
    private static PreparedStatement LoadGroup = null;

    private Group(int id, String name, String system, String client, String rule_type) {
        this.id = id;
        this.name = name;
        this.system = system;
        this.client = client;
        this.rule_type = rule_type;
    }

    public String toString() {
        return this.name + " (" + Risk.riskTypeLookUp(this.rule_type) + ")";
    }

    public static Group getById(int group_id) {
        if (!LoadedGroups.containsKey(group_id)) {
            if (LoadGroup == null) {
                LoadGroup = DB.prepareStatement("SELECT * FROM sod_group WHERE id = ? ;");
            }
            try {
                LoadGroup.setInt(1, group_id);
                ResultSet rs = LoadGroup.executeQuery();
                if (rs.next()) {
                    Group group = new Group(rs.getInt("id"), rs.getString("name"), rs.getString("system"), rs.getString("client"), rs.getString("rule_type"));
                    LoadedGroups.put(group_id, group);
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("ac.Group failed to retrieve group data for " + group_id);
                Log.logException(e);
            }
        }
        return LoadedGroups.get(group_id);
    }
}

