/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.risk.Activity;
import ac.risk.AuthorizationBag;
import ac.risk.ViolatingAuthorizationEntry;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class Functionality {
    private static HashMap<Integer, Functionality> LoadedFunctionalities = new HashMap();
    private static final PreparedStatement PS_loadFunctionality = DB.prepareStatement("SELECT id FROM sod_activities WHERE func_id = ? ;");
    public final int id;
    final Activity[] activities;
    private String name = null;
    private String description = null;
    private String system = null;
    private String client = null;
    private static PreparedStatement PS_loadInformation = null;

    public static boolean isGranted(Functionality functionality, AuthorizationBag bagOfAuthorizations, ArrayList<ViolatingAuthorizationEntry> activityCauses) {
        boolean anyActivityGranted = false;
        for (Activity activity : functionality.activities) {
            if (!Activity.isGranted(activity, bagOfAuthorizations, activityCauses)) continue;
            anyActivityGranted = true;
        }
        return anyActivityGranted;
    }

    public static Functionality getById(int id) {
        if (!LoadedFunctionalities.containsKey(id)) {
            LoadedFunctionalities.put(id, new Functionality(id));
        }
        return LoadedFunctionalities.get(id);
    }

    private Functionality(int id) {
        this.id = id;
        ArrayList<Activity> acts = new ArrayList<Activity>();
        try {
            PS_loadFunctionality.setInt(1, id);
            ResultSet rs = PS_loadFunctionality.executeQuery();
            while (rs.next()) {
                acts.add(new Activity(rs.getInt(1), this));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Failed to read Activities in Functionality " + this.id);
            Log.logException(e);
        }
        this.activities = acts.toArray(new Activity[0]);
        Functionality.loadInformation(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSystem() {
        return this.system;
    }

    public String getClient() {
        return this.client;
    }

    private static void loadInformation(Functionality functionality) {
        if (PS_loadInformation == null) {
            PS_loadInformation = DB.prepareStatement("SELECT `name`, `description`, `system`, `client` FROM sod_functionalities WHERE id = ?;");
        }
        try {
            PS_loadInformation.setInt(1, functionality.id);
            ResultSet rs = PS_loadInformation.executeQuery();
            while (rs.next()) {
                functionality.name = rs.getString(1);
                functionality.description = rs.getString(2);
                functionality.system = rs.getString(3);
                functionality.client = rs.getString(4);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Functionality failed to set id to load information.");
            Log.logException(e);
        }
    }

    public String toString() {
        String s = this.id + " " + this.name + ", ";
        for (Activity a : this.activities) {
            s = s + a.toString() + "\t";
        }
        return this.id + " " + this.name + "\t" + s;
    }
}

