/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AnalysisRole;
import ac.analysis.AuthObject;
import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.analysis.OrgLevel;
import ac.risk.OrgLevelNode;
import ac.risk.RiskSoDFunctionalities;
import cn.Log;
import cn.Memory;
import cn.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

class AuthorizationBag {
    static long timeSpentMakingBags = 0L;
    private static final ArrayList<AuthorizationBag> CURRENT_BAGS = new ArrayList();
    private static AuthorizationBag CURRENT_BAG;
    private static String CURRENT_HASH;
    final HashMap<Integer, ArrayList<AuthorizationEntry>> authorizationEntries;
    private static final HashMap<Integer, ArrayList<AuthorizationEntry>> tmpMap;
    private static final HashMap<Integer, ArrayList<AuthorizationEntry>> orgLvlEntries;
    private static final ArrayList<Integer> varblToRemove;
    private static final ArrayList<Authorization> alreadyIncluded;
    private static final ArrayList<AuthorizationEntry> baseAuths;

    static AuthorizationBag getBag(String roleHash, AnalysisRole[] roles) {
        if (roleHash.contentEquals(CURRENT_HASH)) {
            return CURRENT_BAG;
        }
        long start = System.nanoTime();
        CURRENT_HASH = roleHash;
        CURRENT_BAG = new AuthorizationBag(AuthorizationBag.mergeAuthorizations(roles));
        timeSpentMakingBags += System.nanoTime() - start;
        return CURRENT_BAG;
    }

    static ArrayList<AuthorizationBag> getBags(String roleHash, AnalysisRole[] roles, RiskSoDFunctionalities risk) {
        long start = System.nanoTime();
        AuthorizationBag.mergeAuthorizationsBasedOnOrgLvls(risk, roles);
        timeSpentMakingBags += System.nanoTime() - start;
        if (CURRENT_BAGS.size() > 1) {
            Log.debug(Memory.statement("Created " + CURRENT_BAGS.size() + " bags of authorizations in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms for risk " + risk.toString()));
        }
        return CURRENT_BAGS;
    }

    private AuthorizationBag(HashMap<Integer, ArrayList<AuthorizationEntry>> authEntries) {
        this.authorizationEntries = authEntries;
    }

    private static HashMap<Integer, ArrayList<AuthorizationEntry>> mergeAuthorizations(AnalysisRole[] roles) {
        tmpMap.clear();
        for (AnalysisRole role : roles) {
            if (role.isComposite) {
                for (AnalysisRole child : role.compositeChildren) {
                    for (AuthorizationEntry ae : child.authorizationEntries) {
                        ae.fromComposite = role;
                        if (!tmpMap.containsKey(ae.authObject_id)) {
                            tmpMap.put(ae.authObject_id, new ArrayList());
                        }
                        tmpMap.get(ae.authObject_id).add(ae);
                    }
                }
                continue;
            }
            for (AuthorizationEntry ae : role.authorizationEntries) {
                ae.fromComposite = null;
                if (!tmpMap.containsKey(ae.authObject_id)) {
                    tmpMap.put(ae.authObject_id, new ArrayList());
                }
                tmpMap.get(ae.authObject_id).add(ae);
            }
        }
        return tmpMap;
    }

    private static void mergeAuthorizationsBasedOnOrgLvls(RiskSoDFunctionalities risk, AnalysisRole[] roles) {
        CURRENT_BAGS.clear();
        orgLvlEntries.clear();
        baseAuths.clear();
        for (AnalysisRole role : roles) {
            if (role.isComposite) {
                for (AnalysisRole child : role.compositeChildren) {
                    if (child.hasOrgLvlAuthEntries) {
                        AuthorizationBag.addToOrgLvlEntries(risk, child.authorizationEntries);
                        continue;
                    }
                    Utils.addArrayToArrayList(baseAuths, child.authorizationEntries);
                }
                continue;
            }
            if (role.hasOrgLvlAuthEntries) {
                AuthorizationBag.addToOrgLvlEntries(risk, role.authorizationEntries);
                continue;
            }
            Utils.addArrayToArrayList(baseAuths, role.authorizationEntries);
        }
        alreadyIncluded.clear();
        AuthorizationBag.findOrgLvlConflicts();
        AuthorizationBag.cleanUpOrgLevels();
        AuthorizationBag.createBags();
        if (Log.isDebug()) {
            Log.debug(Memory.statement("AuthorizationBag made " + CURRENT_BAGS.size() + " bags in " + orgLvlEntries.keySet().size() + " levels for risk " + risk.toString()));
            int i = 0;
            for (AuthorizationBag ab : CURRENT_BAGS) {
                Log.debug(Memory.statement("AuthorizationBag " + i + " content:"));
                for (ArrayList<AuthorizationEntry> aae : ab.authorizationEntries.values()) {
                    for (AuthorizationEntry ae : aae) {
                        Log.debug("bag " + i + " contain: " + ae.toString());
                    }
                }
                ++i;
            }
        }
    }

    private static void addToOrgLvlEntries(RiskSoDFunctionalities risk, AuthorizationEntry[] roleAuthorizationEntries) {
        for (AuthorizationEntry ae : roleAuthorizationEntries) {
            boolean includeInBaseAuths = true;
            if (ae.org_lvl_analysis != null && risk.isOrgLevelEntriesRelevant(ae)) {
                for (Authorization a : ae.org_lvl_analysis) {
                    if (OrgLevel.isInList(alreadyIncluded, a)) continue;
                    if (!orgLvlEntries.containsKey(a.field_id)) {
                        orgLvlEntries.put(a.field_id, new ArrayList());
                    }
                    orgLvlEntries.get(a.field_id).add(ae);
                    alreadyIncluded.add(a);
                    includeInBaseAuths = false;
                    Log.debug("putting in orgLvlEntries " + ae.toString() + " because of " + a.toString());
                }
            }
            if (!includeInBaseAuths) continue;
            baseAuths.add(ae);
        }
    }

    private static void findOrgLvlConflicts() {
        for (int varbl_field_id : orgLvlEntries.keySet()) {
            if (orgLvlEntries.get(varbl_field_id).size() <= 1) continue;
            for (AuthorizationEntry oae : orgLvlEntries.get(varbl_field_id)) {
                oae.currentConflictingOrgLevelEntries.clear();
                for (AuthorizationEntry oea2 : orgLvlEntries.get(varbl_field_id)) {
                    if (oae == oea2) continue;
                    for (Authorization a : oae.org_lvl_analysis) {
                        for (Authorization a2 : oea2.org_lvl_analysis) {
                            if (a.field_id != varbl_field_id || a2.field_id != varbl_field_id || Authorization.isGranted(a2, a) || oae.currentConflictingOrgLevelEntries.contains(oea2)) continue;
                            oae.currentConflictingOrgLevelEntries.add(oea2);
                        }
                    }
                }
            }
            orgLvlEntries.put(varbl_field_id, (ArrayList)Utils.unique((Collection)orgLvlEntries.get(varbl_field_id)));
        }
    }

    private static void cleanUpOrgLevels() {
        for (int varbl_field_id : orgLvlEntries.keySet()) {
            if (orgLvlEntries.get(varbl_field_id).size() < 2) {
                varblToRemove.add(varbl_field_id);
                continue;
            }
            ArrayList<AuthorizationEntry> toRemove = new ArrayList<AuthorizationEntry>();
            for (AuthorizationEntry oae : orgLvlEntries.get(varbl_field_id)) {
                if (oae.currentConflictingOrgLevelEntries.size() != 0) continue;
                toRemove.add(oae);
            }
            for (AuthorizationEntry oae : toRemove) {
                Log.debug("AuthorizationBag going to remove " + oae.toString() + " in varbl_field_id " + varbl_field_id + " as there are less than 2 entries.");
                orgLvlEntries.get(varbl_field_id).remove(oae);
                baseAuths.add(oae);
            }
        }
        for (int varbl_field_id : orgLvlEntries.keySet()) {
            if (orgLvlEntries.get(varbl_field_id).size() >= 2) continue;
            varblToRemove.add(varbl_field_id);
            Log.debug("AuthorizationBag going to remove varbl_field_id " + varbl_field_id + " as there are less than 2 entries.");
        }
        if (varblToRemove.size() > 0) {
            Utils.uniquefyArrayList(varblToRemove);
            for (int varbl_field_id : varblToRemove) {
                if (orgLvlEntries.get(varbl_field_id) == null) {
                    Log.debug("AuthorizationBag trying to remove varbl_field_id " + varbl_field_id + " but returns NULL.");
                } else {
                    Log.debug("AuthorizationBag removing varbl_field_id " + varbl_field_id + " " + orgLvlEntries.get(varbl_field_id).size() + " entries.");
                    for (AuthorizationEntry ae : orgLvlEntries.get(varbl_field_id)) {
                        baseAuths.add(ae);
                    }
                }
                orgLvlEntries.remove(varbl_field_id);
            }
            varblToRemove.clear();
        }
    }

    private static void createBags() {
        OrgLevelNode baseNode = OrgLevelNode.createBaseNode(baseAuths);
        for (int key : orgLvlEntries.keySet()) {
            OrgLevelNode.distributeToNextLevel(baseNode, orgLvlEntries.get(key), AuthObject.getFieldById(key));
        }
        ArrayList<HashMap<Integer, ArrayList<AuthorizationEntry>>> fullListOfMaps = baseNode.getAuthorizationEntryMaps();
        for (HashMap<Integer, ArrayList<AuthorizationEntry>> map : fullListOfMaps) {
            CURRENT_BAGS.add(new AuthorizationBag(map));
        }
    }

    static {
        CURRENT_HASH = "";
        tmpMap = new HashMap();
        orgLvlEntries = new HashMap();
        varblToRemove = new ArrayList();
        alreadyIncluded = new ArrayList();
        baseAuths = new ArrayList();
    }
}

