/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import cn.DB;
import cn.Log;
import cn.SapUser;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class Approver {
    private static final PreparedStatement PS_APPROVER = DB.prepareStatement("SELECT * FROM sod_approvers WHERE id = ?;");
    private static final HashMap<Integer, Approver> LOADED_APPROVERS = new HashMap();
    final int id;
    public final String user;
    public final String approver;
    public final String email;
    public final String substitute;
    public final String system;
    public final String client;
    private String asString = null;

    public static Approver getById(int id) {
        if (!LOADED_APPROVERS.containsKey(id)) {
            try {
                PS_APPROVER.setInt(1, id);
                ResultSet rs = PS_APPROVER.executeQuery();
                while (rs.next()) {
                    LOADED_APPROVERS.put(id, new Approver(id, rs.getString("user"), rs.getString("approver"), rs.getString("email"), rs.getString("substitute"), rs.getString("system"), rs.getString("client")));
                }
                rs.close();
            }
            catch (SQLException e) {
                Log.log("ac.Risk.Approver FAILED loading id " + id);
                Log.logException(e);
            }
        }
        return LOADED_APPROVERS.get(id);
    }

    private Approver(int id, String user, String approver, String email, String substitute, String system, String client) {
        this.id = id;
        this.user = user;
        this.approver = approver;
        this.substitute = substitute;
        this.system = system;
        this.client = client;
        if (Utils.isEmpty(email)) {
            SapUser asUser = new SapUser(user, system, client);
            email = asUser.getEmail();
        }
        this.email = email;
    }

    public String toJsonObject() {
        return "{\"username\":\"" + this.getUser() + "\",\"email\":\"" + this.email + "\"}";
    }

    public String toString() {
        if (Utils.isEmpty(this.asString)) {
            StringBuilder sb = new StringBuilder(this.approver);
            if (!Utils.isEmpty(this.getUser())) {
                sb.append(" ");
                sb.append(this.getUser());
            }
            if (!Utils.isEmpty(this.approver)) {
                sb.append(" ");
                sb.append("(");
                sb.append(this.approver);
                sb.append(")");
            }
            this.asString = sb.toString();
        }
        return this.asString;
    }

    public String stringFormatNotificatioon() {
        if (Utils.isEmpty(this.asString)) {
            StringBuilder sb = new StringBuilder(this.approver);
            if (!Utils.isEmpty(this.getUser())) {
                sb.append(" ");
                sb.append(this.getUser());
            }
            if (!Utils.isEmpty(this.approver)) {
                sb.append(" ");
                sb.append("(");
                sb.append(this.system);
                sb.append("/");
                sb.append(this.client);
                sb.append(")");
            }
            this.asString = sb.toString();
        }
        return this.asString;
    }

    public String getUser() {
        return this.user;
    }
}

