/*
 * Decompiled with CFR 0.152.
 */
package ac.risk;

import ac.analysis.AuthObject;
import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.risk.AuthorizationBag;
import ac.risk.Functionality;
import ac.risk.ViolatingAuthorizationEntry;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class Activity {
    private static final ArrayList<Authorization> grantingTcodeAuths = new ArrayList();
    private static final ArrayList<ViolatingAuthorizationEntry> grantingEntries = new ArrayList();
    private static final ArrayList<Authorization> grantingAuthorizations = new ArrayList();
    private static final ArrayList<Authorization> tmpAuths = new ArrayList();
    public final HashMap<Integer, AuthorizationEntry> authorizationsMap = new HashMap();
    public final Functionality functionality;
    public Authorization tcodeAuth = null;
    public final int id;
    public boolean isNoneTcode = false;
    private static final PreparedStatement PS_loadActivity = DB.prepareStatement("SELECT object_id, field_number, val_low, val_high FROM sod_activity_fieldvalues WHERE act_id = ? AND IFNULL(CHAR_LENGTH(TRIM(val_low)), 0) > 0 ORDER BY object_id, field_number;");

    public static boolean isGranted(Activity activity, AuthorizationBag bagOfAuth, ArrayList<ViolatingAuthorizationEntry> causingAuthorizations) {
        grantingEntries.clear();
        grantingTcodeAuths.clear();
        grantingAuthorizations.clear();
        if (!activity.isNoneTcode && bagOfAuth.authorizationEntries.containsKey(activity.tcodeAuth.object_id)) {
            for (AuthorizationEntry bagTcodeAuthEntry : bagOfAuth.authorizationEntries.get(activity.tcodeAuth.object_id)) {
                for (Authorization bagTcodeAuth : bagTcodeAuthEntry.authorizations) {
                    if (bagTcodeAuth.field_id != activity.tcodeAuth.field_id || !Authorization.isGranted(bagTcodeAuth, activity.tcodeAuth)) continue;
                    grantingTcodeAuths.add(bagTcodeAuth);
                }
                if (grantingTcodeAuths.size() <= 0) continue;
                grantingEntries.add(new ViolatingAuthorizationEntry(activity, bagTcodeAuthEntry, grantingTcodeAuths.toArray(Authorization.EMPTYARRAY)));
                grantingTcodeAuths.clear();
            }
        }
        if (activity.isNoneTcode || grantingEntries.size() > 0) {
            if (activity.authorizationsMap.size() > 0) {
                for (Integer risk_object_id : activity.authorizationsMap.keySet()) {
                    boolean authGranted = false;
                    if (bagOfAuth.authorizationEntries.containsKey(risk_object_id)) {
                        for (AuthorizationEntry ae : bagOfAuth.authorizationEntries.get(risk_object_id)) {
                            for (Authorization riskAuth : activity.authorizationsMap.get((Object)risk_object_id).authorizations) {
                                for (Authorization roleAuth : ae.authorizations) {
                                    if (riskAuth.field_id != roleAuth.field_id || !Authorization.isGranted(roleAuth, riskAuth)) continue;
                                    grantingAuthorizations.add(roleAuth);
                                }
                            }
                            if (grantingAuthorizations.size() <= 0) continue;
                            boolean isAllPresent = true;
                            for (Authorization a : activity.authorizationsMap.get((Object)risk_object_id).authorizations) {
                                boolean fieldPresent = false;
                                for (Authorization ra : grantingAuthorizations) {
                                    if (a.field_id != ra.field_id) continue;
                                    fieldPresent = true;
                                }
                                if (fieldPresent) continue;
                                isAllPresent = false;
                            }
                            if (isAllPresent) {
                                grantingEntries.add(new ViolatingAuthorizationEntry(activity, ae, grantingAuthorizations.toArray(Authorization.EMPTYARRAY)));
                                authGranted = true;
                            }
                            grantingAuthorizations.clear();
                        }
                    }
                    if (authGranted) continue;
                    return false;
                }
                causingAuthorizations.addAll(grantingEntries);
                return true;
            }
            if (!activity.isNoneTcode) {
                causingAuthorizations.addAll(grantingEntries);
                return true;
            }
        }
        return false;
    }

    Activity(int id, Functionality functionality) {
        this.id = id;
        this.functionality = functionality;
        int current_object_id = -1;
        try {
            PS_loadActivity.setInt(1, id);
            ResultSet rs = PS_loadActivity.executeQuery();
            while (rs.next()) {
                int object_id = rs.getInt(1);
                int field_number = rs.getInt(2);
                int field_id = AuthObject.getFieldIdByObjectNumber(object_id, field_number);
                String low = rs.getString(3);
                String high = rs.getString(4);
                if (AuthObject.isS_Object(object_id) && AuthObject.isS_Field(field_id)) {
                    if (low == null) continue;
                    this.tcodeAuth = Authorization.create(object_id, field_id, low, high);
                    continue;
                }
                if (current_object_id != object_id) {
                    if (tmpAuths.size() > 0) {
                        if (this.authorizationsMap.put(current_object_id, new AuthorizationEntry(current_object_id, tmpAuths.toArray(Authorization.EMPTYARRAY))) != null) {
                            Log.log("FATAL ERROR WHEN READING ACTIVITY " + this.id + " in functionality " + this.functionality.getName() + ". " + current_object_id + " AuthorizationEntry HAS BEEN OVERWRITTEN!!!");
                        }
                        tmpAuths.clear();
                    }
                    current_object_id = object_id;
                }
                tmpAuths.add(Authorization.create(object_id, field_id, low, high));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Failed to load activity " + id);
            Log.logException(e);
        }
        if (tmpAuths.size() > 0) {
            if (this.authorizationsMap.put(current_object_id, new AuthorizationEntry(current_object_id, tmpAuths.toArray(Authorization.EMPTYARRAY))) != null) {
                Log.log("FATAL ERROR WHEN READING ACTIVITY " + this.id + " in functionality " + this.functionality.getName() + ". " + current_object_id + " AuthorizationEntry HAS BEEN OVERWRITTEN!!!");
            }
            tmpAuths.clear();
        }
        if (this.tcodeAuth == null) {
            this.isNoneTcode = true;
        }
    }

    public String toString() {
        Object s = "";
        for (AuthorizationEntry ae : this.authorizationsMap.values()) {
            for (Authorization a : ae.authorizations) {
                s = (String)s + a.toString() + "\t";
            }
        }
        return this.isNoneTcode ? "NONE TCODE\t" + (String)s : this.tcodeAuth.low + "\t" + (String)s;
    }
}

