/*
 * Decompiled with CFR 0.152.
 */
package ac.report.tools;

import cn.Log;
import cn.TaskParameters;

public class Settings
extends TaskParameters {
    private final boolean isUserReport;

    public Settings(String data) {
        super(data);
        String reportType = this.getString("reportType");
        if (reportType == null) {
            this.isUserReport = true;
            Log.log("Param reportType is NULL. Assuming user report - isUserReport param has been set to \"+this.isUserReport");
        } else {
            this.isUserReport = !reportType.equalsIgnoreCase("roles");
            Log.debug("Param reportType is '" + reportType + "' - isUserReport param has been set to " + this.isUserReport);
        }
    }

    public boolean isSummary() {
        return this.getBoolean("summeryOnly");
    }

    public boolean isUserReport() {
        return this.isUserReport;
    }

    public boolean isDashboardReport() {
        return this.getBoolean("dashboardreport");
    }

    public void setLanguageISO(String isoString) {
        this.params.put("language", (Object)isoString);
    }

    public void setRisks(String[] risk_signatures) {
        this.params.put("rule", (Object)risk_signatures);
    }

    public void setSummary(boolean isSummary) {
        this.params.put("summeryOnly", (Object)(isSummary ? "X" : ""));
    }
}

