/*
 * Decompiled with CFR 0.152.
 */
package ac.report.tools;

import ac.report.PreventiveCheckLog;
import ac.risk.Risk;
import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class PreventiveCheckDetails {
    public final String risk_ids;
    public final String risks;
    public final String usernames;
    public final String approvers;
    public boolean approved = false;
    private static PreparedStatement PC_SUMMARY = null;
    private static PreparedStatement PC_DETAILS = null;

    private PreventiveCheckDetails(String risk_ids, String risks, String usernames, String approvers) {
        String[] approverss;
        String approverString;
        risk_ids = risk_ids == null ? "" : risk_ids;
        risks = risks == null ? "" : risks;
        usernames = usernames == null ? "" : usernames;
        approvers = approvers == null ? "" : approvers;
        this.risk_ids = risk_ids;
        this.risks = risks.length() > 1000 ? risks.substring(0, 1000) + "..." : risks;
        this.approvers = approvers.length() > 0 ? ((approverString = String.join((CharSequence)", ", Utils.unique(approverss = approvers.split(",")))).length() > 1000 ? approverString.substring(0, 1000) + "..." : approverString) : approvers;
        if (usernames.length() > 0) {
            String[] users = usernames.split(",");
            Object userString = String.join((CharSequence)", ", Utils.unique(users));
            if (((String)userString).length() > 1000) {
                userString = ((String)userString).substring(0, 1000) + "...";
            }
            this.usernames = userString;
        } else {
            this.usernames = usernames;
        }
    }

    public static PreventiveCheckDetails getPreventiveCheckDetailsSummary(String handle, String system, String client) {
        PreventiveCheckDetails pcd = new PreventiveCheckDetails("", "", "", "");
        if (PC_SUMMARY == null) {
            String violationTable = PreventiveCheckLog.getTablenameViolation(system, client);
            PC_SUMMARY = DB.prepareStatement("SELECT GROUP_CONCAT(rule_id) AS risk_ids, GROUP_CONCAT(rule_name) AS risks, GROUP_CONCAT(username) AS usernames, GROUP_CONCAT(approver) AS approvers \nFROM " + violationTable + " WHERE handle = ?;");
        }
        try {
            PC_SUMMARY.setString(1, handle);
            ResultSet rs = PC_SUMMARY.executeQuery();
            while (rs.next()) {
                String risk_ids = rs.getString(1);
                String risks = rs.getString(2);
                String users = rs.getString(3);
                String approvers = rs.getString(4);
                pcd = new PreventiveCheckDetails(risk_ids, risks, users == null ? "" : (users.equals("dummy") ? "" : users), approvers);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Trouble getting summary details for handle: " + handle);
            Log.logException(e);
        }
        return pcd;
    }

    public static PreventiveCheckDetails[] getPreventiveCheckDetails(String handle, String system, String client) {
        ArrayList<PreventiveCheckDetails> pcds = new ArrayList<PreventiveCheckDetails>();
        if (PC_DETAILS == null) {
            String violationTable = PreventiveCheckLog.getTablenameViolation(system, client);
            PC_DETAILS = DB.prepareStatement("SELECT rule_id, rule_name, username, approver, approved \nFROM " + violationTable + " WHERE handle = ?;");
        }
        try {
            PC_DETAILS.setString(1, handle);
            ResultSet rs = PC_DETAILS.executeQuery();
            while (rs.next()) {
                String risk_id = rs.getString(1) != null ? Risk.formatId(rs.getInt(1)) : "";
                String risk = rs.getString(2);
                String user = rs.getString(3);
                String approver = rs.getString(4);
                PreventiveCheckDetails pcd = new PreventiveCheckDetails(risk_id, risk, user == null ? "" : (user.equals("dummy") ? "" : user), approver);
                pcd.approved = rs.getBoolean(5);
                pcds.add(pcd);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("Trouble getting details for handle: " + handle);
            Log.logException(e);
        }
        return pcds.toArray(new PreventiveCheckDetails[0]);
    }
}

