/*
 * Decompiled with CFR 0.152.
 */
package ac.report.standard;

import ac.analysis.AnalysisUser;
import ac.analysis.AuthObject;
import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.report.RiskOutputHelper;
import ac.report.standard.Report;
import ac.report.standard.ReportHelper;
import ac.report.tools.Settings;
import ac.risk.Risk;
import ac.risk.ViolatingAuthorizationEntry;
import ac.risk.ViolatingRole;
import ac.risk.ViolatingTcodeEntry;
import ac.risk.Violation;
import cn.Log;
import cn.Utils;
import cn.report.CSVline;
import cn.task.Task;
import java.util.ArrayList;

class ReportSummary
extends Report {
    private static final ArrayList<String[]> lastViolations = new ArrayList();
    private static final ArrayList<String> rolenames = new ArrayList();
    private static final ArrayList<String> tempRolenames = new ArrayList();
    private static final ArrayList<String> composites = new ArrayList();
    private static final ArrayList<String> roleDescrp = new ArrayList();
    private static final ArrayList<Integer> roleAssignments = new ArrayList();
    private static final ArrayList<String> roleSapStar = new ArrayList();
    private static final ArrayList<String> functionalities = new ArrayList();
    private static final ArrayList<String> tcodes = new ArrayList();
    private static final ArrayList<String> orgLevels = new ArrayList();
    private static final ArrayList<String> tempTcodes = new ArrayList();
    private static final ArrayList<String> reportContent = new ArrayList();

    ReportSummary(Task task, Settings params) {
        super(task, params);
    }

    @Override
    public final boolean violationFound(AnalysisUser user, Violation[] violations) {
        boolean continueReport = true;
        if (violations.length > 0) {
            long startTime = System.nanoTime();
            this.task.setStatusDetails(this.translator.getText("{1} has {2} in {3} roles", new String[]{user.username, "" + violations.length, "" + user.roles.length}));
            continueReport = ReportSummary.handleViolations(this, user, violations);
            this.timeSpentWriting += System.nanoTime() - startTime;
        }
        return continueReport;
    }

    private static final boolean handleViolations(ReportSummary report, AnalysisUser user, Violation[] violations) {
        if (report.params.isUserReport()) {
            String[] userinfo = ReportHelper.getUserInfo(user, report.translator, report.params);
            if (CURRENT_HASH.contentEquals(user.hash)) {
                for (int i = 0; i < violations.length; ++i) {
                    ++report.currentNo;
                    report.currentLine.addFormatted(ReportHelper.getRiskInfo(violations[i], report.translator, report.params));
                    report.currentLine.addFormatted(userinfo);
                    if (report.params.getBoolean("showUserApprovedForRisk")) {
                        report.currentLine.add(Risk.isUserApprovedForRisk(violations[i].risk.id, user) ? report.translator.getText("Approved") : report.translator.getText("Not approved"));
                    }
                    report.currentLine.addFormatted(lastViolations.get(i));
                    if (report.output()) continue;
                    Log.log("Returning false on buffered output on " + user.toString());
                    return false;
                }
            } else {
                CURRENT_HASH = user.hash;
                lastViolations.clear();
                for (Violation violation : violations) {
                    ++report.currentNo;
                    report.currentLine.addFormatted(ReportHelper.getRiskInfo(violation, report.translator, report.params));
                    report.currentLine.addFormatted(userinfo);
                    if (report.params.getBoolean("showUserApprovedForRisk")) {
                        report.currentLine.add(Risk.isUserApprovedForRisk(violation.risk.id, user) ? report.translator.getText("Approved") : report.translator.getText("Not approved"));
                    }
                    String[] contentLine = ReportSummary.handleViolation(report, violation);
                    for (int i = 0; i < contentLine.length; ++i) {
                        contentLine[i] = CSVline.formatCSVcontent(contentLine[i]);
                    }
                    report.currentLine.addFormatted(contentLine);
                    lastViolations.add(contentLine);
                    if (report.output()) continue;
                    Log.log("Returning false on regular output on " + user.toString());
                    return false;
                }
            }
        } else {
            for (Violation violation : violations) {
                ++report.currentNo;
                report.currentLine.addFormatted(ReportHelper.getRiskInfo(violation, report.translator, report.params));
                report.currentLine.add(ReportSummary.handleViolation(report, violation));
                if (report.output()) continue;
                Log.log("Returning false on role report output on " + user.toString());
                return false;
            }
        }
        return true;
    }

    private static final String[] handleViolation(ReportSummary report, Violation violation) {
        reportContent.clear();
        rolenames.clear();
        composites.clear();
        functionalities.clear();
        tcodes.clear();
        roleAssignments.clear();
        roleDescrp.clear();
        orgLevels.clear();
        switch (violation.risk.type) {
            case "sod_func": {
                tempTcodes.clear();
                ViolatingAuthorizationEntry[][] violatingAuthorizationEntryArray = violation.violatingAuthorizationEntries;
                int n = violatingAuthorizationEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    ViolatingAuthorizationEntry[] vaes;
                    for (ViolatingAuthorizationEntry vae : vaes = violatingAuthorizationEntryArray[i]) {
                        functionalities.add(vae.activity.functionality.getName());
                        for (Authorization a : vae.violatingAuthorizations) {
                            String org_lvl_fill;
                            if (AuthObject.isS_Object(a.object_id)) {
                                if (a.high.length() > 0) {
                                    tempTcodes.add(RiskOutputHelper.getActivityTcode(vae.activity, report.translator) + "(" + a.low + "-" + a.high + ")");
                                } else {
                                    tempTcodes.add(RiskOutputHelper.getActivityTcode(vae.activity, report.translator) + "(" + a.low + ")");
                                }
                            }
                            if (!report.params.getBoolean("showOrgLevels") || vae.violatingEntry.org_lvl_analysis == null || Utils.isEmpty(org_lvl_fill = RiskOutputHelper.getOrgLevelAuth(vae.violatingEntry.authorizations))) continue;
                            orgLevels.add(org_lvl_fill);
                        }
                        rolenames.add(vae.violatingEntry.role == null ? report.translator.getText("Unknown role") : vae.violatingEntry.role.name);
                        if (vae.violatingEntry.fromComposite != null) {
                            composites.add(vae.violatingEntry.fromComposite.name);
                        }
                        if (!report.params.isUserReport() && report.params.getBoolean("showRoleDescription")) {
                            roleDescrp.add(vae.violatingEntry.fromComposite == null ? vae.violatingEntry.role.getDescription() : vae.violatingEntry.fromComposite.getDescription());
                        }
                        if (!report.params.isUserReport() && report.params.getBoolean("showRoleAssignment")) {
                            roleAssignments.add(vae.violatingEntry.fromComposite == null ? vae.violatingEntry.role.assignments : vae.violatingEntry.fromComposite.assignments);
                        }
                        if (report.params.isUserReport() || !report.params.getBoolean("showRoleSapStar")) continue;
                        roleSapStar.add(vae.violatingEntry.fromComposite == null ? vae.violatingEntry.role.getSapStarLicense(report.translator) : vae.violatingEntry.fromComposite.getSapStarLicense(report.translator));
                    }
                    if (tempTcodes.size() <= 0) continue;
                    tcodes.add(String.join((CharSequence)",", Utils.unique(tempTcodes).toArray(Utils.EMPTYSTRINGARRAY)));
                    tempTcodes.clear();
                }
                reportContent.add(String.join((CharSequence)", ", Utils.unique(rolenames)));
                reportContent.add(String.join((CharSequence)", ", Utils.unique(composites)));
                break;
            }
            case "crit_tcode": {
                for (ViolatingTcodeEntry vte : violation.causesTcode) {
                    for (AuthorizationEntry ae : vte.violatingEntry) {
                        rolenames.add(ae.role.name);
                        if (ae.fromComposite != null) {
                            composites.add(ae.fromComposite.name);
                        }
                        if (!report.params.isUserReport() && report.params.getBoolean("showRoleDescription")) {
                            roleDescrp.add(ae.fromComposite == null ? ae.role.getDescription() : ae.fromComposite.getDescription());
                        }
                        if (!report.params.isUserReport() && report.params.getBoolean("showRoleAssignment")) {
                            roleAssignments.add(ae.fromComposite == null ? ae.role.assignments : ae.fromComposite.assignments);
                        }
                        if (!report.params.isUserReport() && report.params.getBoolean("showRoleSapStar")) {
                            roleSapStar.add(ae.fromComposite == null ? ae.role.getSapStarLicense(report.translator) : ae.fromComposite.getSapStarLicense(report.translator));
                        }
                        tempTcodes.add(ReportHelper.getViolatingTcodeDetails(vte.violatingAuthorizations));
                    }
                    if (tempTcodes.size() <= 0) continue;
                    tcodes.add(vte.tcodeAuthorization.low + "(" + String.join((CharSequence)",", Utils.unique(tempTcodes).toArray(Utils.EMPTYSTRINGARRAY)) + ")");
                    tempTcodes.clear();
                }
                reportContent.add(String.join((CharSequence)", ", Utils.unique(rolenames)));
                reportContent.add(String.join((CharSequence)", ", Utils.unique(composites)));
                break;
            }
            case "crit_role": 
            case "sod_role2": {
                for (ViolatingRole[] vrs : violation.causesRole) {
                    tempRolenames.clear();
                    for (ViolatingRole vr : vrs) {
                        if (vr.role != null) {
                            tempRolenames.add(vr.role.name);
                        }
                        if (vr.composite != null) {
                            composites.add(vr.composite.name);
                        }
                        if (!report.params.isUserReport() && report.params.getBoolean("showRoleDescription")) {
                            roleDescrp.add(vr.composite == null ? vr.role.getDescription() : vr.composite.getDescription());
                        }
                        if (!report.params.isUserReport() && report.params.getBoolean("showRoleAssignment")) {
                            roleAssignments.add(vr.composite == null ? vr.role.assignments : vr.composite.assignments);
                        }
                        if (report.params.isUserReport() || !report.params.getBoolean("showRoleSapStar")) continue;
                        roleSapStar.add(vr.composite == null ? vr.role.getSapStarLicense(report.translator) : vr.composite.getSapStarLicense(report.translator));
                    }
                    if (tempRolenames.size() <= 0) continue;
                    rolenames.add(String.join((CharSequence)",", Utils.unique(tempRolenames).toArray(Utils.EMPTYSTRINGARRAY)));
                }
                reportContent.add(String.join((CharSequence)" | ", Utils.unique(rolenames)));
                reportContent.add(String.join((CharSequence)", ", Utils.unique(composites)));
            }
        }
        if (!report.params.isUserReport() && report.params.getBoolean("showRoleDescription")) {
            reportContent.add(String.join((CharSequence)"", roleDescrp.toArray(Utils.EMPTYSTRINGARRAY)));
        }
        if (!report.params.isUserReport() && report.params.getBoolean("showRoleAssignment")) {
            reportContent.add(Utils.integerListToString(Utils.unique(roleAssignments)));
        }
        if (!report.params.isUserReport() && report.params.getBoolean("showRoleSapStar")) {
            reportContent.add(Utils.integerListToString(Utils.unique(roleAssignments)));
        }
        reportContent.add(String.join((CharSequence)" | ", Utils.unique(functionalities)));
        reportContent.add(String.join((CharSequence)" | ", Utils.unique(tcodes)));
        if (report.params.getBoolean("showOrgLevels")) {
            String s = String.join((CharSequence)", ", orgLevels);
            CharSequence[] orgies = s.split(", ");
            orgies = Utils.unique((String[])orgies);
            reportContent.add(String.join((CharSequence)", ", orgies));
        }
        return reportContent.toArray(Utils.EMPTYSTRINGARRAY);
    }
}

