/*
 * Decompiled with CFR 0.152.
 */
package ac.report.standard;

import ac.analysis.AnalysisUser;
import ac.analysis.Authorization;
import ac.report.RiskOutputHelper;
import ac.report.tools.Settings;
import ac.risk.Risk;
import ac.risk.Violation;
import cn.Translator;
import cn.Utils;
import cn.report.CSVline;
import java.util.ArrayList;
import java.util.HashMap;

class ReportHelper {
    private static final HashMap<Integer, String[]> RiskInfo = new HashMap();
    private static final ArrayList<String> tmpLine = new ArrayList();

    ReportHelper() {
    }

    static String[] getHeaders(Settings params) {
        ArrayList<String> documentHeaders = new ArrayList<String>();
        if (!params.isSummary()) {
            documentHeaders.add("No.");
        }
        documentHeaders.add("Risk type");
        if (params.getBoolean("showRiskGroup")) {
            documentHeaders.add("Group");
        }
        documentHeaders.add("Risk");
        documentHeaders.add("Risk name");
        if (params.getBoolean("showRiskLevel")) {
            documentHeaders.add("Risk level");
        }
        if (params.getBoolean("showRiskSystemReaction")) {
            documentHeaders.add("System reaction");
        }
        if (params.getBoolean("showRiskApprover")) {
            documentHeaders.add("Approver");
        }
        if (params.getBoolean("showRiskMessage")) {
            documentHeaders.add("Message");
        }
        if (params.getBoolean("showRiskDescription")) {
            documentHeaders.add("Description");
        }
        if (params.getBoolean("showRiskMitigationDescription")) {
            documentHeaders.add("Mitigation description");
        }
        if (params.getBoolean("showRiskOrigin")) {
            documentHeaders.add("Origin");
        }
        if (params.isUserReport()) {
            documentHeaders.add("User");
            if (params.getBoolean("showUserType")) {
                documentHeaders.add("User type");
            }
            if (params.getBoolean("showUserNames")) {
                documentHeaders.add("Last name");
            }
            if (params.getBoolean("showUserNames")) {
                documentHeaders.add("First name");
            }
            if (params.getBoolean("showUserEmail")) {
                documentHeaders.add("E-mail");
            }
            if (params.getBoolean("showUserGroup")) {
                documentHeaders.add("User group");
            }
            if (params.getBoolean("showUserLockStatus")) {
                documentHeaders.add("Lock Status");
            }
            if (params.getBoolean("showUserReferenceUser")) {
                documentHeaders.add("Reference user");
            }
            if (params.getBoolean("showUserApprovedForRisk")) {
                documentHeaders.add("Approved");
            }
        }
        documentHeaders.add("Role");
        documentHeaders.add("Composite");
        if (params.getBoolean("showRoleDescription")) {
            documentHeaders.add("Role description");
        }
        if (params.getBoolean("showRoleAssignment")) {
            documentHeaders.add("Role assignments");
        }
        if (params.getBoolean("showRoleSapStar")) {
            documentHeaders.add("SAP star license");
        }
        documentHeaders.add("Functionality");
        if (!params.isSummary() && params.getBoolean("showFuncDescription")) {
            documentHeaders.add("Functionality description");
        }
        documentHeaders.add("Tcode/Service");
        if (!params.isSummary()) {
            if (params.getBoolean("showUserUsage")) {
                documentHeaders.add("Tcode Usage");
            }
            if (params.getBoolean("showTcodeDescription")) {
                documentHeaders.add("Tcode/Service description");
            }
            documentHeaders.add("Role details");
            documentHeaders.add("Activity details");
        }
        if (params.getBoolean("showOrgLevels")) {
            documentHeaders.add("Org level");
        }
        return documentHeaders.toArray(Utils.EMPTYSTRINGARRAY);
    }

    static String[] getRiskInfo(Violation entry, Translator translator, Settings params) {
        if (!RiskInfo.containsKey(entry.risk.id)) {
            tmpLine.clear();
            if (!params.isSummary()) {
                tmpLine.add("");
            }
            tmpLine.add(translator.getText(Risk.riskTypeLookUp(entry.risk.type)));
            if (params.getBoolean("showRiskGroup")) {
                tmpLine.add(entry.risk.group_id > 0 ? entry.risk.getGroup().name : translator.getText(entry.risk.getGroup().name));
            }
            tmpLine.add(entry.risk.signature);
            tmpLine.add(entry.risk.name);
            if (params.getBoolean("showRiskLevel")) {
                tmpLine.add(translator.getText(entry.risk.level));
            }
            if (params.getBoolean("showRiskSystemReaction")) {
                tmpLine.add(translator.getText(RiskOutputHelper.warningLookUp(entry.risk.warning)));
            }
            if (params.getBoolean("showRiskApprover")) {
                tmpLine.add(RiskOutputHelper.getApproversAsText(entry.risk));
            }
            if (params.getBoolean("showRiskMessage")) {
                tmpLine.add(RiskOutputHelper.getMsgFromId(entry.risk.text_response_id));
            }
            if (params.getBoolean("showRiskDescription")) {
                tmpLine.add(entry.risk.description);
            }
            if (params.getBoolean("showRiskMitigationDescription")) {
                tmpLine.add(entry.risk.mitigation);
            }
            if (params.getBoolean("showRiskOrigin")) {
                tmpLine.add(entry.risk.origin);
            }
            String[] data = tmpLine.toArray(Utils.EMPTYSTRINGARRAY);
            for (int i = 0; i < data.length; ++i) {
                data[i] = CSVline.formatCSVcontent(data[i]);
            }
            RiskInfo.put(entry.risk.id, data);
        }
        return RiskInfo.get(entry.risk.id);
    }

    static String[] getUserInfo(AnalysisUser user, Translator translator, Settings params) {
        tmpLine.clear();
        tmpLine.add(user.username);
        if (params.getBoolean("showUserType")) {
            tmpLine.add(user.getUserType());
        }
        if (params.getBoolean("showUserNames")) {
            tmpLine.add(user.getLastName());
        }
        if (params.getBoolean("showUserNames")) {
            tmpLine.add(user.getFirstName());
        }
        if (params.getBoolean("showUserEmail")) {
            tmpLine.add(user.getEmail());
        }
        if (params.getBoolean("showUserGroup")) {
            tmpLine.add(user.getUserGroup());
        }
        if (params.getBoolean("showUserLockStatus")) {
            tmpLine.add(user.isLocked() ? translator.getText("Locked") : translator.getText("Not locked"));
        }
        if (params.getBoolean("showUserReferenceUser")) {
            tmpLine.add(user.referenceUser);
        }
        String[] data = tmpLine.toArray(Utils.EMPTYSTRINGARRAY);
        for (int i = 0; i < data.length; ++i) {
            data[i] = CSVline.formatCSVcontent(data[i]);
        }
        return data;
    }

    static String getViolatingTcodeDetails(Authorization[] violatingAuthorizations) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (Authorization a : violatingAuthorizations) {
            tmp.add(a.toString());
        }
        return String.join((CharSequence)", ", tmp.toArray(Utils.EMPTYSTRINGARRAY));
    }

    static String getUserTypeNames(String[] userTypes, Translator translator) {
        CharSequence[] typeNames = new String[userTypes.length];
        for (int i = 0; i < userTypes.length; ++i) {
            typeNames[i] = translator.getText(ReportHelper.getUserTypeName(userTypes[i]));
        }
        return String.join((CharSequence)", ", typeNames);
    }

    private static String getUserTypeName(String userType) {
        switch (userType) {
            case "A": {
                return "Dialog";
            }
            case "B": {
                return "System";
            }
            case "C": {
                return "Communications Data";
            }
            case "L": {
                return "Reference";
            }
            case "S": {
                return "Service";
            }
        }
        return "Unknown";
    }
}

