/*
 * Decompiled with CFR 0.152.
 */
package ac.report.standard;

import ac.analysis.AnalysisIterator;
import ac.analysis.AnalyzeEngine;
import ac.analysis.RoleIterator;
import ac.analysis.UserIterator;
import ac.report.standard.Report;
import ac.report.tools.Settings;
import ac.risk.Risk;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Translator;
import cn.report.ReportStarter;
import cn.task.Task;

public class ReportHandler {
    public static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " ac/report/standard/ReportHandler ";
    }

    public static void main(String[] args) {
        AnalysisIterator analysisIterator;
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        Settings params = new Settings(task.params);
        Translator translator = Translator.getInstance(params.getLanguageISO());
        task.setStatusDetails(translator.getText("Preparing report"));
        Log.log("Creating report listener.");
        Report report = Report.createReport(task, params);
        report.start(ReportStarter.getBaseFilename(task.type, task.id));
        Risk[] risks = Risk.getActiveReportRisks(params);
        if (params.isUserReport()) {
            Log.log("Loading user iterator.");
            analysisIterator = new UserIterator(params);
        } else {
            Log.log("Loading dummy users for role report.");
            analysisIterator = new RoleIterator(params);
        }
        Log.log("Creating engine and adding report listener.");
        AnalyzeEngine engine = new AnalyzeEngine(risks, analysisIterator);
        engine.addListener(report);
        Log.log("Starting analysis.");
        task.setStatusDetails(translator.getText("Analyzing..."));
        engine.analyze();
        Log.log("Finished analysis.");
        DB.close();
        Log.close();
        if (params.isExcel() && report.isExcelPartial()) {
            System.exit(2);
        }
        if (engine.isLowMemory()) {
            System.exit(2);
        }
        System.exit(0);
    }
}

