/*
 * Decompiled with CFR 0.152.
 */
package ac.report.standard;

import ac.analysis.AnalysisUser;
import ac.analysis.AuthObject;
import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.report.RiskOutputHelper;
import ac.report.standard.Report;
import ac.report.standard.ReportBuffer;
import ac.report.standard.ReportHelper;
import ac.report.tools.Settings;
import ac.risk.Risk;
import ac.risk.ViolatingAuthorizationEntry;
import ac.risk.ViolatingRole;
import ac.risk.ViolatingTcodeEntry;
import ac.risk.Violation;
import cn.Log;
import cn.task.Task;
import um.Usage;

class ReportDetailed
extends Report {
    ReportDetailed(Task task, Settings params) {
        super(task, params);
        ReportBuffer.startReportBuffer(this);
    }

    @Override
    public final boolean violationFound(AnalysisUser user, Violation[] violations) {
        boolean continueReport = true;
        if (violations.length > 0) {
            long startTime = System.nanoTime();
            this.task.setStatusDetails(this.translator.getText("{1} has {2} in {3} roles", new String[]{user.username, "" + violations.length, "" + user.roles.length}));
            continueReport = ReportDetailed.handleViolations(this, user, violations);
            this.timeSpentWriting += System.nanoTime() - startTime;
        }
        return continueReport;
    }

    private static final boolean handleViolations(ReportDetailed report, AnalysisUser user, Violation[] violations) {
        if (report.params.isUserReport()) {
            String[] userInfo = ReportHelper.getUserInfo(user, report.translator, report.params);
            if (CURRENT_HASH.contentEquals(user.hash)) {
                for (int v = 0; v < violations.length; ++v) {
                    ++report.currentNo;
                    report.currentLine.clear();
                    report.currentLine.addFormatted(ReportHelper.getRiskInfo(violations[v], report.translator, report.params));
                    report.currentLine.addFormatted(userInfo);
                    if (report.params.getBoolean("showUserApprovedForRisk")) {
                        report.currentLine.add(Risk.isUserApprovedForRisk(violations[v].risk.id, user) ? report.translator.getText("Approved") : report.translator.getText("Not approved"));
                    }
                    report.currentLine.start();
                    for (int line = 0; line < ReportBuffer.data.get(v).size() - 1; ++line) {
                        report.currentLine.addFormatted(ReportBuffer.data.get(v).get(line));
                        if (report.output()) continue;
                        Log.log("Returning false on buffered output on " + user.toString());
                        return false;
                    }
                }
            } else {
                CURRENT_HASH = user.hash;
                ReportBuffer.readyBuffer(violations.length);
                for (int v = 0; v < violations.length; ++v) {
                    ++report.currentNo;
                    report.currentLine.clear();
                    report.currentLine.addFormatted(ReportHelper.getRiskInfo(violations[v], report.translator, report.params));
                    report.currentLine.addFormatted(userInfo);
                    if (report.params.getBoolean("showUserApprovedForRisk")) {
                        report.currentLine.add(Risk.isUserApprovedForRisk(violations[v].risk.id, user) ? report.translator.getText("Approved") : report.translator.getText("Not approved"));
                    }
                    report.currentLine.start();
                    ReportBuffer.newViolation();
                    if (ReportDetailed.handleViolation(report, user, violations[v])) continue;
                    Log.log("Returning false on regular output on " + user.toString());
                    return false;
                }
            }
        } else {
            ReportBuffer.readyBuffer(violations.length);
            for (Violation violation : violations) {
                ++report.currentNo;
                report.currentLine.clear();
                report.currentLine.addFormatted(ReportHelper.getRiskInfo(violation, report.translator, report.params));
                report.currentLine.start();
                ReportBuffer.newViolation();
                if (ReportDetailed.handleViolation(report, user, violation)) continue;
                Log.log("Returning false on role report output on " + user.toString());
                return false;
            }
        }
        return true;
    }

    private static final boolean handleViolation(ReportDetailed report, AnalysisUser sapUser, Violation violation) {
        switch (violation.risk.type) {
            case "sod_func": {
                return ReportDetailed.addSoDfuncCauses(report, sapUser, violation);
            }
            case "crit_tcode": {
                return ReportDetailed.addCritTcodeCauses(report, sapUser, violation);
            }
            case "sod_role2": {
                for (ViolatingRole[] vrs : violation.causesRole) {
                    if (ReportDetailed.addRoleCauses(report, vrs)) continue;
                    return false;
                }
                return true;
            }
        }
        Log.log("ac.report.tools.ReportDetailed.handleViolation Risk type '" + violation.risk.type + "' does not exist. Detaching listener.");
        return false;
    }

    private static boolean addRoleCauses(ReportDetailed report, ViolatingRole[] vrs) {
        for (ViolatingRole violatingRole : vrs) {
            ReportBuffer.add(violatingRole.role == null ? "" : violatingRole.role.name);
            ReportBuffer.add(violatingRole.composite == null ? "" : violatingRole.composite.name);
            if (report.params.getBoolean("showRoleDescription")) {
                ReportBuffer.add(violatingRole.composite == null ? violatingRole.role.getDescription() : violatingRole.composite.getDescription());
            }
            if (!report.params.isUserReport() && report.params.getBoolean("showRoleAssignment")) {
                ReportBuffer.add(violatingRole.composite == null ? "" + violatingRole.role.assignments : "" + violatingRole.composite.assignments);
            }
            if (report.params.getBoolean("showRoleSapStar")) {
                ReportBuffer.add(violatingRole.composite == null ? violatingRole.role.getSapStarLicense(report.translator) : violatingRole.composite.getSapStarLicense(report.translator));
            }
            ReportBuffer.add("");
            if (report.params.getBoolean("showFuncDescription")) {
                ReportBuffer.add("");
            }
            ReportBuffer.add("");
            if (report.params.getBoolean("showUserUsage")) {
                ReportBuffer.add("");
            }
            if (report.params.getBoolean("showTcodeDescription")) {
                ReportBuffer.add("");
            }
            ReportBuffer.add("");
            ReportBuffer.add("");
            if (report.params.getBoolean("showOrgLevels")) {
                ReportBuffer.add("");
            }
            if (ReportBuffer.output()) continue;
            return false;
        }
        return true;
    }

    private static boolean addCritTcodeCauses(ReportDetailed report, AnalysisUser sapUser, Violation violation) {
        for (ViolatingTcodeEntry vte : violation.causesTcode) {
            for (AuthorizationEntry ae : vte.violatingEntry) {
                ReportBuffer.add(ae.role.name);
                ReportBuffer.add(ae.fromComposite == null ? "" : ae.fromComposite.name);
                if (report.params.getBoolean("showRoleDescription")) {
                    ReportBuffer.add(ae.fromComposite == null ? ae.role.getDescription() : ae.fromComposite.getDescription());
                }
                if (!report.params.isUserReport() && report.params.getBoolean("showRoleAssignment")) {
                    ReportBuffer.add(ae.fromComposite == null ? "" + ae.role.assignments : "" + ae.fromComposite.assignments);
                }
                if (report.params.getBoolean("showRoleSapStar")) {
                    ReportBuffer.add(ae.fromComposite == null ? ae.role.getSapStarLicense(report.translator) : ae.fromComposite.getSapStarLicense(report.translator));
                }
                ReportBuffer.add("");
                if (report.params.getBoolean("showFuncDescription")) {
                    ReportBuffer.add("");
                }
                ReportBuffer.add(vte.tcodeAuthorization.low);
                if (report.params.getBoolean("showUserUsage")) {
                    ReportBuffer.add(ReportDetailed.getUsageFromTcode(vte.tcodeAuthorization, sapUser));
                }
                if (report.params.getBoolean("showTcodeDescription")) {
                    ReportBuffer.add(RiskOutputHelper.getAuthorizationDescription(vte.tcodeAuthorization, report.params.system, report.params.client));
                }
                ReportBuffer.add(ReportHelper.getViolatingTcodeDetails(vte.violatingAuthorizations));
                ReportBuffer.add("");
                if (report.params.getBoolean("showOrgLevels")) {
                    ReportBuffer.add("");
                }
                if (ReportBuffer.output()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addSoDfuncCauses(ReportDetailed report, AnalysisUser sapUser, Violation violation) {
        ViolatingAuthorizationEntry[][] violatingAuthorizationEntryArray = violation.violatingAuthorizationEntries;
        int n = violatingAuthorizationEntryArray.length;
        for (int i = 0; i < n; ++i) {
            ViolatingAuthorizationEntry[] vaes;
            for (ViolatingAuthorizationEntry vae : vaes = violatingAuthorizationEntryArray[i]) {
                if (ReportDetailed.addSoDFuncCause(report, sapUser, vae)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addSoDFuncCause(ReportDetailed report, AnalysisUser sapUser, ViolatingAuthorizationEntry cause) {
        for (Authorization authorization : cause.violatingAuthorizations) {
            ReportBuffer.add(cause.violatingEntry.role.name);
            ReportBuffer.add(cause.violatingEntry.fromComposite != null ? cause.violatingEntry.fromComposite.name : "");
            if (report.params.getBoolean("showRoleDescription")) {
                ReportBuffer.add(cause.violatingEntry.fromComposite == null ? cause.violatingEntry.role.description : cause.violatingEntry.fromComposite.description);
            }
            if (!report.params.isUserReport() && report.params.getBoolean("showRoleAssignment")) {
                ReportBuffer.add(cause.violatingEntry.fromComposite == null ? "" + cause.violatingEntry.role.assignments : "" + cause.violatingEntry.fromComposite.assignments);
            }
            if (report.params.getBoolean("showRoleSapStar")) {
                ReportBuffer.add(cause.violatingEntry.fromComposite == null ? cause.violatingEntry.role.getSapStarLicense(report.translator) : cause.violatingEntry.fromComposite.getSapStarLicense(report.translator));
            }
            ReportBuffer.add(cause.activity.functionality.getName());
            if (report.params.getBoolean("showFuncDescription")) {
                ReportBuffer.add(cause.activity.functionality.getDescription());
            }
            ReportBuffer.add(!cause.activity.isNoneTcode ? cause.activity.tcodeAuth.low : report.translator.getText("none"));
            if (report.params.getBoolean("showUserUsage") && AuthObject.isS_Object(authorization.object_id) && !cause.activity.isNoneTcode) {
                ReportBuffer.add(ReportDetailed.getUsageFromTcode(cause.activity.tcodeAuth, sapUser));
            } else if (report.params.getBoolean("showUserUsage")) {
                ReportBuffer.add("");
            }
            if (report.params.getBoolean("showTcodeDescription") && !cause.activity.isNoneTcode) {
                ReportBuffer.add("");
            } else if (report.params.getBoolean("showTcodeDescription")) {
                ReportBuffer.add(cause.activity.isNoneTcode ? "" : RiskOutputHelper.getAuthorizationDescription(cause.activity.tcodeAuth, report.params.system, report.params.client));
            }
            ReportBuffer.add(authorization.toString());
            ReportBuffer.add(AuthObject.getNameFromId(authorization.object_id) + " " + RiskOutputHelper.getActivityText(cause.activity, authorization.field_id));
            if (report.params.getBoolean("showOrgLevels")) {
                ReportBuffer.add(cause.violatingEntry.org_lvl_analysis != null ? "" : RiskOutputHelper.getOrgLevelAuth(cause.violatingEntry.authorizations));
            }
            if (ReportBuffer.output()) continue;
            return false;
        }
        return true;
    }

    private static String getUsageFromTcode(Authorization authorization, AnalysisUser sapUser) {
        if (authorization.object_id == AuthObject.s_TcodeId(sapUser.system, sapUser.client)) {
            int daysUsed = Usage.getDaysUsed(sapUser, authorization.low);
            return "" + daysUsed;
        }
        return "";
    }
}

