/*
 * Decompiled with CFR 0.152.
 */
package ac.report.standard;

import ac.report.standard.Report;
import ac.report.tools.Settings;
import cn.report.CSVline;
import java.util.ArrayList;

class ReportBuffer {
    static final ArrayList<ArrayList<String[]>> data = new ArrayList();
    private static Report report;
    private static int columnLength;
    private static int violationIndex;
    private static int lineIndex;
    private static int columnIndex;
    private static final ArrayList<String> currentLines;

    ReportBuffer() {
    }

    static void startReportBuffer(Report report) {
        ReportBuffer.report = report;
        columnLength = ReportBuffer.calculateLength(report.params);
    }

    static void add(String string) {
        ReportBuffer.data.get((int)ReportBuffer.violationIndex).get((int)ReportBuffer.lineIndex)[ReportBuffer.columnIndex++] = CSVline.formatCSVcontent(string);
    }

    static void newViolation() {
        currentLines.clear();
        data.get(++violationIndex).add(new String[columnLength]);
        lineIndex = 0;
        columnIndex = 0;
    }

    static boolean output() {
        columnIndex = 0;
        if (ReportBuffer.isNotDuplicate(data.get(violationIndex).get(lineIndex))) {
            ReportBuffer.report.currentLine.addFormatted(data.get(violationIndex).get(lineIndex));
            data.get(violationIndex).add(new String[columnLength]);
            ++lineIndex;
            return report.output();
        }
        data.get(violationIndex).set(lineIndex, new String[columnLength]);
        return true;
    }

    static void readyBuffer(int violationCount) {
        for (int i = 0; i < violationCount; ++i) {
            if (i >= data.size()) {
                data.add(new ArrayList());
                continue;
            }
            data.set(i, new ArrayList());
        }
        violationIndex = -1;
        lineIndex = 0;
        columnIndex = 0;
    }

    private static int calculateLength(Settings params) {
        int count = 0;
        ++count;
        ++count;
        if (params.getBoolean("showRoleDescription")) {
            ++count;
        }
        if (params.getBoolean("showRoleAssignment")) {
            ++count;
        }
        if (params.getBoolean("showRoleSapStar")) {
            ++count;
        }
        ++count;
        if (params.getBoolean("showFuncDescription")) {
            ++count;
        }
        ++count;
        if (params.getBoolean("showUserUsage")) {
            ++count;
        }
        if (params.getBoolean("showTcodeDescription")) {
            ++count;
        }
        ++count;
        ++count;
        if (params.getBoolean("showOrgLevels")) {
            ++count;
        }
        return count;
    }

    private static boolean isNotDuplicate(String[] content) {
        String oneLiner = String.join((CharSequence)"|", content);
        if (!currentLines.contains(oneLiner)) {
            currentLines.add(oneLiner);
            return true;
        }
        return false;
    }

    static {
        violationIndex = -1;
        lineIndex = 0;
        columnIndex = 0;
        currentLines = new ArrayList();
    }
}

