/*
 * Decompiled with CFR 0.152.
 */
package ac.report.standard;

import ac.analysis.AnalysisUser;
import ac.analysis.OrgLevel;
import ac.analysis.ViolationListener;
import ac.report.RiskOutputHelper;
import ac.report.standard.ReportDetailed;
import ac.report.standard.ReportHelper;
import ac.report.standard.ReportSummary;
import ac.report.tools.Settings;
import ac.risk.Group;
import ac.risk.Risk;
import cn.Config;
import cn.Language;
import cn.Log;
import cn.Role;
import cn.Translator;
import cn.Utils;
import cn.report.CSVfile;
import cn.report.CSVline;
import cn.task.Task;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public abstract class Report
implements ViolationListener {
    protected static final String GUITEXT = "{1} has {2} in {3} roles";
    static final String TEXTANALYZING = "Analyzing...";
    protected static String CURRENT_HASH = "";
    protected final Task task;
    protected final Settings params;
    protected CSVfile csv;
    protected Translator translator;
    protected int currentNo = 0;
    protected CSVline currentLine;
    protected long timeSpentWriting = 0L;

    public static Report createReport(Task task, Settings params) {
        if (params.isSummary()) {
            return new ReportSummary(task, params);
        }
        return new ReportDetailed(task, params);
    }

    protected Report(Task task, Settings params) {
        this.task = task;
        this.params = params;
        this.translator = Translator.getInstance(this.params.getString("language"));
        OrgLevel.setFieldsConsidered(params.system, params.client, params.getIntArray("org_levels"));
    }

    public void start(String baseFilename) {
        this.csv = new CSVfile(baseFilename + ".csv", this.params.isExcel());
        if (this.params.isExcel()) {
            CSVfile selectionsCSV = new CSVfile(baseFilename + "_selections.csv", this.params.isExcel());
            CSVline csvLine = new CSVline(selectionsCSV, 2);
            Report.makeSelectionSheet(this.translator, this.task, this.params, csvLine);
            selectionsCSV.close();
        } else {
            CSVline csvLine = new CSVline(this.csv, 2);
            Report.makeSelectionSheet(this.translator, this.task, this.params, csvLine);
        }
        CharSequence[] headers = ReportHelper.getHeaders(this.params);
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this.translator.getText((String)headers[i]);
        }
        Log.log("Created headers: " + String.join((CharSequence)" | ", headers));
        this.currentLine = new CSVline(this.csv, headers.length);
        this.currentLine.add((String[])headers);
        this.currentLine.write();
    }

    @Override
    public void close() {
        Log.log("Time spent writing report:              " + TimeUnit.NANOSECONDS.toMillis(this.timeSpentWriting) + " ms.");
        Log.log("Time spent loading AnalysisUsers:       " + AnalysisUser.getTimeSpentLoading() + " ms.");
        Log.log("Time spent loading Role authorizations: " + Role.getTimeSpentLoading() + " ms.");
        this.csv.close();
    }

    public boolean output() {
        if (!this.params.isSummary()) {
            this.currentLine.set(0, "" + this.currentNo);
        }
        boolean continueWriting = this.currentLine.write();
        this.currentLine.reset();
        return continueWriting;
    }

    public boolean isExcelPartial() {
        return this.csv.getLineCount() >= 0x100000;
    }

    public static void makeSelectionSheet(Translator translator, Task task, Settings params, CSVline selectionsCSV) {
        String[] userTypes;
        CharSequence[] userGroups;
        CharSequence[] usernames;
        int[] approvers;
        int[] text_response_ids;
        int[] group_ids;
        int[] warning_ids;
        if (params.isDashboardReport()) {
            selectionsCSV.write(new String[]{translator.getText("Report id"), translator.getText("Dashboard")});
        } else {
            selectionsCSV.write(new String[]{translator.getText("Report id"), "" + task.id});
        }
        selectionsCSV.write(new String[]{translator.getText("Name"), task.getAttributes().getString("name")});
        selectionsCSV.write(new String[]{translator.getText("Created"), new Timestamp(System.currentTimeMillis()).toString()});
        selectionsCSV.write(new String[]{translator.getText("Username"), task.username});
        selectionsCSV.write(new String[]{translator.getText("System"), params.getString("system")});
        selectionsCSV.write(new String[]{translator.getText("Client"), params.getString("client")});
        selectionsCSV.write(new String[]{translator.getText("Language"), Language.getLanguage((String)params.getString((String)"language")).title});
        selectionsCSV.write(new String[]{translator.getText("Analysis"), params.isUserReport() ? translator.getText("Users") : translator.getText("Roles")});
        selectionsCSV.write(new String[]{translator.getText("Summary"), params.isSummary() ? "X" : ""});
        selectionsCSV.write(new String[]{"", ""});
        CharSequence[] risk_signatures = params.getStringArray("rule");
        if (!Utils.isEmpty((String[])risk_signatures)) {
            selectionsCSV.write(new String[]{translator.getText("Risks"), String.join((CharSequence)", ", risk_signatures)});
        } else {
            ArrayList<String> ruleTypes = new ArrayList<String>();
            if (params.getBoolean("crit_role")) {
                ruleTypes.add(translator.getText(Risk.riskTypeLookUp("crit_role")));
            }
            if (params.getBoolean("sod_role2")) {
                ruleTypes.add(translator.getText(Risk.riskTypeLookUp("sod_role2")));
            }
            if (params.getBoolean("crit_tcode")) {
                ruleTypes.add(translator.getText(Risk.riskTypeLookUp("crit_tcode")));
            }
            if (params.getBoolean("sod_func")) {
                ruleTypes.add(translator.getText(Risk.riskTypeLookUp("sod_func")));
            }
            if (ruleTypes.size() > 0) {
                selectionsCSV.write(new String[]{translator.getText("Risks"), String.join((CharSequence)", ", ruleTypes.toArray(Utils.EMPTYSTRINGARRAY))});
            } else {
                selectionsCSV.write(new String[]{translator.getText("Risks"), translator.getText("All")});
            }
        }
        String[] risklevels = params.getStringArray("risklevels");
        if (risklevels.length > 0) {
            CharSequence[] level_texts = new String[risklevels.length];
            for (int i = 0; i < risklevels.length; ++i) {
                level_texts[i] = translator.getText(risklevels[i]);
            }
            selectionsCSV.write(new String[]{translator.getText("Risk level"), String.join((CharSequence)", ", level_texts)});
        }
        if ((warning_ids = params.getIntArray("systemreaction")).length > 0) {
            CharSequence[] warning_texts = new String[warning_ids.length];
            for (int i = 0; i < warning_ids.length; ++i) {
                warning_texts[i] = RiskOutputHelper.warningLookUp(warning_ids[i]);
            }
            selectionsCSV.write(new String[]{translator.getText("System Reaction"), String.join((CharSequence)", ", warning_texts)});
        }
        if ((group_ids = params.getIntArray("risk_groups")).length > 0) {
            CharSequence[] group_texts = new String[group_ids.length];
            for (int i = 0; i < group_ids.length; ++i) {
                group_texts[i] = Group.getById(group_ids[i]).toString();
            }
            selectionsCSV.write(new String[]{translator.getText("Group"), String.join((CharSequence)", ", group_texts)});
        }
        if ((text_response_ids = params.getIntArray("messages")).length > 0) {
            CharSequence[] message_texts = new String[text_response_ids.length];
            for (int i = 0; i < text_response_ids.length; ++i) {
                message_texts[i] = RiskOutputHelper.getMsgFromId(text_response_ids[i]);
            }
            selectionsCSV.write(new String[]{translator.getText("Message"), String.join((CharSequence)", ", message_texts)});
        }
        if ((approvers = params.getIntArray("approvers")).length > 0) {
            selectionsCSV.write(new String[]{translator.getText("Approver"), RiskOutputHelper.getApproversAsText(approvers)});
        }
        selectionsCSV.write(new String[]{"", ""});
        String roleText = "";
        CharSequence[] rolenames = params.getStringArray("role");
        if (rolenames.length > 0) {
            roleText = String.join((CharSequence)", ", rolenames);
        } else if (params.getString("roleType") != null) {
            switch (params.getString("roleType")) {
                case "S": {
                    roleText = translator.getText("Single");
                    break;
                }
                case "C": {
                    roleText = translator.getText("Composite");
                    break;
                }
                case "A": {
                    roleText = translator.getText("Assigned only");
                    break;
                }
                case "B": {
                    roleText = translator.getText("All");
                    break;
                }
                default: {
                    roleText = "ERROR!";
                }
            }
        }
        if (!Utils.isEmpty(roleText)) {
            selectionsCSV.write(new String[]{translator.getText("Roles"), roleText});
            selectionsCSV.write(new String[]{"", ""});
        }
        if (params.excludeUsersLocked()) {
            selectionsCSV.write(new String[]{translator.getText("Exclude locked users"), "X"});
        }
        if (params.excludeUsersExpired()) {
            selectionsCSV.write(new String[]{translator.getText("Exclude expired users"), "X"});
        }
        if (!Utils.isEmpty((String[])(usernames = params.getStringArray("user")))) {
            selectionsCSV.write(new String[]{translator.getText("Users"), String.join((CharSequence)", ", usernames)});
        }
        if (!Utils.isEmpty((String[])(userGroups = params.getStringArray("userGroup")))) {
            selectionsCSV.write(new String[]{translator.getText("User groups"), String.join((CharSequence)", ", userGroups)});
        }
        if (!Utils.isEmpty(userTypes = params.getStringArray("userType"))) {
            selectionsCSV.write(new String[]{translator.getText("User types"), ReportHelper.getUserTypeNames(userTypes, translator)});
        }
        selectionsCSV.write(new String[]{"", ""});
        if (params.getBoolean("showRiskGroup")) {
            selectionsCSV.write(new String[]{translator.getText("Group"), "X"});
        }
        if (params.getBoolean("showRiskLevel")) {
            selectionsCSV.write(new String[]{translator.getText("Risk level"), "X"});
        }
        if (params.getBoolean("showRiskSystemReaction")) {
            selectionsCSV.write(new String[]{translator.getText("System reaction"), "X"});
        }
        if (params.getBoolean("showRiskApprover")) {
            selectionsCSV.write(new String[]{translator.getText("Approver"), "X"});
        }
        if (params.getBoolean("showRiskMessage")) {
            selectionsCSV.write(new String[]{translator.getText("Message"), "X"});
        }
        if (params.getBoolean("showRiskDescription")) {
            selectionsCSV.write(new String[]{translator.getText("Description"), "X"});
        }
        if (params.getBoolean("showRiskMitigationDescription")) {
            selectionsCSV.write(new String[]{translator.getText("Mitigation description"), "X"});
        }
        if (params.getBoolean("showRiskOrigin")) {
            selectionsCSV.write(new String[]{translator.getText("Origin"), "X"});
        }
        selectionsCSV.write(new String[]{"", ""});
        if (params.getBoolean("showUserNames")) {
            selectionsCSV.write(new String[]{translator.getText("Users' first and last names"), "X"});
        }
        if (params.getBoolean("showUserEmail")) {
            selectionsCSV.write(new String[]{translator.getText("Users' e-mail address"), "X"});
        }
        if (params.getBoolean("showUserGroup")) {
            selectionsCSV.write(new String[]{translator.getText("Users' user group"), "X"});
        }
        if (params.getBoolean("showUserLockStatus")) {
            selectionsCSV.write(new String[]{translator.getText("Users' lock status"), "X"});
        }
        if (params.getBoolean("showUserType")) {
            selectionsCSV.write(new String[]{translator.getText("User type"), "X"});
        }
        if (params.getBoolean("showUserApprovedForRisk")) {
            selectionsCSV.write(new String[]{translator.getText("User approved"), "X"});
        }
        if (params.getBoolean("showUserReferenceUser")) {
            selectionsCSV.write(new String[]{translator.getText("Reference user"), "X"});
        }
        selectionsCSV.write(new String[]{"", ""});
        if (params.getBoolean("showRoleDescription")) {
            selectionsCSV.write(new String[]{translator.getText("Role description"), "X"});
        }
        if (params.getBoolean("showRoleAssignment")) {
            selectionsCSV.write(new String[]{translator.getText("Role assignments"), "X"});
        }
        if (params.getBoolean("showRoleSapStar")) {
            selectionsCSV.write(new String[]{translator.getText("SAP star license"), "X"});
        }
        if (params.getBoolean("showTcodeDescription")) {
            selectionsCSV.write(new String[]{translator.getText("Tcode description"), "X"});
        }
        if (params.getBoolean("showFuncDescription")) {
            selectionsCSV.write(new String[]{translator.getText("Functionality description"), "X"});
        }
        if (params.getBoolean("showUserUsage")) {
            selectionsCSV.write(new String[]{translator.getText("Tcode Usage"), "X"});
        }
        if (Config.isFeature("orglvl_analysis", false)) {
            Log.log("Org level considerations active");
            selectionsCSV.write(new String[]{"", ""});
            CharSequence[] fieldnames = OrgLevel.getFieldNamesConsidered(params.system, params.client);
            if (fieldnames.length > 0) {
                selectionsCSV.write(new String[]{translator.getText("Considered fields"), String.join((CharSequence)", ", fieldnames)});
            }
            if ((fieldnames = OrgLevel.getFieldNamesIncludeEmpty(params.system, params.client)).length > 0) {
                selectionsCSV.write(new String[]{translator.getText("Include empty"), String.join((CharSequence)", ", fieldnames)});
            }
        }
        for (int i = 0; i < 5; ++i) {
            selectionsCSV.write(new String[]{"", ""});
        }
    }
}

