/*
 * Decompiled with CFR 0.152.
 */
package ac.report;

import cn.Arguments;
import cn.DB;
import cn.Frequency;
import cn.Log;
import cn.task.Task;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class ScheduledReports {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Starting report scheduling for " + system + " / " + client);
        ScheduledReports.go(system, client);
        Log.log("Ending report scheduling for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void go(String system, String client) {
        Log.log("Finding scheduled reports for " + system + " / " + client);
        ArrayList<Object> tasks = new ArrayList<Object>();
        PreparedStatement ps = DB.prepareStatement("SELECT `id`, `params`,`user`,`start`,`status`  FROM queue_task WHERE `system` = ? AND `client` = ? AND `type` = 7 AND `attributes` LIKE '%\"fav\":\"S\"%';");
        try {
            ps.setString(1, system);
            ps.setString(2, client);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String username = rs.getString("user");
                Task task = new Task(rs.getInt("id"), 7, username, system, client, rs.getString("params"));
                Date date = rs.getDate("start");
                Frequency frequency = new Frequency(task.getAttributes().getInt("frequency"));
                int status = rs.getInt("status");
                if (!frequency.isOverdue(date) && status <= 3) continue;
                tasks.add(task);
                Log.log("ScheduledReports found report for user '" + username + "' '" + task.getAttributes().getString("name") + "' w frequency '" + frequency.toString() + "'");
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("ScheduledReports can't get scheduled reports.");
            Log.logException(e);
        }
        if (tasks.size() > 0) {
            PreparedStatement up = DB.prepareStatement("UPDATE queue_task SET `start` = NULL, `end` = NULL, status = 0 WHERE id = ?;");
            PreparedStatement in = DB.prepareStatement("INSERT INTO queued_reports (`report_id`, `user`, `system`, `client`) VALUES (?, ?, ?, ?);");
            try {
                for (Task task : tasks) {
                    up.setInt(1, task.id);
                    up.addBatch();
                    in.setInt(1, task.id);
                    in.setString(2, task.username);
                    in.setString(3, system);
                    in.setString(4, client);
                    in.addBatch();
                }
                Log.log("ScheduledReports executing update statements.");
                up.executeBatch();
                Log.log("ScheduledReports executing insert statements.");
                in.executeBatch();
            }
            catch (SQLException e) {
                Log.log("ScheduledReports failed to execute update statement.");
                Log.logException(e);
            }
        }
    }
}

