/*
 * Decompiled with CFR 0.152.
 */
package ac.report;

import ac.analysis.AuthObject;
import ac.report.RiskOutputHelper;
import ac.risk.Group;
import ac.risk.Risk;
import cn.Arguments;
import cn.DB;
import cn.Frequency;
import cn.Log;
import cn.Tcode;
import cn.Translator;
import cn.Utils;
import cn.report.Spreadsheet;
import java.sql.ResultSet;
import java.util.HashMap;

public class RuleLog {
    private static final HashMap<Integer, String> RISK_NAMES = new HashMap();
    private static final HashMap<Integer, String> FUNC_NAMES = new HashMap();
    private static final HashMap<Integer, String> FUNC_GROUP_NAMES = new HashMap();
    private static final HashMap<Integer, String> APPROVER_NAMES = new HashMap();

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        String filename = myArgs.get("filename");
        String rawfilter = myArgs.get("filter");
        String filter = Utils.decodeUrlValue(rawfilter);
        Log.log("Starting rule log report for " + system + " / " + client + " " + filename);
        Translator translator = Translator.getInstance(myArgs.get("language"));
        RuleLog.createFile(system, client, filter, filename, translator);
        Log.log("Ending rule log report for " + system + " / " + client + " " + filename);
        DB.close();
        Log.close();
    }

    private static void createFile(String system, String client, String filter, String filename, Translator translator) {
        String[] headers = new String[]{"Timestamp", "Username", "Type", "Risk id", "Name", "Entry"};
        Spreadsheet excel = new Spreadsheet(translator);
        excel.addSheet("Data");
        excel.writeHeaders(headers);
        String statement = RuleLog.getStatement(system, client, filter);
        Log.log("Getting data from:\n" + statement);
        ResultSet rs = DB.getData(statement);
        try {
            while (rs.next()) {
                String log_type = rs.getString("log_type");
                int rule_id = rs.getInt("rule_id");
                String name = RuleLog.getName(log_type, rule_id, translator);
                String risk = log_type.equalsIgnoreCase("rule") ? Risk.formatId(rule_id) : "";
                String[] excelLine = new String[]{rs.getString("timestamp"), rs.getString("user"), log_type, risk, name, ""};
                switch (rs.getString("log_type")) {
                    case "rule": {
                        excelLine[excelLine.length - 1] = RuleLog.createRiskEntry(translator, rs.getString("log"), rs.getInt("replaced_id"), rs.getInt("regarding_id"), rs.getString("action"));
                        break;
                    }
                    case "functionality": {
                        excelLine[excelLine.length - 1] = RuleLog.createFunctionalityEntry(translator, rs.getString("log"), rs.getInt("replaced_id"), rs.getInt("regarding_id"), rs.getString("action"));
                        break;
                    }
                    case "activity": {
                        excelLine[excelLine.length - 1] = RuleLog.createActivityEntry(translator, rs.getString("log"), rs.getInt("replaced_id"), rs.getInt("regarding_id"), rs.getString("action"));
                    }
                }
                excel.writeRow(excelLine);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("documents.ac.RuleLog was not able to work with results.");
            Log.logException(e);
        }
        Log.log("documents.ac.RuleLog Adding autofilter and freezepane.");
        excel.addAutoFilter(headers.length);
        excel.getActiveSheet().createFreezePane(0, 1);
        Log.log("documents.ac.RuleLog Autosize columns.");
        excel.autoSizeAllColumns(headers.length);
        Log.log("documents.ac.RuleLog Saving file.");
        excel.save(filename);
    }

    private static String getName(String log_type, int rule_id, Translator translator) {
        return log_type.equals("rule") ? RuleLog.getRiskNameFromId(rule_id, translator) : (log_type.equals("functionality") ? RuleLog.getFunctionalityName(rule_id, translator) : "");
    }

    private static String createRiskEntry(Translator translator, String log, int replaced_id, int regarding_id, String action) {
        switch (action) {
            case "Risk created": {
                return translator.getText(action) + translator.getText(" as ") + log;
            }
            case "Risk copied to": {
                String name = RuleLog.getRiskNameFromId(regarding_id, translator);
                String id = Risk.formatId(regarding_id);
                return translator.getText("Copy made into number {1}, named '{2}'", new String[]{id, name});
            }
            case "Risk copied": {
                String name = RuleLog.getRiskNameFromId(replaced_id, translator);
                String id = Risk.formatId(replaced_id);
                return translator.getText("Created as a copy of number {1}, named '{2}'", new String[]{id, name});
            }
            case "RU name": {
                return translator.getText("Renamed to {1}", new String[]{log});
            }
            case "RU warning": {
                String oNew = translator.getText(RiskOutputHelper.warningLookUp(regarding_id));
                String oOld = translator.getText(RiskOutputHelper.warningLookUp(replaced_id));
                return translator.getText("System reaction changed from {1} to {2}", new String[]{oOld, oNew});
            }
            case "RU response": {
                String oNew = regarding_id == 0 ? translator.getText("no text") : RiskOutputHelper.getMsgFromId(regarding_id);
                String oOld = replaced_id == 0 ? translator.getText("no text") : RiskOutputHelper.getMsgFromId(replaced_id);
                return translator.getText("Text response changed from '{1}' to '{2}'", new String[]{oOld, oNew});
            }
            case "RU approver": {
                String oNew = regarding_id == 0 ? translator.getText("None") : RuleLog.getApproverName(regarding_id, translator);
                String oOld = replaced_id == 0 ? translator.getText("None") : RuleLog.getApproverName(replaced_id, translator);
                return translator.getText("Approver changed from '{1}' to '{2}'", new String[]{oOld, oNew});
            }
            case "RU approver mini": {
                return translator.getText("Approver requirements changed from '{1}' to '{2}'", new String[]{"" + replaced_id, "" + regarding_id});
            }
            case "RU multiApproAdd": {
                String oNew = regarding_id == 0 ? translator.getText("None") : RuleLog.getApproverName(regarding_id, translator);
                return translator.getText("Approver added: '{1}'", new String[]{oNew});
            }
            case "RU multiApproSub": {
                String oOld = replaced_id == 0 ? translator.getText("None") : RuleLog.getApproverName(replaced_id, translator);
                return translator.getText("Approver removed: '{1}'", new String[]{oOld});
            }
            case "RU level": {
                String oNew = translator.getText(log);
                return translator.getText("Risk level set to {1}", new String[]{oNew});
            }
            case "RU mitigation": {
                return translator.getText("Mitigation description changed to '{1}'", new String[]{log});
            }
            case "RU description": {
                return translator.getText("Risk description changed to '{1}'", new String[]{log});
            }
            case "RU group": {
                String oNew = regarding_id == 0 ? translator.getText(Group.getById((int)regarding_id).name) : Group.getById((int)regarding_id).name;
                String oOld = replaced_id == 0 ? translator.getText(Group.getById((int)replaced_id).name) : Group.getById((int)replaced_id).name;
                return translator.getText("Moved from group '{1}' to group '{2}'", new String[]{oOld, oNew});
            }
            case "RU origin": {
                return translator.getText("Risk origin changed to '{1}'", new String[]{log});
            }
            case "RU status": {
                return translator.getText("Risk has been set {1}", new String[]{translator.getText(log)});
            }
            case "RU frequency": {
                String oNew = translator.getText(Frequency.getFrequencyAsText(regarding_id));
                String oOld = translator.getText(Frequency.getFrequencyAsText(replaced_id));
                return translator.getText("Renewal has been changed from {1} to {2}", new String[]{oOld, oNew});
            }
            case "Risk deleted": {
                return translator.getText("Risk definition deleted");
            }
            case "added tcode": {
                return translator.getText("Added tcode: {1}", new String[]{log});
            }
            case "removed tcode": {
                return translator.getText("Removed tcode: {1}", new String[]{log});
            }
            case "added role": {
                return translator.getText("Added role: {1}", new String[]{log});
            }
            case "removed role": {
                return translator.getText("Removed role: {1}", new String[]{log});
            }
            case "added A": {
                return translator.getText("Added role: {1} to {2}-list", new String[]{log, "A"});
            }
            case "added B": {
                return translator.getText("Added role: {1} to {2}-list", new String[]{log, "B"});
            }
            case "removed A": {
                return translator.getText("Removed role: {1} from {2}-list", new String[]{log, "A"});
            }
            case "removed B": {
                return translator.getText("Removed role: {1} from {2}-list", new String[]{log, "B"});
            }
            case "added func": {
                return translator.getText("Added functionality: {1}", new String[]{log});
            }
            case "removed func": {
                return translator.getText("Removed functionality: {1}", new String[]{log});
            }
            case "added func A": {
                return translator.getText("Added functionality: {1} to {2}-list", new String[]{log, "A"});
            }
            case "added func B": {
                return translator.getText("Added functionality: {1} to {2}-list", new String[]{log, "B"});
            }
            case "removed func A": {
                return translator.getText("Removed functionality: {1} from {2}-list", new String[]{log, "A"});
            }
            case "removed func B": {
                return translator.getText("Removed functionality: {1} from {2}-list", new String[]{log, "B"});
            }
            case "upload risk": {
                return translator.getText("Uploaded as {1} with functionalities {2} and {3}", new String[]{log, RuleLog.getFunctionalityName(regarding_id, translator), RuleLog.getFunctionalityName(replaced_id, translator)});
            }
        }
        return "Undefined: " + action;
    }

    private static String createFunctionalityEntry(Translator translator, String log, int replaced_id, int regarding_id, String action) {
        switch (action) {
            case "func created": {
                return translator.getText("Funtionality created as {1}", new String[]{log});
            }
            case "func update name": {
                return translator.getText("Functionality name changed to {1}", new String[]{log});
            }
            case "func update desc": {
                return translator.getText("Functionality description changed to {1}", new String[]{log});
            }
            case "func update grou": {
                return translator.getText("Functionality moved from {1} to {2}", new String[]{RuleLog.getFunctionalityGroupName(replaced_id, translator), RuleLog.getFunctionalityGroupName(regarding_id, translator)});
            }
            case "func deleted": {
                return translator.getText("Functionality {1} deleted", new String[]{log});
            }
            case "upload func": {
                return translator.getText("Uploaded as {1}", new String[]{log});
            }
            case "upload func dela": {
                return translator.getText("Existing activities deleted in connection with upload");
            }
        }
        return log;
    }

    private static String createActivityEntry(Translator translator, String log, int replaced_id, int regarding_id, String action) {
        switch (action) {
            case "activity created": {
                return translator.getText("Activity created using {1} tcode", new String[]{log});
            }
            case "activity changed": {
                return translator.getText("{1} activity changed to a {2} activity", new String[]{"" + replaced_id, log});
            }
            case "activity deleted": {
                return translator.getText("{1} activity deleted", new String[]{log});
            }
            case "activity values": {
                String tcode = regarding_id == 0 ? "" : Tcode.getById((int)regarding_id).name;
                String object = replaced_id == 0 ? "" : AuthObject.getNameFromId(replaced_id);
                return translator.getText("New values for authorization object {1} in {2} activity: {3}", new String[]{object, tcode, log});
            }
            case "upload activity": {
                return translator.getText("{1} activity uploaded", new String[]{log});
            }
            case "upload act vals": {
                return translator.getText("Uploaded values: {1}", new String[]{log});
            }
        }
        return log;
    }

    private static String getStatement(String system, String client, String filter) {
        String statement = "SELECT * FROM sod_log WHERE `system` = '" + system + "' AND client = '" + client + "' ";
        if (filter.length() > 0) {
            statement = statement + "AND ( ";
            String[] pieces = filter.split(" ");
            CharSequence[] filterStatement = new String[pieces.length];
            int i = 0;
            for (String piece : pieces) {
                String myid = Utils.ltrim(piece, "0");
                filterStatement[i++] = "(user LIKE '%" + piece + "%' OR log LIKE '%" + piece + "%' OR (rule_id LIKE '%" + myid + "' AND log_type = 'rule') OR timestamp LIKE '%" + piece + "%')";
            }
            statement = statement + String.join((CharSequence)" AND ", filterStatement);
            statement = statement + ") ";
        }
        return statement + "ORDER BY timestamp DESC, id DESC LIMIT 1048576;";
    }

    private static String getRiskNameFromId(int risk_id, Translator translator) {
        if (!RISK_NAMES.containsKey(risk_id)) {
            String riskName = DB.getOne("SELECT name FROM sod_rule WHERE id = " + risk_id + "; ");
            RISK_NAMES.put(risk_id, riskName);
        }
        return RISK_NAMES.get(risk_id) == null ? translator.getText("DELETED") : RISK_NAMES.get(risk_id);
    }

    private static String getFunctionalityName(int func_id, Translator translator) {
        if (!FUNC_NAMES.containsKey(func_id)) {
            String funcName = DB.getOne("SELECT name FROM sod_functionalities WHERE id = " + func_id + "; ");
            FUNC_NAMES.put(func_id, funcName);
        }
        return FUNC_NAMES.get(func_id) == null ? translator.getText("DELETED") : FUNC_NAMES.get(func_id);
    }

    private static String getFunctionalityGroupName(int func_group_id, Translator translator) {
        if (!FUNC_GROUP_NAMES.containsKey(func_group_id)) {
            String funcGroupName = DB.getOne("SELECT name FROM sod_func_group WHERE id = " + func_group_id + "; ");
            FUNC_GROUP_NAMES.put(func_group_id, funcGroupName);
        }
        return FUNC_GROUP_NAMES.get(func_group_id) == null ? translator.getText("DELETED") : FUNC_GROUP_NAMES.get(func_group_id);
    }

    private static String getApproverName(int approver_id, Translator translator) {
        if (!APPROVER_NAMES.containsKey(approver_id)) {
            String approver_name = DB.getOne("SELECT approver FROM sod_approvers WHERE id = " + approver_id + ";");
            APPROVER_NAMES.put(approver_id, approver_name);
        }
        return APPROVER_NAMES.get(approver_id) == null ? translator.getText("DELETED") : APPROVER_NAMES.get(approver_id);
    }
}

