/*
 * Decompiled with CFR 0.152.
 */
package ac.report;

import ac.analysis.AuthObject;
import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.analysis.OrgLevel;
import ac.risk.Activity;
import ac.risk.Approver;
import ac.risk.Risk;
import cn.DB;
import cn.Log;
import cn.Translator;
import cn.Utils;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class RiskOutputHelper {
    private static PreparedStatement PS_LOAD_MESSAGE = null;
    private static final HashMap<Integer, String> RISK_MESSAGES = new HashMap();
    private static PreparedStatement PS_getTcodeDescription = null;
    private static PreparedStatement PS_getStartDescription = null;
    private static PreparedStatement PS_getServiceDescription = null;
    private static HashMap<String, String> sTcodeDescriptions = null;
    private static HashMap<String, String> sStartDescriptions = null;
    private static HashMap<String, String> sServiceDescriptions = null;

    public static int[] getWarningReactions() {
        int[] warningReactions = new int[]{0, 1, 2, 3, 4};
        return warningReactions;
    }

    public static String warningLookUp(int warning) {
        switch (warning) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Display Message";
            }
            case 2: {
                return "Require Documentation";
            }
            case 3: {
                return "Prevent Action";
            }
            case 4: {
                return "Approval Workflow";
            }
        }
        return "Unknown";
    }

    public static String getMsgFromId(int text_response_id) {
        if (!RISK_MESSAGES.containsKey(text_response_id)) {
            try {
                if (PS_LOAD_MESSAGE == null) {
                    PS_LOAD_MESSAGE = DB.prepareStatement("SELECT text_response FROM sod_text_responses WHERE id = ?;");
                }
                PS_LOAD_MESSAGE.setInt(1, text_response_id);
                String msg = DB.preparedStatementGetOne(PS_LOAD_MESSAGE);
                RISK_MESSAGES.put(text_response_id, msg);
            }
            catch (SQLException e) {
                Log.log("Risk utils Failed to get msg from msgId");
                Log.logException(e);
            }
        }
        return RISK_MESSAGES.get(text_response_id);
    }

    public static String getApproversAsText(int[] approver_ids) {
        if (!Utils.isEmpty(approver_ids)) {
            ArrayList<String> approverText = new ArrayList<String>();
            for (int id : approver_ids) {
                Approver ap = Approver.getById(id);
                approverText.add(ap.toString());
            }
            return String.join((CharSequence)", ", approverText.toArray(Utils.EMPTYSTRINGARRAY));
        }
        return "";
    }

    public static String getApproversAsText(Risk risk) {
        if (risk.warning == 2) {
            if (risk.approver_id > 0) {
                return RiskOutputHelper.getApproversAsText(new int[]{risk.approver_id});
            }
        } else if (risk.warning == 4) {
            return RiskOutputHelper.getApproversAsText(risk.multi_approver);
        }
        return "";
    }

    public static String getActivityText(Activity activity, int field_id) {
        if (AuthObject.isS_Field(field_id)) {
            return !activity.isNoneTcode ? "(" + AuthObject.getFieldById(field_id) + " " + activity.tcodeAuth.low + ")" : "(" + AuthObject.getFieldById(field_id) + " *)";
        }
        ArrayList<CallSite> fvs = new ArrayList<CallSite>();
        for (AuthorizationEntry ae : activity.authorizationsMap.values()) {
            for (Authorization a : ae.authorizations) {
                if (field_id != a.field_id) continue;
                if (a.listOfAuthorizations != null) {
                    for (Authorization la : a.listOfAuthorizations) {
                        String end = Utils.isEmpty(la.high) ? "" : "-" + la.high;
                        fvs.add((CallSite)((Object)(la.low + end)));
                    }
                    continue;
                }
                String end = Utils.isEmpty(a.high) ? "" : "-" + a.high;
                fvs.add((CallSite)((Object)(a.low + end)));
            }
        }
        if (fvs.size() > 0) {
            return "(" + AuthObject.getFieldById(field_id) + " " + String.join((CharSequence)", ", Utils.unique(fvs).toArray(Utils.EMPTYSTRINGARRAY)) + ")";
        }
        return "(" + AuthObject.getFieldById(field_id) + " ?)";
    }

    public static String getActivityTcode(Activity activity, Translator translator) {
        if (activity.isNoneTcode) {
            return translator.getText("Non tcode");
        }
        return activity.tcodeAuth.high.length() > 0 ? activity.tcodeAuth.low + "-" + activity.tcodeAuth.high : activity.tcodeAuth.low;
    }

    public static String getAuthorizationDescription(Authorization authorization, String system, String client) {
        if (authorization.object_id == AuthObject.s_TcodeId(system, client)) {
            if (sTcodeDescriptions == null) {
                sTcodeDescriptions = new HashMap();
            }
            if (!sTcodeDescriptions.containsKey(authorization.low)) {
                if (PS_getTcodeDescription == null) {
                    PS_getTcodeDescription = DB.prepareStatement("SELECT `description` FROM um_tcode WHERE `tcode` = ? AND `system` = '" + system + "' AND `client` = '" + client + "';");
                }
                try {
                    PS_getTcodeDescription.setString(1, authorization.low);
                    sTcodeDescriptions.put(authorization.low, DB.preparedStatementGetOne(PS_getTcodeDescription));
                }
                catch (SQLException e) {
                    Log.log("ac.report.tools.RiskUtils getAuthorizationDescription FAILED to get description for tcode '" + authorization.low + "'.");
                    Log.logException(e);
                }
            }
            return sTcodeDescriptions.get(authorization.low);
        }
        if (authorization.object_id == AuthObject.s_StartId(system, client)) {
            if (sStartDescriptions == null) {
                sStartDescriptions = new HashMap();
            }
            if (!sStartDescriptions.containsKey(authorization.low)) {
                if (PS_getStartDescription == null) {
                    PS_getStartDescription = DB.prepareStatement("SELECT `description` FROM um_start WHERE `start` = ? AND `system` = '" + system + "' AND `client` = '" + client + "';");
                }
                try {
                    PS_getStartDescription.setString(1, authorization.low);
                    sStartDescriptions.put(authorization.low, DB.preparedStatementGetOne(PS_getTcodeDescription));
                }
                catch (SQLException e) {
                    Log.log("ac.report.tools.RiskUtils getAuthorizationDescription FAILED to get description for start '" + authorization.low + "'.");
                    Log.logException(e);
                }
            }
            return sStartDescriptions.get(authorization.low);
        }
        if (authorization.object_id == AuthObject.s_ServiceId(system, client)) {
            if (sServiceDescriptions == null) {
                sServiceDescriptions = new HashMap();
            }
            if (!sServiceDescriptions.containsKey(authorization.low)) {
                if (PS_getServiceDescription == null) {
                    PS_getServiceDescription = DB.prepareStatement("SELECT `description` FROM um_service WHERE `service` = ? AND `system` = '" + system + "' AND `client` = '" + client + "';");
                }
                try {
                    PS_getServiceDescription.setString(1, authorization.low);
                    sServiceDescriptions.put(authorization.low, DB.preparedStatementGetOne(PS_getServiceDescription));
                }
                catch (SQLException e) {
                    Log.log("ac.report.tools.RiskUtils getAuthorizationDescription FAILED to get description for service '" + authorization.low + "'.");
                    Log.logException(e);
                }
            }
            return sServiceDescriptions.get(authorization.low);
        }
        return "";
    }

    public static String getOrgLevelAuth(Authorization[] authorizations) {
        ArrayList auths = new ArrayList();
        for (Authorization au : authorizations) {
            if (!OrgLevel.isMonitoredField(au.field_id)) continue;
            auths.add(au.toString());
        }
        if (auths.size() > 0) {
            auths = (ArrayList)Utils.unique(auths);
            return String.join((CharSequence)", ", auths.toArray(Utils.EMPTYSTRINGARRAY));
        }
        return "";
    }
}

