/*
 * Decompiled with CFR 0.152.
 */
package ac.report;

import ac.dashboard.DashboardUserSettings;
import ac.dashboard.ViolationLegacy;
import ac.risk.Group;
import ac.risk.Risk;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Language;
import cn.Log;
import cn.Memory;
import cn.SapUser;
import cn.Translator;
import cn.Utils;
import cn.report.SpanData;
import cn.report.Spreadsheet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class ReportXtab {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Starting dashboard X tab report for " + system + " / " + client);
        ReportXtab.go(system, client);
        Log.log("Ending dashboard X tab report for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void go(String system, String client) {
        Language[] languages;
        Log.log("Getting groups, rules and totals");
        Risk[] affectedRules = ReportXtab.getRules(system, client);
        Group[] groups = ReportXtab.getGroups(system, client);
        ArrayList<Object> rulesLine = new ArrayList<Object>();
        rulesLine.add("User");
        rulesLine.add("Total");
        ArrayList<Object> firstLine = new ArrayList<Object>();
        firstLine.add("Total");
        firstLine.add("");
        int total = 0;
        Group currentGroup = null;
        int currentGroupId = -1;
        int currentSpan = 1;
        for (Risk affectedRule : affectedRules) {
            rulesLine.add(affectedRule.signature + " " + affectedRule.name);
            firstLine.add("" + affectedRule.count);
            total += affectedRule.count;
            ++currentSpan;
            if (currentGroupId == affectedRule.group_id) continue;
            if (currentGroupId > -1) {
                currentGroup.span = currentSpan;
            }
            currentSpan = 0;
            currentGroup = affectedRule.getGroup();
            currentGroupId = affectedRule.group_id;
        }
        if (currentSpan >= 0 && currentGroup != null) {
            currentGroup.span = currentSpan + 1;
        }
        firstLine.set(1, "" + total);
        Log.log(affectedRules.length + " rules in " + groups.length + " groups with a total of " + total + " violations");
        String[][] userLines = ReportXtab.createUserInformation(system, client, affectedRules);
        String[] ruleLine = rulesLine.toArray(Utils.EMPTYSTRINGARRAY);
        String[] totalLine = firstLine.toArray(Utils.EMPTYSTRINGARRAY);
        DashboardUserSettings dus = new DashboardUserSettings(system, client);
        for (Language language : languages = Language.getAvailableLanguages()) {
            String filename = ReportXtab.getFilename(system, client, language.isoString);
            File fd = new File(filename);
            try {
                if (Files.deleteIfExists(fd.toPath())) {
                    Log.log(Memory.statement("Deleted " + filename));
                } else {
                    Log.log(Memory.statement("Did not find " + filename + " to delete."));
                }
            }
            catch (IOException e) {
                Log.log("ReportXtab deleteOldDocument FAILED on " + filename);
                Log.logException(e);
            }
            if (!dus.isLanguageActive(language.isoString)) continue;
            Translator translator = Translator.getInstance(language.isoString);
            Log.log(Memory.statement("Translating to " + language.title));
            SpanData[] translatedGroups = new SpanData[groups.length + 1];
            translatedGroups[0] = new SpanData("", 2);
            for (int i = 0; i < groups.length; ++i) {
                SpanData sd;
                Group g = groups[i];
                translatedGroups[i + 1] = g.id == 0 && !language.isoString.equalsIgnoreCase("en") ? (sd = new SpanData(translator.getText(g.name), g.span)) : (sd = new SpanData(g.name, g.span));
            }
            String[] translatedRules = (String[])ruleLine.clone();
            String[] translatedFirstLine = (String[])totalLine.clone();
            if (!language.isoString.equalsIgnoreCase("en")) {
                translatedRules[0] = translator.getText(ruleLine[0]);
                translatedRules[1] = translator.getText(ruleLine[1]);
                translatedFirstLine[0] = translator.getText(totalLine[0]);
            }
            Log.log(Memory.statement("Creating User Compliance Matrix in " + language.title));
            Spreadsheet excelFile = new Spreadsheet(translator);
            excelFile.addSheet("Compliance Matrix");
            excelFile.writeRowSpan(translatedGroups);
            excelFile.writeRowVertically(translatedRules);
            excelFile.writeRowBold(translatedFirstLine);
            Log.log(Memory.statement("Adding auto-size column."));
            for (int i = 1; i < translatedFirstLine.length; ++i) {
                excelFile.getActiveSheet().autoSizeColumn(i);
            }
            excelFile.getActiveSheet().setColumnWidth(0, 8192);
            excelFile.writeRow(Utils.EMPTYSTRINGARRAY);
            Log.log(Memory.statement("Adding user information."));
            for (String[] line : userLines) {
                excelFile.writeRow(line);
            }
            Log.log(Memory.statement("Adding auto-filter."));
            int lastColumnIndex = rulesLine.size();
            int lastRowIndex = excelFile.getCurrentRowIndex();
            excelFile.setAutoFilter(0, 3, lastColumnIndex, lastRowIndex);
            Log.log(Memory.statement("Adding fill colors."));
            ReportXtab.applyColors(translatedGroups, excelFile);
            Log.log(Memory.statement("Saving file to " + filename));
            excelFile.save(filename);
        }
        Log.log(Memory.statement("User Compliance Matrix done."));
    }

    private static void applyColors(SpanData[] spanData, Spreadsheet excelFile) {
        CellStyle colors1 = excelFile.createCellStyle();
        colors1.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
        colors1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        colors1.setAlignment(HorizontalAlignment.CENTER);
        CellStyle colors2 = excelFile.createCellStyle();
        colors2.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        colors2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        colors2.setAlignment(HorizontalAlignment.CENTER);
        Iterator rowIterator = excelFile.getActiveSheet().iterator();
        int currentRow = 0;
        while (rowIterator.hasNext()) {
            XSSFRow row = (XSSFRow)rowIterator.next();
            Iterator cellIterator = row.cellIterator();
            if (currentRow == 0) {
                q = true;
                for (i = 0; i < spanData.length; ++i) {
                    if (!cellIterator.hasNext()) continue;
                    Cell cell = (Cell)cellIterator.next();
                    if (i > 0) {
                        if (q) {
                            cell.setCellStyle(colors1);
                        } else {
                            cell.setCellStyle(colors2);
                        }
                    }
                    q = !q;
                }
            } else if (currentRow >= 3) {
                q = true;
                for (i = 0; i < spanData.length; ++i) {
                    SpanData sd = spanData[i];
                    for (int j = 0; j < sd.rowSpan; ++j) {
                        if (!cellIterator.hasNext()) continue;
                        Cell cell = (Cell)cellIterator.next();
                        if (i <= 0) continue;
                        if (q) {
                            cell.setCellStyle(colors1);
                            continue;
                        }
                        cell.setCellStyle(colors2);
                    }
                    q = !q;
                }
            }
            ++currentRow;
        }
    }

    private static String[][] createUserInformation(String system, String client, Risk[] affectedRules) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        Log.log("Getting user information.");
        SapUser[] users = ReportXtab.getUsers(system, client);
        Log.log("Found " + users.length + " users.");
        String legacyTable = ViolationLegacy.getLegacyTableName(system, client);
        PreparedStatement psUD = DB.prepareStatement("SELECT `user_id`, `risk_id` AS `myid`, " + legacyTable + ".approved FROM `" + legacyTable + "` WHERE `user_id` = ? ;");
        int count = 0;
        int limit = Utils.ceilDivider(users.length, 25);
        for (SapUser user : users) {
            ArrayList<Object> line = new ArrayList<Object>();
            line.add(user.username + ", " + user.getFirstName() + " " + user.getLastName());
            line.add("" + user.count);
            HashMap<Integer, String> userRiskDetails = new HashMap<Integer, String>();
            try {
                psUD.setInt(1, user.getId());
                ResultSet ud = psUD.executeQuery();
                while (ud.next()) {
                    userRiskDetails.put(ud.getInt("myid"), ud.getBoolean("approved") ? "A" : "X");
                }
                ud.close();
            }
            catch (SQLException e) {
                Log.log("ReportXtab failed to get user violation details.");
                Log.logException(e);
            }
            for (Risk affectedRule : affectedRules) {
                line.add(userRiskDetails.containsKey(affectedRule.id) ? (String)userRiskDetails.get(affectedRule.id) : "");
            }
            lines.add(line.toArray(Utils.EMPTYSTRINGARRAY));
            if (++count % limit != 0) continue;
            Log.log(Memory.statement("Data lines for " + count + " users created."));
        }
        Log.log(Memory.statement("Data lines for " + count + " users created."));
        String[][] content = (String[][])lines.toArray((T[])new String[0][0]);
        return content;
    }

    private static Group[] getGroups(String system, String client) {
        String legacyTable = ViolationLegacy.getLegacyTableName(system, client);
        String sql = "SELECT DISTINCT(group_id) AS `myid`, sod_group.name AS `group` FROM `" + legacyTable + "` JOIN sod_rule ON sod_rule.id = " + legacyTable + ".risk_id JOIN sod_group ON sod_group.id = sod_rule.group_id ORDER BY `group` ASC, `myid` ASC;";
        int[] group_ids = DB.getOneNumberColumn(sql);
        Log.log("Found " + group_ids.length + " groups.");
        Group[] result = new Group[group_ids.length];
        int i = 0;
        for (int group_id : group_ids) {
            result[i++] = Group.getById(group_id);
        }
        return result;
    }

    private static Risk[] getRules(String system, String client) {
        String legacyTable = ViolationLegacy.getLegacyTableName(system, client);
        PreparedStatement getCount = DB.prepareStatement("SELECT COUNT(risk_id) AS `total` FROM `" + legacyTable + "` WHERE risk_id = ? ;");
        String sql = "SELECT DISTINCT(risk_id) AS `myid`, sod_group.name AS `group` FROM `" + legacyTable + "` JOIN sod_rule ON sod_rule.id = " + legacyTable + ".risk_id JOIN sod_group ON sod_group.id = sod_rule.group_id ORDER BY `group` ASC, `myid` ASC;";
        int[] risk_ids = DB.getOneNumberColumn(sql);
        Log.log(Memory.statement("Found " + risk_ids.length + " rules."));
        Risk[] result = new Risk[risk_ids.length];
        int i = 0;
        for (int risk_id : risk_ids) {
            Risk risk = Risk.getById(risk_id);
            try {
                getCount.setInt(1, risk_id);
            }
            catch (SQLException e) {
                Log.log("Setting risk_id in getCount statement failed for " + risk_id);
                Log.logException(e);
            }
            risk.count = DB.preparedStatementGetCount(getCount);
            result[i++] = risk;
        }
        return result;
    }

    private static SapUser[] getUsers(String system, String client) {
        String legacyTable = ViolationLegacy.getLegacyTableName(system, client);
        String sql = "SELECT um_user.id, um_user.user, COUNT(user_id) AS `total`, `first_name`, `last_name` FROM `" + legacyTable + "` LEFT JOIN um_user ON \tum_user.system = '" + system + "' AND \tum_user.client = '" + client + "' AND \tum_user.id = user_id GROUP BY user ORDER BY user ASC;";
        ResultSet rs = DB.getData(sql);
        ArrayList<SapUser> users = new ArrayList<SapUser>();
        try {
            while (rs.next()) {
                SapUser su = new SapUser(rs.getInt(1), rs.getString(2), system, client);
                su.count = rs.getInt(3);
                su.first_name = rs.getString(4);
                su.last_name = rs.getString(5);
                users.add(su);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("ReportXtab failed at getting SapUsers.");
            Log.logException(e);
        }
        return users.toArray(SapUser.EMPTYARRAY);
    }

    private static String getFilename(String system, String client, String languageISOcode) {
        Object filename = Config.getReportPath();
        filename = (String)filename + "AC_User_Risk_Matrix_";
        filename = (String)filename + system + "_" + client + "_" + languageISOcode + ".xlsx";
        return filename;
    }
}

