/*
 * Decompiled with CFR 0.152.
 */
package ac.report;

import ac.report.tools.PreventiveCheckDetails;
import ac.report.tools.WorkflowUtils;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.TaskParameters;
import cn.Translator;
import cn.Utils;
import cn.report.Spreadsheet;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;

public class PreventiveCheckLog {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        String rawfilter = myArgs.get("filter");
        Log.log(rawfilter);
        TaskParameters filters = rawfilter != null ? new TaskParameters(Utils.decodeUrlValue(rawfilter)) : null;
        String filename = Config.getReportPath() + filters.getString("filename");
        Translator translator = Translator.getInstance(filters.getString("language"));
        Log.log("Starting preventive check log report for " + system + " / " + client + " " + filename + " with the params " + filters.toString());
        boolean notPartial = PreventiveCheckLog.createFile(system, client, filters, filename, translator);
        Log.log("Ending preventive check log report for " + system + " / " + client + " " + filename);
        DB.close();
        Log.close();
        if (notPartial) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean createFile(String system, String client, TaskParameters filters, String filename, Translator translator) {
        v0 = filters != null ? filters.isSet("filterDetails") : (details = false);
        if (details) {
            Log.log("Starting preventive check log report with details.");
        } else {
            Log.log("Starting preventive check log report with NO details.");
        }
        if (details) {
            v1 = new String[11];
            v1[0] = "Timestamp";
            v1[1] = "Admin";
            v1[2] = "Completed";
            v1[3] = "Action";
            v1[4] = "Action time";
            v1[5] = "Status";
            v1[6] = "Approved";
            v1[7] = "Risk ID";
            v1[8] = "Risk";
            v1[9] = "Username";
            v2 = v1;
            v1[10] = "Approvers";
        } else {
            v3 = new String[8];
            v3[0] = "Timestamp";
            v3[1] = "Admin";
            v3[2] = "Completed";
            v3[3] = "Action";
            v3[4] = "Action time";
            v3[5] = "Status";
            v3[6] = "Username";
            v2 = v3;
            v3[7] = "Approvers";
        }
        headers = v2;
        excel = new Spreadsheet(translator);
        excel.addSheet("Data");
        excel.writeHeaders(headers);
        statement = PreventiveCheckLog.getStatement(system, client, filters, details);
        Log.log("Getting data from:\n" + statement);
        moreRowsAvailable = true;
        rs = DB.getData(statement);
lbl40:
        // 2 sources

        try {
            while (rs.next() && moreRowsAvailable) {
                block9: {
                    handle = rs.getString("handle");
                    action = rs.getString("action") != null ? rs.getString("action") : "";
                    v4 = status = action.equals("workflow") != false ? translator.getText(WorkflowUtils.getStatusText(WorkflowUtils.getStatus(handle))) : "";
                    if (!details) break block9;
                    pcds = PreventiveCheckDetails.getPreventiveCheckDetails(handle, system, client);
                    if (pcds == null) continue;
                    for (PreventiveCheckDetails pcd : pcds) {
                        excelLine = new String[]{rs.getString("timestamp"), rs.getString("username"), rs.getString("analysis_complete"), translator.getText(action), rs.getString("action_ts"), status, action.equals("workflow") == false ? "" : (pcd.approved != false ? translator.getText("Yes") : translator.getText("No")), pcd.risk_ids, pcd.risks, pcd.usernames, pcd.approvers};
                        if (!moreRowsAvailable) continue;
                        moreRowsAvailable = excel.writeRow(excelLine);
                    }
                    ** GOTO lbl40
                }
                pcd = PreventiveCheckDetails.getPreventiveCheckDetailsSummary(handle, system, client);
                excelLine = new String[]{rs.getString("timestamp"), rs.getString("username"), rs.getString("analysis_complete"), translator.getText(action), rs.getString("action_ts"), status, pcd.usernames, pcd.approvers};
                if (!moreRowsAvailable) continue;
                moreRowsAvailable = excel.writeRow(excelLine);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("documents.ac.PreventiveCheckLog was not able to work with results.");
            Log.logException(e);
        }
        if (!moreRowsAvailable) {
            Log.log("documents.ac.PreventiveCheckLog ran out of space in Excel file - results are partial.");
            excel.writeRow(new String[]{"There may be more results that cannot be shown due to Excel limitations."});
        }
        Log.log("documents.ac.PreventiveCheckLog Adding autofilter");
        excel.addAutoFilter(headers.length);
        Log.log("documents.ac.PreventiveCheckLog Autosize columns");
        excel.autoSizeAllColumns(headers.length);
        excel.save(filename);
        return moreRowsAvailable;
    }

    private static String getStatement(String system, String client, TaskParameters filters, boolean details) {
        String filter = filters == null ? "" : PreventiveCheckLog.getStatementFilter(system, client, filters);
        Log.log("ac.report.documents.PreventiveCheckLog getStatement filter: " + filter);
        Object statement = "SELECT DISTINCT(sod_preventive_check.handle),\nsod_preventive_check.timestamp,\nsod_preventive_check.system,\nsod_preventive_check.client,\nsod_preventive_check.username,\nsod_preventive_check.analysis_complete,\nsod_preventive_check.action,\nsod_preventive_check.action_ts,\nsod_preventive_check.assignments_json \nFROM sod_preventive_check ";
        String spcv = PreventiveCheckLog.getTablenameViolation(system, client);
        String join = "\nRIGHT ";
        if (filters != null && filters.isSet("filterShowOnly") && filters.getString("filterShowOnly").equalsIgnoreCase("all")) {
            join = "\nLEFT ";
        }
        statement = (String)statement + join + "JOIN `" + spcv + "` ON " + spcv + ".handle = sod_preventive_check.handle \n";
        return (String)statement + filter + "ORDER BY timestamp DESC\nLIMIT 1048576;";
    }

    private static String getStatementFilter(String system, String client, TaskParameters filters) {
        ArrayList<CallSite> filter = new ArrayList<CallSite>();
        if (filters != null) {
            Log.log("ac.report.documents.PreventiveCheckLog getStatementFilter data: " + filters.toString());
            String spcv = PreventiveCheckLog.getTablenameViolation(system, client);
            if (filters.isSet("filterDateFrom") || filters.isSet("filterDateTo")) {
                if (filters.isSet("filterDateFrom") && filters.isSet("filterDateTo")) {
                    filter.add((CallSite)((Object)("sod_preventive_check.timestamp BETWEEN '" + filters.getString("filterDateFrom") + " 00:00:00' AND '" + filters.getString("filterDateTo") + " 23:59:59' \n")));
                } else if (filters.isSet("filterDateFrom")) {
                    filter.add((CallSite)((Object)("sod_preventive_check.timestamp BETWEEN '" + filters.getString("filterDateFrom") + " 00:00:00' AND '" + filters.getString("filterDateFrom") + " 23:59:59' \n")));
                } else {
                    filter.add((CallSite)((Object)("sod_preventive_check.timestamp BETWEEN '" + filters.getString("filterDateTo") + " 00:00:00' AND '" + filters.getString("filterDateTo") + " 23:59:59' \n")));
                }
            }
            if (filters.isSet("filterUser")) {
                String user = filters.getString("filterUser").replace("*", "%");
                filter.add((CallSite)((Object)("sod_preventive_check.assignments_json LIKE '%\"username\":\"" + user + "\"%' \n")));
            }
            if (filters.isSet("filterApprover")) {
                String approver = filters.getString("filterApprover").replace("*", "%");
                filter.add((CallSite)((Object)(spcv + ".approver LIKE '%" + approver + "%' \n")));
            }
            if (filters.isSet("filterAdmin")) {
                String admin = filters.getString("filterAdmin").replace("*", "%");
                filter.add((CallSite)((Object)("sod_preventive_check.username LIKE '" + admin + "' \n")));
            }
            if (filters.isSet("filterAction") && !filters.getString("filterAction").equalsIgnoreCase("all")) {
                filter.add((CallSite)((Object)("sod_preventive_check.action = '" + filters.getString("filterAction") + "' \n")));
            }
            if (!filters.isSet("filterShowOnly") || filters.getString("filterShowOnly").equalsIgnoreCase("newRisks")) {
                filter.add((CallSite)((Object)("(sod_preventive_check.assignments_json LIKE '%\"new\":true%' OR sod_preventive_check.assignments_json LIKE '%\"new\":\"\"%' ) AND " + spcv + ".type <> 'pre' \n")));
            }
        }
        if (filter.size() > 0) {
            return "WHERE " + String.join((CharSequence)" AND ", filter.toArray(Utils.EMPTYSTRINGARRAY)) + "\n";
        }
        return "";
    }

    public static String getTablenameViolation(String system, String client) {
        return "sod_preventive_check_violation_" + system.toLowerCase() + "_" + client.toLowerCase();
    }
}

