/*
 * Decompiled with CFR 0.152.
 */
package ac.report;

import ac.dashboard.ViolationLegacy;
import ac.risk.Risk;
import cn.Arguments;
import cn.DB;
import cn.Log;
import cn.Role;
import cn.TaskParameters;
import cn.Translator;
import cn.Utils;
import cn.report.Spreadsheet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class CurrentWorkflows {
    private static PreparedStatement PS_GETLEGACYUSER;

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        String filename = myArgs.get("filename");
        String rawfilter = myArgs.get("filter");
        TaskParameters filters = new TaskParameters(Utils.decodeUrlValue(rawfilter));
        String filter = filters.getString("filter");
        Log.log("Starting current workflows report for " + system + " / " + client + " " + filename + " with the params " + filters.toString());
        Translator translator = Translator.getInstance(myArgs.get("language"));
        CurrentWorkflows.createFile(system, client, filter, filename, translator);
        Log.log("Ending current workflows report for " + system + " / " + client + " " + filename);
        DB.close();
        Log.close();
    }

    private static void createFile(String system, String client, String filter, String filename, Translator translator) {
        String[] headers = new String[]{"Timestamp", "Admin", "Users", "Approvers", "Roles", "Legacy", "Status", "Comments"};
        String legacyTable = ViolationLegacy.getLegacyTableName(system, client);
        PS_GETLEGACYUSER = DB.prepareStatement("SELECT um_user.user, um_user.first_name, um_user.last_name FROM `%s`\nLEFT JOIN um_user ON um_user.id = %s.user_id\nWHERE %s.id = ?;\n".formatted(legacyTable, legacyTable, legacyTable));
        String approvedString = "approved";
        Spreadsheet excel = new Spreadsheet(translator);
        excel.addSheet("Data");
        excel.writeHeaders(headers);
        String statement = CurrentWorkflows.getStatement(system, client, filter);
        Log.log("Getting data from:\n" + statement);
        ResultSet rs = DB.getData(statement);
        int rowNumber = 0;
        try {
            while (rs.next()) {
                ++rowNumber;
                String assignments_json = rs.getString("assignments_json");
                int legacyId = rs.getInt("violation_id");
                String[] excelLine = new String[]{rs.getString("timestamp"), rs.getString("admin"), legacyId > 0 ? CurrentWorkflows.getLegacyUser(legacyId) : CurrentWorkflows.extractUsers(assignments_json), CurrentWorkflows.extractApprovers(rs.getString("approval_details")), legacyId > 0 ? CurrentWorkflows.getLegacyRoles(legacyId, system, client) : CurrentWorkflows.extractRoles(assignments_json), legacyId > 0 ? translator.getText("Yes") : translator.getText("No"), translator.getText(Utils.titleCase(rs.getString("status"))), rs.getString("approvalText")};
                excel.writeRow(excelLine);
            }
        }
        catch (Exception e) {
            Log.log("CurrentWorkflows failed writing report entry " + rowNumber + ".");
            Log.logException(e);
        }
        Log.log("documents.ac.CurrentWorkflows Adding autofilter");
        excel.addAutoFilter(headers.length);
        Log.log("documents.ac.CurrentWorkflows Autosize columns");
        excel.autoSizeAllColumns(headers.length);
        excel.save(filename);
    }

    private static String getStatement(String system, String client, String filter) {
        String sql = "\tSELECT DISTINCT sod_workflow.handle,\n\t\t\tsod_workflow.violation_id,\n\t\t\tsod_workflow.created as timestamp,\n\t\t\tsod_workflow.admin,\n\t\t\tsod_workflow.status,\n\t\t\tsod_preventive_check.assignments_json,\n\t\t\tsod_workflow.approval_details,\n      \t\tGROUP_CONCAT(CONCAT(sod_workflow_approval.user, ': ', sod_workflow_approval.comment) SEPARATOR '%s')  AS approvalText\n\t   FROM sod_workflow\n\t\tLEFT JOIN sod_preventive_check ON sod_workflow.handle = sod_preventive_check.handle\n\t  \tLEFT JOIN sod_workflow_approval ON sod_workflow.handle = sod_workflow_approval.handle\n  \t\tWHERE sod_workflow.system = '%s' AND sod_workflow.client = '%s'\n  \t\t%s\n\tGROUP BY sod_workflow.handle\n\tORDER BY sod_workflow.created DESC\n".formatted(System.lineSeparator(), system, client, filter);
        return sql;
    }

    private static String getLegacyUser(int legacyId) {
        Object usernameData = "";
        try {
            PS_GETLEGACYUSER.setInt(1, legacyId);
            ResultSet rs = PS_GETLEGACYUSER.executeQuery();
            while (rs.next()) {
                String first_name = rs.getString("first_name");
                String last_name = rs.getString("last_name");
                String username = rs.getString("user");
                if (first_name.length() > 0) {
                    usernameData = first_name + " " + last_name + " " + username;
                    continue;
                }
                usernameData = last_name + " " + username;
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed to get user data from legacy id: " + legacyId);
            Log.logException(e);
        }
        return usernameData;
    }

    private static String extractUsers(String assignments_json) {
        ArrayList<String> extracted = new ArrayList<String>();
        if (assignments_json != null) {
            JSONArray assignments = new JSONArray(assignments_json);
            for (int i = 0; i < assignments.length(); ++i) {
                JSONObject user = assignments.getJSONObject(i).getJSONObject("user");
                StringBuilder sb = new StringBuilder(user.getString("username"));
                String fullname = DB.getOne("SELECT CONCAT(first_name, ' ', last_name, ' ') AS name FROM um_user WHERE user = '" + user.getString("username") + "' AND `system` = '" + user.getString("system") + "' AND `client` = '" + user.getString("client") + "';");
                if (fullname != null) {
                    fullname.trim();
                    sb.insert(0, fullname + " ");
                }
                extracted.add(sb.toString());
            }
        }
        return String.join((CharSequence)", ", Utils.unique(extracted.toArray(Utils.EMPTYSTRINGARRAY)));
    }

    private static String extractApprovers(String approval_details) {
        ArrayList<String> extracted = new ArrayList<String>();
        if (approval_details != null) {
            JSONArray data = new JSONArray(approval_details);
            for (int i = 0; i < data.length(); ++i) {
                JSONObject jo = data.getJSONObject(i);
                JSONArray approvers = jo.getJSONArray("approvers");
                for (int j = 0; j < approvers.length(); ++j) {
                    StringBuilder sb = new StringBuilder();
                    JSONObject approver = approvers.getJSONObject(j);
                    sb.append(approver.get("approverText"));
                    try {
                        if (approver.getString("username") != null) {
                            sb.append(" ");
                            sb.append(approver.get("username"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.append(" ");
                    sb.append("(" + approver.getString("system") + "/" + approver.getString("client") + ")");
                    try {
                        if (approver.getString("substitute") != null) {
                            sb.append(" ");
                            sb.append("[" + approver.getString("substitute") + "]");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    extracted.add(sb.toString());
                }
            }
        }
        return String.join((CharSequence)", ", Utils.unique(extracted.toArray(Utils.EMPTYSTRINGARRAY)));
    }

    private static String getLegacyRoles(int legacyId, String system, String client) {
        ArrayList<String> extracted = new ArrayList<String>();
        String table = ViolationLegacy.getLegacyTableName(system, client);
        String causes_json = DB.getOne("SELECT causes FROM `" + table + "` WHERE id = " + legacyId);
        if (causes_json == null) {
            return "";
        }
        int risk_id = DB.getOneInt("SELECT risk_id FROM `" + table + "` WHERE id = " + legacyId);
        Risk risk = Risk.getById(risk_id);
        JSONArray fullCauses = new JSONArray(causes_json);
        try {
            switch (risk.type) {
                case "crit_role": 
                case "sod_role2": {
                    for (int i = 0; i < fullCauses.length(); ++i) {
                        JSONArray roles = fullCauses.getJSONArray(i);
                        for (int j = 0; j < roles.length(); ++j) {
                            JSONObject role = roles.getJSONObject(j);
                            Object rolename = Role.getRolenameFromId(role.getInt("r_id"));
                            if (role.getInt("c_id") > 0) {
                                rolename = (String)rolename + "(" + Role.getRolenameFromId(role.getInt("c_id")) + ")";
                            }
                            extracted.add((String)rolename);
                        }
                    }
                    break;
                }
                case "crit_tcode": {
                    for (int i = 0; i < fullCauses.length(); ++i) {
                        JSONObject entry = fullCauses.getJSONObject(i);
                        JSONArray roles = entry.getJSONArray("role");
                        for (int j = 0; j < roles.length(); ++j) {
                            JSONObject role = roles.getJSONObject(j);
                            Object rolename = Role.getRolenameFromId(role.getInt("r_id"));
                            if (role.getInt("c_id") > 0) {
                                rolename = (String)rolename + "(" + Role.getRolenameFromId(role.getInt("c_id")) + ")";
                            }
                            extracted.add((String)rolename);
                        }
                    }
                    break;
                }
                case "sod_func": {
                    for (int i = 0; i < fullCauses.length(); ++i) {
                        JSONObject entry = fullCauses.getJSONObject(i);
                        JSONArray acts = entry.getJSONArray("acts");
                        for (int a = 0; a < acts.length(); ++a) {
                            JSONObject act = acts.getJSONObject(a);
                            JSONArray roles = act.getJSONArray("role");
                            for (int j = 0; j < roles.length(); ++j) {
                                JSONObject role = roles.getJSONObject(j);
                                Object rolename = Role.getRolenameFromId(role.getInt("r_id"));
                                if (role.getInt("c_id") > 0) {
                                    rolename = (String)rolename + "(" + Role.getRolenameFromId(role.getInt("c_id")) + ")";
                                }
                                extracted.add((String)rolename);
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.log("Failed to get role data from legacy id: " + legacyId + " type: " + risk.type);
            Log.logException(e);
            return "";
        }
        return String.join((CharSequence)", ", Utils.unique(extracted.toArray(Utils.EMPTYSTRINGARRAY)));
    }

    private static String extractRoles(String assignments_json) {
        ArrayList<String> extracted = new ArrayList<String>();
        if (assignments_json != null) {
            JSONArray assignments = new JSONArray(assignments_json);
            for (int i = 0; i < assignments.length(); ++i) {
                JSONArray roles = assignments.getJSONObject(i).getJSONArray("roles");
                for (int j = 0; j < roles.length(); ++j) {
                    extracted.add(roles.getJSONObject(j).getString("role"));
                }
            }
        }
        return String.join((CharSequence)", ", Utils.unique(extracted.toArray(Utils.EMPTYSTRINGARRAY)));
    }
}

