/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import cn.Role;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;

class Role_Tuple {
    private static final HashMap<String, Role_Tuple> instances = new HashMap();
    private final Role role;
    private final Role composite;

    public static Role_Tuple createTuple(Role role, Role composite) {
        String key = Role_Tuple.makeKey(role, composite);
        if (!instances.containsKey(key)) {
            instances.put(key, new Role_Tuple(role, composite));
        }
        return instances.get(key);
    }

    private static String makeKey(Role role, Role composite) {
        String single = role.name + ";" + role.system + ";" + role.client;
        return composite == null ? single : single + ";" + composite.name + ";" + composite.system + ";" + composite.client;
    }

    private Role_Tuple(Role role, Role composite) {
        this.role = role;
        this.composite = composite;
    }

    public Role getRole() {
        return this.role;
    }

    public String getCompositeName() {
        if (this.composite == null) {
            return "";
        }
        return this.composite.name;
    }

    public int hashCode() {
        return Objects.hash(this.role, this.composite);
    }

    public static ArrayList<Role_Tuple> uniquify(ArrayList<Role_Tuple> inputList) {
        HashSet<Role_Tuple> uniqueSet = new HashSet<Role_Tuple>(inputList);
        return new ArrayList<Role_Tuple>(uniqueSet);
    }
}

