/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import ac.notification.NotificationViolation;
import ac.notification.Role_Tuple;
import ac.risk.Risk;
import cn.Log;
import cn.Role;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

class RoleExtractor {
    private static ArrayList<Role_Tuple> newAssigned;
    private static ArrayList<Role_Tuple> oldAssigned;

    RoleExtractor() {
    }

    public static HashMap<String, ArrayList<Role_Tuple>> getAffectedRoles(ArrayList<NotificationViolation> violations, boolean legacy) {
        ArrayList<Role_Tuple> oldRole = new ArrayList<Role_Tuple>();
        ArrayList<Role_Tuple> newRole = new ArrayList<Role_Tuple>();
        try {
            for (NotificationViolation v : violations) {
                Risk risk = Risk.getById(v.getRuleId());
                String jsonString = v.getCauseString();
                JSONArray jsonArray = new JSONArray(jsonString);
                block13: for (int i = 0; i < jsonArray.length(); ++i) {
                    switch (risk.type) {
                        case "crit_tcode": {
                            JSONObject causeObject = jsonArray.getJSONObject(i);
                            if (causeObject.isEmpty()) continue block13;
                            RoleExtractor.getRoleIdsFromTCode(causeObject, legacy);
                            oldRole.addAll(RoleExtractor.getOldAssigned());
                            newRole.addAll(RoleExtractor.getNewAssigned());
                            continue block13;
                        }
                        case "sod_func": {
                            JSONObject causeObject = jsonArray.getJSONObject(i);
                            if (causeObject.isEmpty()) continue block13;
                            RoleExtractor.getRoleIdsFromSoDFunc(causeObject, legacy);
                            oldRole.addAll(RoleExtractor.getOldAssigned());
                            newRole.addAll(RoleExtractor.getNewAssigned());
                            continue block13;
                        }
                        case "sod_role2": {
                            JSONArray causeArray = jsonArray.getJSONArray(i);
                            RoleExtractor.getRoleIdsFromRoles(causeArray, legacy);
                            oldRole.addAll(RoleExtractor.getOldAssigned());
                            newRole.addAll(RoleExtractor.getNewAssigned());
                            continue block13;
                        }
                        default: {
                            Log.log("unregisted Risk type, no Roles retrieved");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Log.log("ac.notification.RoleExtractor.getAffectedRoles() LegacyRole failed to set JSON Object");
            Log.logException(e);
        }
        HashMap<String, ArrayList<Role_Tuple>> returnHash = new HashMap<String, ArrayList<Role_Tuple>>();
        returnHash.put("unAssigned", Role_Tuple.uniquify(oldRole));
        returnHash.put("assigned", Role_Tuple.uniquify(newRole));
        return returnHash;
    }

    private static void setNewAssigned(ArrayList<Role_Tuple> newArray) {
        newAssigned = newArray;
    }

    private static void setOldAssigned(ArrayList<Role_Tuple> oldArray) {
        oldAssigned = oldArray;
    }

    private static ArrayList<Role_Tuple> getNewAssigned() {
        return newAssigned;
    }

    private static ArrayList<Role_Tuple> getOldAssigned() {
        return oldAssigned;
    }

    private static void getRoleIdsFromTCode(JSONObject jsonCause, boolean legacy) {
        ArrayList<Role_Tuple> roleNew = new ArrayList<Role_Tuple>();
        ArrayList<Role_Tuple> roleOld = new ArrayList<Role_Tuple>();
        try {
            JSONArray roleArray = jsonCause.getJSONArray("role");
            for (int j = 0; j < roleArray.length(); ++j) {
                JSONObject roleObject = roleArray.getJSONObject(j);
                int r_id = roleObject.getInt("r_id");
                int c_id = roleObject.getInt("c_id");
                Role role = Role.getById(r_id);
                Role comp_role = Role.getById(c_id);
                Role_Tuple roleTuple = Role_Tuple.createTuple(role, comp_role);
                if (roleObject.getBoolean("assign")) {
                    roleNew.add(roleTuple);
                    continue;
                }
                roleOld.add(roleTuple);
            }
        }
        catch (Exception e) {
            Log.log("ac.notification.RoleExtractor.getRoleIdsFromTCode() unexpected format for T-code cause");
            Log.logException(e);
        }
        RoleExtractor.setNewAssigned(roleNew);
        RoleExtractor.setOldAssigned(roleOld);
    }

    private static void getRoleIdsFromRoles(JSONArray causeArray, boolean legacy) {
        ArrayList<Role_Tuple> roleNew = new ArrayList<Role_Tuple>();
        ArrayList<Role_Tuple> roleOld = new ArrayList<Role_Tuple>();
        try {
            for (int j = 0; j < causeArray.length(); ++j) {
                JSONObject jsonCause = causeArray.getJSONObject(j);
                if (jsonCause.isEmpty()) continue;
                int r_id = jsonCause.getInt("r_id");
                int c_id = jsonCause.getInt("c_id");
                Role role = Role.getById(r_id);
                Role comp_role = Role.getById(c_id);
                Role_Tuple roleTuple = Role_Tuple.createTuple(role, comp_role);
                if (jsonCause.getBoolean("assign")) {
                    roleNew.add(roleTuple);
                    continue;
                }
                roleOld.add(roleTuple);
            }
        }
        catch (Exception e) {
            Log.log("ac.notification.RoleExtractor.getRoleIdsFromRoles() unexpected format for Role cause");
            Log.logException(e);
        }
        RoleExtractor.setNewAssigned(roleNew);
        RoleExtractor.setOldAssigned(roleOld);
    }

    private static void getRoleIdsFromSoDFunc(JSONObject jsonCause, boolean legacy) {
        ArrayList<Role_Tuple> roleNew = new ArrayList<Role_Tuple>();
        ArrayList<Role_Tuple> roleOld = new ArrayList<Role_Tuple>();
        try {
            JSONArray actsArray = jsonCause.getJSONArray("acts");
            for (int j = 0; j < actsArray.length(); ++j) {
                JSONObject innerObject = actsArray.getJSONObject(j);
                if (!innerObject.has("role")) continue;
                JSONArray roleArray = innerObject.getJSONArray("role");
                for (int k = 0; k < roleArray.length(); ++k) {
                    JSONObject roleObject = roleArray.getJSONObject(k);
                    Role role = Role.getById(roleObject.getInt("r_id"));
                    Role comp_role = Role.getById(roleObject.getInt("c_id"));
                    Role_Tuple roleTuple = Role_Tuple.createTuple(role, comp_role);
                    if (roleObject.getBoolean("assign")) {
                        roleNew.add(roleTuple);
                        continue;
                    }
                    roleOld.add(roleTuple);
                }
            }
        }
        catch (Exception e) {
            Log.log("ac.notification.RoleExtractor.getRoleIdsFromSoDFunc() json format was unexpected for SOD Functions");
            Log.logException(e);
        }
        RoleExtractor.setNewAssigned(roleNew);
        RoleExtractor.setOldAssigned(roleOld);
    }
}

