/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import ac.Workflow;
import ac.notification.NotificationSettings;
import ac.notification.NotificationViolation;
import ac.notification.RoleExtractor;
import ac.notification.Role_Tuple;
import cn.DB;
import cn.Email;
import cn.Log;
import cn.SapUser;
import cn.Utils;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class NotificationWorkflowHelper {
    static PreparedStatement PS_saveSchedule = DB.prepareStatement("INSERT INTO sod_legacy_notification_que (`handle`, `admin`, `system`, `client`) VALUES (?, ?, ?, ?);");
    private Integer violation_id;
    private String system;
    private String client;
    private String handle;
    private boolean isLegacy;
    private ArrayList<NotificationViolation> violations;

    public NotificationWorkflowHelper(Integer violation_id, Boolean isLegacy, String system, String client, String handle) {
        this.violation_id = violation_id;
        this.isLegacy = isLegacy;
        this.system = system;
        this.client = client;
        this.handle = handle;
        this.violations = null;
    }

    public String getSystem() {
        return this.system;
    }

    public String getClient() {
        return this.client;
    }

    public ArrayList<NotificationViolation> setViolations() {
        if (this.violations != null) {
            Log.log("already Set");
            return this.violations;
        }
        this.violations = NotificationViolation.getViolations(this.violation_id, this.handle, this.isLegacy, this.system, this.client);
        return this.violations;
    }

    private static ArrayList<SapUser> uniqifyList(List<SapUser> list) {
        HashSet<String> uniqueUsernames = new HashSet<String>();
        ArrayList<SapUser> uniqifiedList = new ArrayList<SapUser>();
        for (SapUser sapUser : list) {
            String username = sapUser.username;
            if (!uniqueUsernames.add(username)) continue;
            uniqifiedList.add(new SapUser(username, sapUser.system, sapUser.client));
        }
        return uniqifiedList;
    }

    public HashMap<String, ArrayList<Role_Tuple>> getAffectedRoles() {
        return RoleExtractor.getAffectedRoles(this.violations, this.isLegacy);
    }

    public ArrayList<SapUser> getAffectedUsers() {
        ArrayList<SapUser> users = new ArrayList<SapUser>();
        this.setViolations();
        for (NotificationViolation v : this.violations) {
            users.add(v.getUser());
        }
        users = NotificationWorkflowHelper.uniqifyList(users);
        return users;
    }

    public boolean isLegacy() {
        return this.violation_id != null;
    }

    public static ArrayList<String> getApproverSubstituteEmails(JSONArray jsonArray, String system, String client) {
        Log.log("ac.notification.NotificationWorkflowHelper retrieving substitute email");
        ArrayList<String> emails = new ArrayList<String>();
        HashSet<String> usedValues = new HashSet<String>();
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject approver = jsonArray.getJSONObject(i);
                JSONArray detail = approver.getJSONArray("approvers");
                for (int j = 0; j < detail.length(); ++j) {
                    String approverString;
                    String substituteValue;
                    JSONObject substitute = detail.getJSONObject(j);
                    if (!substitute.has("substitute") || null == (substituteValue = substitute.get("substitute").toString()) || "null" == substituteValue || usedValues.contains(approverString = substitute.get("username").toString())) continue;
                    usedValues.add(substitute.get("substitute").toString());
                    SapUser SubstituteTemp = new SapUser(substituteValue, system, client);
                    emails.add(SubstituteTemp.getEmail());
                }
            }
        }
        catch (Exception e) {
            Log.log("ac.notification.NotificationWorkflowHelper Error while getting substitute from cause");
            Log.logException(e);
        }
        return emails;
    }

    public static HashMap<String, JSONObject> approverExtractor(JSONArray array) {
        JSONArray details = new JSONArray(array);
        HashMap<String, JSONObject> approversMap = new HashMap<String, JSONObject>();
        for (int i = 0; i < details.length(); ++i) {
            JSONObject detail = details.getJSONObject(i);
            JSONArray approversArray = detail.getJSONArray("approvers");
            for (int j = 0; j < approversArray.length(); ++j) {
                JSONObject approver = approversArray.getJSONObject(j);
                String approverText = approver.getString("approverText");
                approversMap.put(approverText, approver);
            }
        }
        return approversMap;
    }

    private static boolean checkEmailArray(ArrayList<String> myArray) {
        if (myArray == null || myArray.isEmpty() || myArray.get(0).isEmpty()) {
            Log.log("not a useable Email Array: " + myArray);
            return false;
        }
        return true;
    }

    private static void mergeArrayLists(ArrayList<String> listA, ArrayList<String> listB) {
        if (listA != null && listB != null) {
            Log.log("merging: " + listA + listB);
            listA.addAll(listB);
        }
    }

    public static HashMap<String, ArrayList<String>> getMailsAddresses(Workflow workflow, NotificationSettings settings) {
        ArrayList<String> to = new ArrayList<String>();
        ArrayList<String> cc = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(workflow.getMailAddrUsers()));
        ArrayList<String> approvers = new ArrayList<String>(Arrays.asList(workflow.getMailAddrApprovers()));
        ArrayList<String> substitutes = NotificationWorkflowHelper.getApproverSubstituteEmails(workflow.getApprovalDetails(), workflow.getAdmin().system, workflow.getAdmin().client);
        ArrayList<String> admins = new ArrayList<String>(Arrays.asList(workflow.getAddrAdmins()));
        switch (workflow.getStatus()) {
            case "pending": {
                Log.log("AC/Notification/TaskHandler case pending");
                if (settings.mailRequestUser() && NotificationWorkflowHelper.checkEmailArray(users)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, users);
                }
                if (settings.mailRequestApprover() && NotificationWorkflowHelper.checkEmailArray(approvers)) {
                    NotificationWorkflowHelper.mergeArrayLists(to, approvers);
                }
                if (settings.mailRequestApprover() && NotificationWorkflowHelper.checkEmailArray(substitutes)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, substitutes);
                }
                if (!settings.mailRequestAdmin() || !NotificationWorkflowHelper.checkEmailArray(admins)) break;
                NotificationWorkflowHelper.mergeArrayLists(cc, admins);
                break;
            }
            case "cancelled": {
                Log.log("AC/Notification/TaskHandler case cancel");
                if (settings.mailRequestUser() && NotificationWorkflowHelper.checkEmailArray(users)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, users);
                }
                if (settings.mailRequestApprover() && NotificationWorkflowHelper.checkEmailArray(approvers)) {
                    NotificationWorkflowHelper.mergeArrayLists(to, approvers);
                }
                if (settings.mailRequestApprover() && NotificationWorkflowHelper.checkEmailArray(substitutes)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, substitutes);
                }
                if (!settings.mailRequestAdmin() || !NotificationWorkflowHelper.checkEmailArray(admins)) break;
                NotificationWorkflowHelper.mergeArrayLists(cc, admins);
                break;
            }
            case "approved": {
                Log.log("AC/Notification/TaskHandler case approved");
                if (settings.mailApprovedUser() && NotificationWorkflowHelper.checkEmailArray(users)) {
                    NotificationWorkflowHelper.mergeArrayLists(to, users);
                }
                if (settings.mailApprovedApprover() && NotificationWorkflowHelper.checkEmailArray(approvers)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, approvers);
                }
                if (settings.mailApprovedApprover() && NotificationWorkflowHelper.checkEmailArray(substitutes)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, substitutes);
                }
                if (!settings.mailApprovedAdmin() || !NotificationWorkflowHelper.checkEmailArray(admins)) break;
                NotificationWorkflowHelper.mergeArrayLists(cc, admins);
                break;
            }
            case "rejected": {
                Log.log("AC/Notification/TaskHandler case rejected");
                if (settings.mailRejectedUser() && NotificationWorkflowHelper.checkEmailArray(users)) {
                    NotificationWorkflowHelper.mergeArrayLists(to, users);
                }
                if (settings.mailRejectedApprover() && NotificationWorkflowHelper.checkEmailArray(approvers)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, approvers);
                }
                if (settings.mailRejectedApprover() && NotificationWorkflowHelper.checkEmailArray(substitutes)) {
                    NotificationWorkflowHelper.mergeArrayLists(cc, substitutes);
                }
                if (!settings.mailRejectedAdmin() || !NotificationWorkflowHelper.checkEmailArray(admins)) break;
                NotificationWorkflowHelper.mergeArrayLists(cc, admins);
                break;
            }
            default: {
                Log.log("Workflow does not have valid status! " + workflow.getStatus());
            }
        }
        ArrayList<String> uniqueListTo = new ArrayList<String>();
        ArrayList<String> uniqueListCC = new ArrayList<String>();
        HashMap<String, ArrayList<String>> returnVal = new HashMap<String, ArrayList<String>>();
        cc.removeAll(to);
        for (String email : to) {
            if (!Email.isValidEmail(email)) continue;
            uniqueListTo.add(email);
        }
        for (String email : cc) {
            if (!Email.isValidEmail(email)) continue;
            uniqueListCC.add(email);
        }
        Utils.uniquefyArrayList(uniqueListTo);
        Utils.uniquefyArrayList(uniqueListCC);
        returnVal.put("to", uniqueListTo);
        returnVal.put("cc", uniqueListCC);
        return returnVal;
    }
}

