/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import cn.DB;
import cn.Log;
import cn.SapUser;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;

class NotificationViolation {
    private int id;
    private int rule_id;
    private String handle;
    private SapUser user;
    private String causes;

    private NotificationViolation(String handle, int id, int rule_id, SapUser user, String causes) {
        this.handle = handle;
        this.id = id;
        this.rule_id = rule_id;
        this.user = user;
        this.causes = causes;
    }

    public String getHandle() {
        return this.handle;
    }

    public String getCauseString() {
        return this.causes;
    }

    public int getId() {
        return this.id;
    }

    public int getRuleId() {
        return this.rule_id;
    }

    public SapUser getUser() {
        return this.user;
    }

    private static ArrayList<String> getNoneApprovedValuesFromTable(String handle) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            ResultSet rs = DB.getData("SHOW TABLES LIKE 'sod_preventive_check_violation_%';");
            while (rs.next()) {
                String tableName = rs.getString(1);
                Log.log("tablename: " + tableName);
                int count = DB.getOneInt("SELECT COUNT(handle) FROM `" + tableName + "` WHERE handle = '" + handle + "';");
                if (count <= 0) continue;
                tableNames.add(tableName);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("AC/Notification/Violation issue getting tables");
            Log.logException(e);
        }
        Log.log("returning in AC: " + tableNames);
        return tableNames;
    }

    public static ArrayList<NotificationViolation> getViolations(Integer violation_id, String handle, boolean legacy, String system, String client) {
        if (legacy) {
            Log.log("legacy querry");
            return NotificationViolation.legacyFromId(violation_id, system, client);
        }
        Log.log("AC/Notification/WORKFLOW: Violation id = null, retrieving violations instead");
        return NotificationViolation.retrieveViolations(handle, system, client);
    }

    private static ArrayList<NotificationViolation> legacyFromId(Integer violation_id, String system, String client) {
        ArrayList<NotificationViolation> violationArray = new ArrayList<NotificationViolation>();
        HashSet<Integer> uniqueViolationKeys = new HashSet<Integer>();
        try (ResultSet rs = DB.getData("SELECT * FROM `sod_legacy_" + system + "_" + client + "` WHERE id = " + violation_id);){
            Log.log("AC/NOTIFICATION/VIOLATION: legacyFromId querrying for Violation.");
            while (rs.next()) {
                int violationKey = rs.getInt("risk_id");
                if (!uniqueViolationKeys.add(violationKey)) continue;
                SapUser user = SapUser.getById(rs.getInt("user_id"));
                NotificationViolation newViolation = new NotificationViolation(rs.getString("preventive_check_handle"), rs.getInt("id"), violationKey, user, rs.getString("causes"));
                Log.log("AC/NOTIFICATION/VIOLATION:  legacyFromId adding Violation.");
                violationArray.add(newViolation);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Violation Legacy failed to get table");
            Log.logException(e);
        }
        return violationArray;
    }

    private static ArrayList<NotificationViolation> retrieveViolations(String handle, String system, String client) {
        ArrayList<NotificationViolation> violationArray = new ArrayList<NotificationViolation>();
        HashSet<Integer> uniqueViolationKeys = new HashSet<Integer>();
        ArrayList<String> violationtables = NotificationViolation.getNoneApprovedValuesFromTable(handle);
        for (String table : violationtables) {
            try {
                ResultSet rs = DB.getData("SELECT DISTINCT `rule_id`, `id`, `causes_json`, `handle`, `username`, `system`, `client` FROM " + table + " WHERE handle = '" + handle + "' AND `approved` = 0 AND `type` = 'new' ORDER BY created_timestamp DESC;");
                try {
                    while (rs.next()) {
                        int violationKey = rs.getInt("rule_id");
                        if (!uniqueViolationKeys.add(violationKey)) continue;
                        SapUser user = new SapUser(rs.getString("username"), rs.getString("system"), rs.getString("client"));
                        Log.log("user: " + user);
                        NotificationViolation newViolation = new NotificationViolation(rs.getString("handle"), rs.getInt("id"), violationKey, user, rs.getString("causes_json"));
                        Log.log("AC/NOTIFICATION/VIOLATION: retrieveViolation adding Violations.");
                        violationArray.add(newViolation);
                    }
                    rs.close();
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            catch (Exception e) {
                Log.log("workflow failed to get violation table");
                Log.logException(e);
            }
        }
        return violationArray;
    }
}

