/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import ac.Workflow;
import ac.notification.LegacyNotificationBatch;
import ac.notification.NotificationEmailTypes;
import ac.notification.NotificationSettings;
import ac.notification.NotificationWorkflowHelper;
import ac.report.tools.Settings;
import cn.Arguments;
import cn.Email;
import cn.Log;
import cn.SapUser;
import cn.Translator;
import cn.task.Task;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class NotificationTaskHandler {
    private static long timeSpentTotal = 0L;
    private static long timeSpentOnSending = 0L;
    private static long timeSpendPre = 0L;

    public static void main(String[] args) {
        long start = System.nanoTime();
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        Settings params = new Settings(task.params);
        String handle = params.getString("handle");
        timeSpendPre += System.nanoTime() - start;
        Log.log("timeSpent: " + timeSpentTotal);
        switch (task.type) {
            case 11: {
                NotificationTaskHandler.createEmail(handle);
                break;
            }
            case 23: {
                LegacyNotificationBatch.sendLegacyNotifications(task.system, task.client);
                break;
            }
        }
        Log.log("total type spend on notification: " + TimeUnit.NANOSECONDS.toMillis(timeSpentTotal += System.nanoTime() - start) + " ms.");
    }

    private static void createEmail(String handle) {
        Workflow workflow = Workflow.getWorkflowFromHandle(handle);
        NotificationSettings settings = NotificationTaskHandler.getSettings(workflow.getAdmin().system, workflow.getAdmin().client);
        Log.log("workflow: " + workflow);
        Translator translator = Translator.getInstance(settings.getWfLanguage());
        StringBuilder subject = new StringBuilder();
        String subjectType = "";
        StringBuilder body = new StringBuilder();
        switch (workflow.getStatus()) {
            case "approved": {
                subjectType = "Access request approved";
                body.append(NotificationEmailTypes.mailApproved(translator, workflow, handle));
                break;
            }
            case "rejected": {
                subjectType = "Access request rejected";
                body.append(NotificationEmailTypes.mailRejected(translator, workflow, handle));
                break;
            }
            case "pending": {
                subjectType = workflow.isLegacy() ? "Existing access approval" : "New access request";
                body.append(NotificationEmailTypes.mailPending(translator, workflow, handle));
                break;
            }
            case "cancelled": {
                subjectType = "Access request cancelled";
                body.append(NotificationEmailTypes.mailCancelled(translator, workflow, handle));
                break;
            }
            default: {
                Log.log("Workflow Status does match, program will fail");
            }
        }
        Log.log("NotificationTaskHandler status check completed: " + subject);
        subject.append(translator.getText(String.format("Access Control  %s/ %s", workflow.getAdmin().system, workflow.getAdmin().client)) + ": " + translator.getText(subjectType));
        String notificationEmail = settings.getSenderEmail();
        HashMap<String, ArrayList<String>> receivingEmailsAndCC = NotificationWorkflowHelper.getMailsAddresses(workflow, settings);
        if (notificationEmail == null || receivingEmailsAndCC.isEmpty()) {
            Log.log("Either no sender or no recipients for mail - no mails will be sent!\n");
        }
        Long startEmail = System.nanoTime();
        String ccString = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)receivingEmailsAndCC.get("cc"));
        String toString = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)receivingEmailsAndCC.get("to"));
        if (toString.isEmpty()) {
            Log.log("No receivers set, setting CC'ed to receive");
            toString = ccString;
            ccString = "";
        }
        Log.log("emails send to" + toString);
        Log.log("emails cc'ed to" + ccString);
        Email newEmail = new Email(notificationEmail, toString, ccString, "", subject.toString(), body.toString());
        newEmail.send();
        Log.log("timeSpent on sending & creating email: " + TimeUnit.NANOSECONDS.toMillis(timeSpentOnSending += System.nanoTime() - startEmail) + " ms.");
        Log.log("time spend on setting args: " + TimeUnit.NANOSECONDS.toMillis(timeSpendPre) + " ms.");
    }

    private static NotificationSettings getSettings(String system, String client) {
        return NotificationSettings.loadNotificationSettings(system, client);
    }

    public static void scheduleWorkflowNotification(String handle, SapUser admin) {
        try {
            NotificationWorkflowHelper.PS_saveSchedule.setString(1, handle);
            NotificationWorkflowHelper.PS_saveSchedule.setString(2, admin.username);
            NotificationWorkflowHelper.PS_saveSchedule.setString(3, admin.system);
            NotificationWorkflowHelper.PS_saveSchedule.setString(4, admin.client);
            NotificationWorkflowHelper.PS_saveSchedule.executeUpdate();
        }
        catch (SQLException e) {
            Log.log("Failed to save Schedule");
            Log.logException(e);
        }
    }
}

