/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import cn.DB;
import cn.Language;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

class NotificationSettings {
    private String wf_email;
    private String wf_language;
    private ArrayList<Boolean> wf_notice;
    private static final PreparedStatement PS_getACSettings = DB.prepareStatement("SELECT workflow_notifications, workflow_notifications_email, workflow_notifications_language, approver_minimum AS workflow_approver_minimum FROM settings_sod WHERE `system` = ? AND client = ? ORDER BY updated DESC LIMIT 1");
    public static final int mailRequestApprover = 0;
    public static final int mailRequestUser = 1;
    public static final int mailRequestAdmin = 2;
    public static final int mailApprovedApprover = 3;
    public static final int mailApprovedUser = 4;
    public static final int mailApprovedAdmin = 5;
    public static final int mailRejectedApprover = 6;
    public static final int mailRejectedUser = 7;
    public static final int mailRejectedAdmin = 8;

    private NotificationSettings(ArrayList<Boolean> wf_notice, String wf_email, String wf_language, Integer wf_approve_min, String system, String client) {
        this.wf_notice = wf_notice;
        this.wf_email = wf_email;
        this.wf_language = wf_language;
    }

    public boolean mailRequestApprover() {
        return this.checkRecipient(0);
    }

    public boolean mailRequestUser() {
        return this.checkRecipient(1);
    }

    public boolean mailRequestAdmin() {
        return this.checkRecipient(2);
    }

    public boolean mailApprovedApprover() {
        return this.checkRecipient(3);
    }

    public boolean mailApprovedUser() {
        return this.checkRecipient(4);
    }

    public boolean mailApprovedAdmin() {
        return this.checkRecipient(5);
    }

    public boolean mailRejectedApprover() {
        return this.checkRecipient(6);
    }

    public boolean mailRejectedUser() {
        return this.checkRecipient(7);
    }

    public boolean mailRejectedAdmin() {
        return this.checkRecipient(8);
    }

    private Boolean checkRecipient(Integer check) {
        boolean valueAtIndex = this.wf_notice.get(check);
        return valueAtIndex;
    }

    public String getSenderEmail() {
        return this.wf_email;
    }

    public String getWfLanguage() {
        return this.wf_language;
    }

    public static NotificationSettings loadNotificationSettings(String system, String client) {
        NotificationSettings notificationSettings;
        block11: {
            ArrayList<Boolean> notice = new ArrayList<Boolean>();
            for (int i = 0; i < 9; ++i) {
                notice.add(true);
            }
            NotificationSettings settings = new NotificationSettings(notice, "", String.valueOf(Language.getFallbackLanguage()), 1, system, client);
            String query = "SELECT workflow_notifications, workflow_notifications_email, workflow_notifications_language, approver_minimum AS workflow_approver_minimum FROM settings_sod WHERE `system` = '" + system + "' AND client = '" + client + "' ORDER BY updated DESC LIMIT 1;";
            ResultSet rs = DB.getData(query);
            try {
                PS_getACSettings.setString(1, system);
                PS_getACSettings.setString(2, client);
                if (rs.next()) {
                    ArrayList<Boolean> EmailRecipients = new ArrayList<Boolean>();
                    String notice_list = rs.getString("workflow_notifications");
                    for (int i = 0; i < notice_list.length(); ++i) {
                        EmailRecipients.add(notice_list.charAt(i) == '1');
                    }
                    settings = new NotificationSettings(EmailRecipients, rs.getString("workflow_notifications_email"), rs.getString("workflow_notifications_language"), rs.getInt("workflow_approver_minimum"), system, client);
                }
                rs.close();
                notificationSettings = settings;
                if (rs == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.log("AC/Notfification Settings Workflow settings not found");
                    Log.logException(e);
                    return settings;
                }
            }
            rs.close();
        }
        return notificationSettings;
    }
}

