/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import ac.Workflow;
import ac.notification.NotificationContent;
import cn.Log;
import cn.Translator;

class NotificationEmailTypes {
    private static final String breakString = "<br>";
    private static final String boldStart = "<b>";
    private static final String boldEnd = "</b>";

    NotificationEmailTypes() {
    }

    public static String mailApproved(Translator translator, Workflow workflow, String handle) {
        StringBuilder body = new StringBuilder();
        body.append(NotificationContent.approved(handle, translator));
        body.append(workflow.isLegacy() ? translator.getText("Roles are already assigned in SAP.") : translator.getText("Roles have been assigned in SAP."));
        body.append(NotificationContent.mailDetails(workflow, translator, handle));
        Log.log("approved content generated");
        return body.toString();
    }

    public static String mailRejected(Translator translator, Workflow workflow, String handle) {
        Log.log("NotificationTaskHandler mailRejected()");
        StringBuilder body = new StringBuilder();
        body.append(NotificationContent.rejected(handle, translator));
        body.append(workflow.isLegacy() ? translator.getText("Roles are already assigned in SAP.") : translator.getText("No roles will be assigned in SAP."));
        body.append(NotificationContent.mailDetails(workflow, translator, handle));
        return body.toString();
    }

    public static String mailPending(Translator translator, Workflow workflow, String handle) {
        Log.log("NotificationTaskHandler mailPending()");
        StringBuilder body = new StringBuilder();
        Log.log("workflow approval details " + workflow.getApprovalDetails());
        body.append(NotificationContent.pending(workflow.getApprovalDetails(), translator));
        body.append(translator.getText("Please proceed with the approval process through one of the following:") + "<br>&nbsp;<br>");
        body.append(boldStart + translator.getText("SAP GUI:") + "</b> ");
        body.append(translator.getText("Transaction /n/APPLISOL/ACRAPPROVE") + breakString);
        body.append(boldStart + translator.getText("FIORI Tile:") + "</b> ");
        body.append(translator.getText("Access Control - Approvals"));
        body.append(NotificationContent.mailDetails(workflow, translator, handle));
        return body.toString();
    }

    public static String mailCancelled(Translator translator, Workflow workflow, String handle) {
        Log.log("NotificationTaskHandler mailCancelled()");
        StringBuilder body = new StringBuilder();
        body.append(NotificationContent.cancelled(handle, translator));
        body.append(workflow.isLegacy() ? translator.getText("Roles are already assigned in SAP.") : translator.getText("No roles will be assigned in SAP."));
        body.append(NotificationContent.mailDetails(workflow, translator, handle));
        return body.toString();
    }
}

