/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import ac.Workflow;
import ac.notification.NotificationViolation;
import ac.notification.NotificationWorkflowHelper;
import ac.notification.Role_Tuple;
import ac.report.RiskOutputHelper;
import ac.risk.Approver;
import ac.risk.Risk;
import cn.DB;
import cn.EmailContent;
import cn.Log;
import cn.SapUser;
import cn.Translator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

class NotificationContent {
    private static final String breakString = "<br>";
    private static final String boldStart = "<b>";
    private static final String boldEnd = "</b>";
    private static final String trStart = "<tr>";
    private static final String trEnd = "</tr>";
    private static final String tableEnd = "</table>";
    private static final String italics = "font-style: italic;";
    private static final PreparedStatement PS_getApproved = DB.prepareStatement("SELECT sod_workflow_approval.user, comment, sod_approvers.approver, sod_workflow_approval.system, sod_workflow_approval.client FROM sod_workflow_approval LEFT JOIN sod_approvers ON sod_approvers.user = sod_workflow_approval.user AND sod_approvers.system = sod_workflow_approval.system AND sod_approvers.client = sod_workflow_approval.client WHERE handle=? ORDER BY timestamp DESC");
    private static final PreparedStatement PS_getCancelled = DB.prepareStatement("SELECT user, comment, `system`, client FROM sod_workflow_approval WHERE handle = ? AND action = 'cancelled' ORDER BY action DESC LIMIT 1");
    private static final PreparedStatement PS_getRejected = DB.prepareStatement("SELECT sod_workflow_approval.user, comment, sod_approvers.approver, sod_workflow_approval.system, sod_workflow_approval.client FROM sod_workflow_approval LEFT JOIN sod_approvers ON sod_approvers.user = sod_workflow_approval.user AND sod_approvers.system = sod_workflow_approval.system AND sod_approvers.client = sod_workflow_approval.client WHERE handle = ? AND action = 'rejected' ORDER BY action DESC LIMIT 1");

    NotificationContent() {
    }

    public static String mailDetails(Workflow workflow, Translator translator, String handle) {
        Log.log("AC/NOTIFICATION/CONCENT mailDetails, setting NotificationWorkflowHelper ");
        NotificationWorkflowHelper helper = new NotificationWorkflowHelper(workflow.getViolationId(), workflow.isLegacy(), workflow.getAdmin().system, workflow.getAdmin().client, handle);
        return NotificationContent.details(helper, translator, handle, workflow.getAdmin());
    }

    private static String details(NotificationWorkflowHelper workflowHelper, Translator translator, String handle, SapUser admin) {
        Log.log("AC/NOTIFICATION/CONCENT generate mail details");
        StringBuilder text = new StringBuilder();
        text.append(breakString);
        text.append(breakString);
        text.append(translator.getText("Requested by") + ": " + admin.getToFullString() + "<br><br>");
        text.append(boldStart + translator.getText("Users affected by request") + ":</b>");
        text.append(NotificationContent.affectedUsers(workflowHelper.getAffectedUsers(), translator) + breakString);
        text.append(boldStart + translator.getText("Risks related to approval") + ":</b>");
        String[] header = new String[]{"Risk", "Name", "Description", "Approver", "Reaction"};
        text.append(EmailContent.makeTableHeader(header, translator));
        ArrayList<NotificationViolation> violations = workflowHelper.setViolations();
        for (NotificationViolation v : violations) {
            Risk risk = Risk.getById(v.getRuleId());
            text.append(trStart);
            text.append(EmailContent.makeTableCell(risk.signature, ""));
            text.append(EmailContent.makeTableCell(risk.name, ""));
            text.append(EmailContent.makeTableCell(risk.description, ""));
            ArrayList<String> approvers = new ArrayList<String>();
            if (risk.multi_approver != null) {
                for (int approver : risk.multi_approver) {
                    Approver pp2 = Approver.getById(approver);
                    approvers.add(pp2.stringFormatNotificatioon());
                }
            }
            text.append(EmailContent.makeTableCell(String.join((CharSequence)", ", approvers), ""));
            text.append(EmailContent.makeTableCell(translator.getText(RiskOutputHelper.warningLookUp(risk.warning)), ""));
            text.append(trEnd);
        }
        text.append(tableEnd);
        HashMap<String, ArrayList<Role_Tuple>> roles = workflowHelper.getAffectedRoles();
        if (!workflowHelper.isLegacy()) {
            Log.log("workflow is not legacy");
            text.append("<br><b>" + translator.getText("New role assignments involved in risks") + ":</b>");
            text.append(translator.getText(NotificationContent.affectedRoles(roles.get("unAssigned"), translator)));
        } else {
            Log.log("workflow legacy");
            String assignedRoles = NotificationContent.affectedRoles(roles.get("assigned"), translator);
            String unAssignedRoles = NotificationContent.affectedRoles(roles.get("unAssigned"), translator);
            if (!unAssignedRoles.isEmpty()) {
                text.append("<br><b>" + translator.getText("New role assignments involved in risks") + ":</b>");
                text.append(translator.getText(unAssignedRoles));
            }
        }
        text.append("<br><span style=\"font-size: 9px;\">" + translator.getText("ID") + "<span style=\"color: #63bda1;\">'" + handle + "'</span></span><br />");
        text.append(breakString);
        Log.log("details made");
        return text.toString();
    }

    private static String affectedRoles(ArrayList<Role_Tuple> tuples, Translator translator) {
        String[] header = new String[]{"Role", "Composite of", "System", "Client"};
        StringBuilder body = new StringBuilder();
        if (!tuples.isEmpty()) {
            body.append(EmailContent.makeTableHeader(header, translator));
            for (Role_Tuple tuple : tuples) {
                body.append(trStart);
                body.append(EmailContent.makeTableCell(tuple.getRole().name, ""));
                body.append(EmailContent.makeTableCell(tuple.getCompositeName(), ""));
                body.append(EmailContent.makeTableCell(tuple.getRole().system, ""));
                body.append(EmailContent.makeTableCell(tuple.getRole().client, ""));
                body.append(trEnd);
            }
            body.append(tableEnd);
        }
        return body.toString();
    }

    private static String affectedUsers(ArrayList<SapUser> users, Translator translator) {
        String[] headers = new String[]{"Username", "First name", "Last name", "System", "Client"};
        StringBuilder text = new StringBuilder();
        text.append(EmailContent.makeTableHeader(headers, translator));
        for (SapUser user : users) {
            text.append(trStart);
            text.append(EmailContent.makeTableCell(user.username, ""));
            text.append(EmailContent.makeTableCell(user.getFirstName() != null ? user.getFirstName() : "NotAssigned", ""));
            text.append(EmailContent.makeTableCell(user.getLastName() != null ? user.getLastName() : "NotAssigned", ""));
            text.append(EmailContent.makeTableCell(user.system, ""));
            text.append(EmailContent.makeTableCell(user.client, ""));
            text.append(trEnd);
        }
        text.append(tableEnd);
        return text.toString();
    }

    public static String pending(JSONArray approverJSON, Translator translator) {
        HashMap<String, JSONObject> approverHash = NotificationWorkflowHelper.approverExtractor(approverJSON);
        StringBuilder body = new StringBuilder();
        String[] header = new String[]{"Approver", "Username", "Substitute", "System", "Client"};
        body.append(boldStart + translator.getText("Approvers/substitutes:") + boldEnd);
        body.append(EmailContent.makeTableHeader(header, translator));
        try {
            for (String key : approverHash.keySet()) {
                body.append(trStart);
                body.append(EmailContent.makeTableCell(key, ""));
                body.append(EmailContent.makeTableCell(approverHash.get(key).getString("username"), ""));
                String substitute = approverHash.get(key).optString("substitute", "");
                body.append(EmailContent.makeTableCell(substitute == null ? "" : substitute, ""));
                body.append(EmailContent.makeTableCell(approverHash.get(key).getString("system"), ""));
                body.append(EmailContent.makeTableCell(approverHash.get(key).getString("client"), ""));
                body.append(trEnd);
            }
        }
        catch (Exception e) {
            Log.log("NotificationContent.pending FAILED while adding data.");
            Log.log("approverJSON: " + approverJSON.toString());
            Log.logException(e);
        }
        body.append(tableEnd);
        return body.toString();
    }

    public static String rejected(String handle, Translator translator) {
        StringBuilder body = new StringBuilder();
        String[] header = new String[]{"Approver", "Username", "System", "Client", "Comments"};
        body.append("<br><b>" + translator.getText("Access request has been rejected by:") + boldEnd);
        body.append(EmailContent.makeTableHeader(header, translator));
        try {
            PS_getRejected.setString(1, handle);
            ResultSet rs = PS_getRejected.executeQuery();
            while (rs.next()) {
                body.append(trStart);
                String approver = rs.getString("approver");
                body.append(EmailContent.makeTableCell(approver == null ? "" : approver, ""));
                body.append(EmailContent.makeTableCell(rs.getString("user"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("system"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("client"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("comment"), italics).replaceAll(breakString, "\\n"));
                body.append(trEnd);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("NotificationContent Rejected Querry problem in rejected");
            Log.logException(e);
        }
        body.append(tableEnd);
        return body.toString();
    }

    public static String approved(String handle, Translator translator) {
        String[] header = new String[]{"Approver", "Username", "System", "Client", "Comments"};
        StringBuilder body = new StringBuilder();
        body.append("<br><b>" + translator.getText("Access request has been approved by:") + boldEnd);
        body.append(EmailContent.makeTableHeader(header, translator));
        try {
            PS_getApproved.setString(1, handle);
            ResultSet rs = PS_getApproved.executeQuery();
            while (rs.next()) {
                body.append(trStart);
                String approver = rs.getString("approver");
                body.append(EmailContent.makeTableCell(approver != null ? approver : "", ""));
                body.append(EmailContent.makeTableCell(rs.getString("user"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("system"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("client"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("comment"), italics));
                body.append(trEnd);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("AC/NOTIFICATION/CONTENT/ Querry problem in approved");
            Log.logException(e);
        }
        body.append(tableEnd);
        return body.toString();
    }

    public static String cancelled(String handle, Translator translator) {
        String[] header = new String[]{"Username", "System", "Client", "Comments"};
        StringBuilder body = new StringBuilder();
        body.append("<br><b>" + translator.getText("Access request has been cancelled by user administrator:") + boldEnd);
        body.append(EmailContent.makeTableHeader(header, translator));
        try {
            PS_getCancelled.setString(1, handle);
            ResultSet rs = PS_getCancelled.executeQuery();
            while (rs.next()) {
                body.append(trStart);
                body.append(EmailContent.makeTableCell(rs.getString("user"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("system"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("client"), ""));
                body.append(EmailContent.makeTableCell(rs.getString("comment"), italics));
                body.append(trEnd);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("AC/NOTIFICATION/CONTENT/ Querry problem in cancelled");
            Log.logException(e);
        }
        body.append(tableEnd);
        return body.toString();
    }
}

