/*
 * Decompiled with CFR 0.152.
 */
package ac.notification;

import ac.Workflow;
import ac.notification.NotificationContent;
import ac.notification.NotificationSettings;
import cn.DB;
import cn.Email;
import cn.EmailContent;
import cn.Log;
import cn.Translator;
import cn.Utils;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class LegacyNotificationBatch {
    private static final String breakString = "<br>";
    private static final String boldStart = "<b>";
    private static final String boldEnd = "</b>";
    private static final PreparedStatement PS_selectNotificationQuery = DB.prepareStatement("SELECT `handle`, `admin` FROM sod_legacy_notification_que WHERE `system` = ? AND `client` = ? ORDER BY `admin`;");

    LegacyNotificationBatch() {
    }

    public static boolean sendLegacyNotifications(String system, String client) {
        Email newEmail;
        String body;
        ArrayList workflows;
        String subject;
        Log.log("Sending legacybatch Emails");
        NotificationSettings settings = NotificationSettings.loadNotificationSettings(system, client);
        if (settings.getSenderEmail().isEmpty()) {
            Log.log("AC legacyAnalysis sendLegacyNotifications: No sender email for mails - no mails will be sent!\n");
            LegacyNotificationBatch.deleteNotificationQue(system, client);
            return false;
        }
        HashMap approverWorkflows = new HashMap();
        HashMap adminWorkflows = new HashMap();
        HashMap userWorkflows = new HashMap();
        try {
            PS_selectNotificationQuery.setString(1, system);
            PS_selectNotificationQuery.setString(2, client);
            ResultSet rs = PS_selectNotificationQuery.executeQuery();
            Log.log("Found " + rs.getMetaData().getColumnCount() + " workflows in the legacy notification que (" + system + "/" + client + ").");
            while (rs.next()) {
                ArrayList<Workflow> newList;
                Log.log("Approver workflows being extracted");
                Workflow workflow = Workflow.getWorkflowFromHandle(rs.getString("handle"));
                if (settings.mailRequestApprover()) {
                    if (!Utils.isEmpty(workflow.getMailAddrApprovers())) {
                        String[] approverEmails;
                        for (String mail : approverEmails = Email.isValidEmails(workflow.getMailAddrApprovers())) {
                            if (approverWorkflows.containsKey(mail)) {
                                approverWorkflows.compute(mail, (key, existingList) -> {
                                    existingList.add(workflow);
                                    return existingList;
                                });
                                continue;
                            }
                            newList = new ArrayList<Workflow>();
                            newList.add(workflow);
                            approverWorkflows.put(mail, newList);
                        }
                    } else {
                        Log.log("APPROVER EMAILS NOT AN ARRAY!");
                    }
                }
                if (settings.mailRequestAdmin()) {
                    Log.log("Admin workflows being extracted");
                    if (!Utils.isEmpty(workflow.getAddrAdmins())) {
                        String[] adminEmails;
                        for (String mail : adminEmails = Email.isValidEmails(workflow.getAddrAdmins())) {
                            if (adminWorkflows.containsKey(mail)) {
                                adminWorkflows.compute(mail, (key, existingList) -> {
                                    existingList.add(workflow);
                                    return existingList;
                                });
                                continue;
                            }
                            newList = new ArrayList();
                            newList.add(workflow);
                            adminWorkflows.put(mail, newList);
                        }
                    } else {
                        Log.log("ADMIN EMAILS NOT AN ARRAY!");
                    }
                }
                if (!settings.mailRequestUser()) continue;
                Log.log("User workflows being extracted");
                if (!Utils.isEmpty(workflow.getMailAddrUsers())) {
                    String[] userEmails;
                    for (String mail : userEmails = Email.isValidEmails(workflow.getMailAddrUsers())) {
                        if (userWorkflows.containsKey(mail)) {
                            userWorkflows.compute(mail, (key, existingList) -> {
                                existingList.add(workflow);
                                return existingList;
                            });
                            continue;
                        }
                        newList = new ArrayList();
                        newList.add(workflow);
                        userWorkflows.put(mail, newList);
                    }
                    continue;
                }
                Log.log("USER EMAILS NOT AN ARRAY!");
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Query for unused approvals failed");
            Log.logException(e);
        }
        Log.log("Legacy workflows all set and ready to be made into email conent");
        int app = approverWorkflows.size();
        int adm = adminWorkflows.size();
        int usr = userWorkflows.size();
        Log.log(app + " approvers, " + adm + " admins, and " + usr + " users should receive mails.");
        Translator translator = Translator.getInstance(settings.getWfLanguage());
        if (app > 0) {
            for (Map.Entry entry : approverWorkflows.entrySet()) {
                subject = translator.getText(String.format("Access Control  %s/ %s", system, client)) + ": " + translator.getText("Existing access approval");
                String approver = (String)entry.getKey();
                workflows = (ArrayList)entry.getValue();
                body = LegacyNotificationBatch.legacyPendingEmail(workflows, translator, true);
                newEmail = new Email(settings.getSenderEmail(), approver, "", "", subject, body);
                newEmail.send();
            }
        }
        if (adm > 0) {
            for (Map.Entry entry : adminWorkflows.entrySet()) {
                subject = translator.getText(String.format("Access Control  %s/ %s", system, client)) + ": " + translator.getText("Existing access approval");
                String admin = (String)entry.getKey();
                workflows = (ArrayList)entry.getValue();
                body = LegacyNotificationBatch.legacyPendingEmail(workflows, translator, false);
                newEmail = new Email(settings.getSenderEmail(), admin, "", "", subject, body);
                newEmail.send();
            }
        }
        if (usr > 0) {
            for (Map.Entry entry : userWorkflows.entrySet()) {
                subject = translator.getText(String.format("Access Control  %s/ %s", system, client)) + ": " + translator.getText("Existing access approval");
                String user = (String)entry.getKey();
                workflows = (ArrayList)entry.getValue();
                body = LegacyNotificationBatch.legacyPendingEmail(workflows, translator, false);
                newEmail = new Email(settings.getSenderEmail(), user, "", "", subject, body);
                newEmail.send();
            }
        }
        LegacyNotificationBatch.deleteNotificationQue(system, client);
        return true;
    }

    private static String legacyPendingEmail(ArrayList<Workflow> workflows, Translator translator, Boolean approver) {
        Log.log("Generating mails for Legacy Notification.");
        StringBuilder body = new StringBuilder();
        for (Workflow workflow : workflows) {
            body.append(LegacyNotificationBatch.mailPending(translator, workflow, workflow.getHandle(), approver));
            body.append(EmailContent.outLookLine());
        }
        return body.toString();
    }

    private static String mailPending(Translator translator, Workflow workflow, String handle, boolean approver) {
        Log.log("NotificationTaskHandler mailPending()");
        StringBuilder body = new StringBuilder();
        body.append(NotificationContent.pending(workflow.getApprovalDetails(), translator));
        if (approver) {
            body.append(translator.getText("Please proceed with the approval process through one of the following:") + "<br>&nbsp;<br>");
            body.append(boldStart + translator.getText("SAP GUI:") + "</b> ");
            body.append(translator.getText(" Transaction: /n/APPLISOL/ACRAPPROVE") + breakString);
            body.append(boldStart + translator.getText("FIORI Tile:") + "</b> ");
            body.append(translator.getText("Access Control - Approvals"));
        }
        body.append(NotificationContent.mailDetails(workflow, translator, handle));
        return body.toString();
    }

    private static void deleteNotificationQue(String system, String client) {
        Log.log("Clearing legacy notification que for " + system + " / " + client);
        ArrayList<CallSite> handles = new ArrayList<CallSite>();
        try {
            PS_selectNotificationQuery.setString(1, system);
            PS_selectNotificationQuery.setString(2, client);
            ResultSet rs = PS_selectNotificationQuery.executeQuery();
            Log.log("Found " + rs.getMetaData().getColumnCount() + " in legacy notification que for " + system + " / " + client);
            while (rs.next()) {
                handles.add((CallSite)((Object)("'" + rs.getString("handle") + "'")));
            }
        }
        catch (Exception e) {
            Log.logException(e);
        }
        if (handles.size() > 0) {
            try {
                DB.update("DELETE FROM sod_legacy_notification_que WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND `handle` IN (" + String.join((CharSequence)",", handles) + ")");
            }
            catch (Exception e) {
                Log.logException(e);
            }
            Log.log("Cleared legacy notification que for " + system + " / " + client);
        }
        Log.log("No legacy notification que to clear for " + system + " / " + client);
    }
}

