/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.useranalysis;

import ac.analysis.AnalysisUser;
import ac.analysis.ViolationListener;
import ac.dashboard.DashboardSettings;
import ac.dashboard.DashboardUserSettings;
import ac.dashboard.TranslateReport;
import ac.dashboard.useranalysis.UserAnalysisHandler;
import ac.report.standard.Report;
import ac.risk.Violation;
import cn.Config;
import cn.Language;
import cn.Log;
import cn.task.Task;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

class UserReportListener
implements ViolationListener {
    private final Task task;
    private final Report report;
    private final DashboardUserSettings settings;

    UserReportListener(Task task) {
        this.task = task;
        this.settings = new DashboardUserSettings(task.system, task.client);
        UserReportListener.deleteOldReports(task.system, task.client);
        if (this.makeReport()) {
            this.report = Report.createReport(task, this.settings.reportParams);
            this.report.start(UserAnalysisHandler.getBaseFilename(task.system, task.client) + "en");
        } else {
            this.report = null;
        }
    }

    @Override
    public boolean violationFound(AnalysisUser user, Violation[] violations) {
        return this.report.violationFound(user, violations);
    }

    @Override
    public void close() {
        Log.log("UserReportListener closing report.");
        this.report.close();
        Log.log("UserReportListener starting translations.");
        UserReportListener.translateReports(this.task, this.settings);
    }

    boolean makeReport() {
        return this.settings.makeReport();
    }

    private static void translateReports(Task task, DashboardSettings settings) {
        String baseFilename = UserAnalysisHandler.getBaseFilename(task.system, task.client);
        TranslateReport.translateReport(task, baseFilename, settings);
    }

    private static void deleteOldReports(String system, String client) {
        Log.log("Deleting old dashboard user reports.");
        for (Language language : Language.getAvailableLanguages()) {
            Path filepath = UserReportListener.getDashboardReportFilename(language.isoString, system, client);
            try {
                if (Files.deleteIfExists(filepath)) {
                    Log.log("Deleted " + filepath.toString());
                    continue;
                }
                Log.log("No file " + filepath.toString());
            }
            catch (IOException e) {
                Log.log("ac.dashboard.userreport.DashboardUserReportListener failed to delete " + filepath.getFileName() + ". Maybe file does not exist.");
                Log.logException(e);
            }
        }
    }

    private static Path getDashboardReportFilename(String languageISO, String system, String client) {
        return Paths.get(Config.getReportPath() + UserAnalysisHandler.getBaseFilename(system, client) + languageISO + ".xlsx", new String[0]);
    }
}

