/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.useranalysis;

import ac.analysis.AnalyzeEngine;
import ac.analysis.UserIterator;
import ac.dashboard.useranalysis.LegacyComparisonListener;
import ac.dashboard.useranalysis.UserReportListener;
import ac.report.tools.Settings;
import ac.risk.Risk;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Memory;
import cn.task.Task;

class UserAnalysisHandler {
    UserAnalysisHandler() {
    }

    public static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " ac/dashboard/useranalysis/UserAnalysisHandler ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        Settings params = new Settings(task.params);
        Risk[] risks = Risk.getActiveReportRisks(params);
        UserIterator userIterator = new UserIterator(params);
        Log.log(Memory.statement("Creating engine and listeners."));
        AnalyzeEngine engine = new AnalyzeEngine(risks, userIterator);
        Log.log(Memory.statement("Creating legacy comparison listener."));
        LegacyComparisonListener legacy = new LegacyComparisonListener(params, userIterator);
        engine.addListener(legacy);
        UserReportListener reportListener = new UserReportListener(task);
        if (reportListener.makeReport()) {
            Log.log("Adding report listener.");
            engine.addListener(reportListener);
        } else {
            Log.log("NOT adding report listener due to Nightly Job settings where report is turned off.");
        }
        Thread.currentThread().setPriority(1);
        Log.log(Memory.statement("AnalyzeEngine set Thread priority to MIN_PRIORITY."));
        Log.log(Memory.statement("Starting analysis."));
        try {
            engine.analyze();
        }
        catch (Exception e) {
            Log.log("ANALYSIS FAILED!");
            Log.log("Something went wrong while analyzing users shutting down listeners.");
            engine.close();
        }
        Log.log(Memory.statement("Finished analysis."));
        DB.close();
        Log.close();
        if (engine.isPartial()) {
            System.exit(2);
        }
        System.exit(0);
    }

    static String getBaseFilename(String system, String client) {
        StringBuilder sb = new StringBuilder();
        sb.append("AC_UserCompliance");
        sb.append('_');
        sb.append(system);
        sb.append('_');
        sb.append(client);
        sb.append('_');
        return sb.toString();
    }
}

