/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.useranalysis;

import ac.dashboard.DashboardUserSettings;
import ac.dashboard.useranalysis.UserAnalysisHandler;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Language;
import cn.Log;
import cn.task.Task;
import cn.task.TaskHandler;

public class UserAnalysis {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        DashboardUserSettings settings = new DashboardUserSettings(task.system, task.client);
        int exitCode = 0;
        int exitCodeXlsx = 0;
        if (settings.doAnalysis()) {
            String params = "inifile=" + Config.getIniPath() + " user=" + Config.getRemoteUser() + " system=" + task.system + " client=" + task.client + " taskid=" + task_id + " ";
            String logfile = "logfile=" + Log.getFilename();
            exitCode = 3;
            while (exitCode == 3) {
                exitCode = TaskHandler.executeJVM(UserAnalysisHandler.getExecutionString() + params + logfile + "_content.log", task);
                Log.log("Analysis had exit code " + exitCode);
            }
            if (settings.makeReport()) {
                Log.log("User report turned on in settings, so start making xlsx files from translated csv's.");
                for (Language language : Language.getAvailableLanguages()) {
                    if (!settings.isLanguageActive(language.isoString)) continue;
                    Log.log("Starting Excel conversion for " + language.title);
                    exitCodeXlsx = TaskHandler.executeJVM(TaskHandler.getConverterExecutionString() + logfile + "_content.log " + Config.getReportPath() + UserAnalysisHandler.getBaseFilename(task.system, task.client) + language.isoString + "_selections.csv Selections " + Config.getReportPath() + UserAnalysisHandler.getBaseFilename(task.system, task.client) + language.isoString + ".csv Data ", task);
                    Log.log("csvToExcel " + language.title + " had exit code " + exitCodeXlsx);
                }
            } else {
                Log.log("User report turned off in settings.");
            }
        } else {
            Log.log("User analysis has been turned off in settings.");
        }
        DB.close();
        Log.close();
        if (exitCode == 1 || exitCodeXlsx == 1) {
            System.exit(1);
        }
        if (exitCode == 2 || exitCodeXlsx == 2) {
            System.exit(2);
        }
        System.exit(0);
    }
}

