/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.useranalysis;

import ac.dashboard.useranalysis.LegacyComparisonListener;
import ac.dashboard.useranalysis.LegacyData;
import cn.DB;
import cn.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class LegacyUpdater
implements Runnable {
    private static final String S_SLEEP_MESSAGE = "LegacyUpdater sleeping thread while waiting for violations.";
    private static final String S_QUE_HANDLING = "LegacyUpdater handling LegacyData array with %s entries.";
    private static final String S_QUE_HANDLED = "LegacyUpdater handled LegacyData arrays with %s combined entries.";
    private static final BlockingQueue<LegacyData[]> dataQueue = new LinkedBlockingQueue<LegacyData[]>();
    private static final Collection<LegacyData[]> data = new ArrayList<LegacyData[]>();
    private static final String S_COMMITTED = "LegacyUpdater committed saved: %s / %s, updated: %s / %s, deleted: %s / %s.";
    private static final String S_COMMIT_FAILED = "LegacyUpdater FAILED to commit save: %s, update: %s, delete: %s.";
    private static LegacyUpdater currentInstance;
    private static int saveCount;
    private static int updateCount;
    private static int deleteCount;
    private static long waitingForMySQL;
    private Thread runner = new Thread(this);
    private volatile boolean running = false;
    private static final Connection conn;
    private static final PreparedStatement PS_saveViolation;
    private static final PreparedStatement PS_updateViolation;
    private static final PreparedStatement PS_deleteViolations;

    static void initialize() {
        currentInstance = new LegacyUpdater();
    }

    static void sendToDatabase(ArrayList<LegacyData> data) {
        if (data.size() > 0) {
            try {
                dataQueue.put(data.toArray(LegacyData.EMPTYARRAY));
            }
            catch (Exception e) {
                Log.log("LegacyUpdater FAILED to send data to database thread.");
                Log.logException(e);
            }
        }
    }

    static void close() {
        Log.log("LegacyUpdater sending close message to database thread.");
        try {
            dataQueue.put(LegacyData.EMPTYARRAY);
        }
        catch (Exception e) {
            Log.log("LegacyUpdater FAILED to send stop message to database thread.");
            Log.logException(e);
        }
        while (currentInstance.isRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                Log.log("LegacyUpdater Thread.sleep FAILED while waiting for database thread to close.");
                Log.logException(e);
            }
        }
        Log.log("LegacyUpdater has closed database thread.");
        Log.log("LegacyUpdater " + saveCount + " saved, " + updateCount + " updated, " + deleteCount + " deleted.");
        Log.log("LegacyUpdater spent " + TimeUnit.NANOSECONDS.toMillis(waitingForMySQL) + "ms waiting for database.");
    }

    LegacyUpdater() {
        this.runner.setPriority(1);
        this.runner.start();
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        LegacyData[] dataPeek = null;
        try {
            dataPeek = dataQueue.take();
            this.running = dataPeek.length > 0;
        }
        catch (Exception e) {
            this.running = false;
            Log.log("LegacyUpdater FAILED to recieve first data.");
            Log.logException(e);
        }
        if (this.running) {
            Log.log("LegacyUpdater is running.");
            this.handle(dataPeek);
        }
        while (this.running) {
            dataPeek = (LegacyData[])dataQueue.peek();
            if (dataPeek == null) {
                try {
                    Log.debug(S_SLEEP_MESSAGE);
                    Thread.sleep(333L);
                }
                catch (Exception e) {
                    Log.log("LegacyUpdater FAILED while sleeping thread.");
                    Log.logException(e);
                }
                continue;
            }
            dataQueue.drainTo(data);
            int count = 0;
            for (LegacyData[] ld : data) {
                if (ld.length > 0) {
                    Log.debug(String.format(S_QUE_HANDLING, ld.length));
                    this.handle(ld);
                    count += ld.length;
                    continue;
                }
                this.running = false;
                Log.log("LegacyUpdater set running to FALSE.");
            }
            Log.log(String.format(S_QUE_HANDLED, count));
            data.clear();
        }
        try {
            this.runner.join();
        }
        catch (Exception e) {
            Log.log("LegacyUpdater FAILED while trying to join thread.");
            Log.logException(e);
        }
    }

    private void handle(LegacyData[] recievedData) {
        int s = 0;
        int u = 0;
        int d = 0;
        block7: for (LegacyData data : recievedData) {
            switch (data.operation) {
                case 1: {
                    this.save(data);
                    ++s;
                    continue block7;
                }
                case 2: {
                    this.update(data);
                    ++u;
                    continue block7;
                }
                case 3: {
                    this.delete(data);
                    ++d;
                    continue block7;
                }
            }
        }
        if (this.commitBatches()) {
            Log.debug(String.format(S_COMMITTED, s, saveCount += s, u, updateCount += u, d, deleteCount += d));
        } else {
            Log.log(String.format(S_COMMIT_FAILED, s, u, d));
        }
        try {
            PS_saveViolation.clearBatch();
            PS_updateViolation.clearBatch();
            PS_deleteViolations.clearBatch();
        }
        catch (Exception e) {
            Log.log("LegacyUpdater handle() FAILED to clearBatch().");
            Log.logException(e);
        }
    }

    private boolean commitBatches() {
        boolean success = true;
        long start = System.nanoTime();
        try {
            PS_saveViolation.executeBatch();
            PS_updateViolation.executeBatch();
            PS_deleteViolations.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            Log.log("LegacyUpdater commitBatches() did not obtain lock.");
            success = false;
        }
        waitingForMySQL += System.nanoTime() - start;
        return success;
    }

    private void save(LegacyData ld) {
        try {
            PS_saveViolation.setInt(1, ld.user_id);
            PS_saveViolation.setInt(2, ld.risk_id);
            PS_saveViolation.setBoolean(3, ld.approved);
            PS_saveViolation.setString(4, ld.pc_handle);
            PS_saveViolation.setString(5, ld.causes);
            PS_saveViolation.addBatch();
        }
        catch (Exception e) {
            Log.log("LegacyUpdater.save FAILED!");
            Log.logException(e);
        }
    }

    private void update(LegacyData ld) {
        try {
            PS_updateViolation.setBoolean(1, ld.approved);
            PS_updateViolation.setString(2, ld.causes);
            PS_updateViolation.setInt(3, ld.legacy_id);
            PS_updateViolation.addBatch();
        }
        catch (Exception e) {
            Log.log("LegacyUpdater.update FAILED!");
            Log.logException(e);
        }
    }

    private void delete(LegacyData ld) {
        try {
            PS_deleteViolations.setInt(1, ld.legacy_id);
            PS_deleteViolations.addBatch();
        }
        catch (Exception e) {
            Log.log("LegacyUpdater.delete FAILED!");
            Log.logException(e);
        }
    }

    static {
        saveCount = 0;
        updateCount = 0;
        deleteCount = 0;
        waitingForMySQL = 0L;
        conn = DB.getNewConnection();
        PS_saveViolation = DB.prepareStatementOnConnection(conn, "INSERT INTO `" + LegacyComparisonListener.getLegacyTable() + "` (user_id, risk_id, approved, preventive_check_handle, causes) VALUES (?, ?, ?, ?, ?);");
        PS_updateViolation = DB.prepareStatementOnConnection(conn, "UPDATE `" + LegacyComparisonListener.getLegacyTable() + "` SET approved = ?, causes = ? WHERE `id`= ?;");
        PS_deleteViolations = DB.prepareStatementOnConnection(conn, "DELETE FROM `" + LegacyComparisonListener.getLegacyTable() + "` WHERE `id` = ?;");
    }
}

