/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.useranalysis;

import ac.analysis.AnalysisUser;
import ac.analysis.UserIterator;
import ac.analysis.ViolationListener;
import ac.dashboard.useranalysis.LegacyData;
import ac.dashboard.useranalysis.LegacyUpdater;
import ac.report.tools.Settings;
import ac.risk.Risk;
import ac.risk.Violation;
import cn.DB;
import cn.Log;
import cn.Memory;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;

class LegacyComparisonListener
implements ViolationListener {
    private static final int MAX_CAUSE_SIZE = 0xFFFFF8;
    private static final HashMap<Integer, Integer> loadedViolations = new HashMap();
    private static final HashMap<Violation, String> CURRENT_JSON_MAP = new HashMap();
    private static String CURRENT_HASH = "";
    private static boolean checkPreventiveCheckHandle;
    private static String system;
    private static String client;
    private static long timeSpent;
    private static long timeSpentMakingCauses;
    private static long timeSpendGettingHandles;
    private static long timeSpendOnLoadingViolations;
    private static final ArrayList<Integer> ids_in_violations;
    private static final ArrayList<LegacyData> list;
    private static final ArrayList<Violation> toSave;
    private static final ArrayList<Violation> toUpdate;
    private static final ArrayList<Integer> idsForHandles;
    private static PreparedStatement PS_EXISTING;

    LegacyComparisonListener(Settings params, UserIterator userIterator) {
        system = params.system;
        client = params.client;
        checkPreventiveCheckHandle = DB.isTable(LegacyComparisonListener.getPreventiveTable());
        if (!DB.isTable(LegacyComparisonListener.getLegacyTable())) {
            DB.update("CREATE TABLE `" + LegacyComparisonListener.getLegacyTable() + "` ( \t`id` int NOT NULL AUTO_INCREMENT, \t`user_id` int NOT NULL, \t`risk_id` int NOT NULL,\t`approved` tinyint NOT NULL,\t`preventive_check_handle` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,\t`causes` MEDIUMTEXT COLLATE utf8mb4_unicode_ci NULL,\t`created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,\t`updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   PRIMARY KEY (`id`) ) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        }
        LegacyUpdater.initialize();
        LegacyComparisonListener.removeLegacyForNonAnalyzedUsers(userIterator);
        if (PS_EXISTING == null) {
            PS_EXISTING = DB.prepareStatement("SELECT `id`, `risk_id` FROM `" + LegacyComparisonListener.getLegacyTable() + "` WHERE user_id = ? ;");
        }
    }

    private static void removeLegacyForNonAnalyzedUsers(UserIterator userIterator) {
        Log.log(Memory.statement("Removing all legacy violations for users not included in analysis."));
        ResultSet rs = DB.getData("SELECT id FROM `" + LegacyComparisonListener.getLegacyTable() + "` WHERE user_id NOT IN (" + Utils.toQuotedString(userIterator.getAllUserIds()) + ");");
        int i = 0;
        try {
            while (rs.next()) {
                list.add(new LegacyData(rs.getInt(1)));
                ++i;
            }
        }
        catch (Exception e) {
            Log.log("LegacyComparisonListener removeLegacyForNonAnalyzedUsers FAILED while reading legacy risks to be removed.");
            Log.logException(e);
        }
        LegacyUpdater.sendToDatabase(list);
        list.clear();
        Log.log(Memory.statement("Removed " + i + " legacy violations for users not included in analysis."));
    }

    @Override
    public boolean violationFound(AnalysisUser user, Violation[] violations) {
        boolean doContinue = true;
        long start = System.nanoTime();
        LegacyComparisonListener.loadAllExistingViolations(user.getId());
        if (violations.length == 0) {
            if (loadedViolations.size() > 0) {
                Log.log("LegacyComparisonListener found " + violations.length + " in " + user.toString() + ", " + loadedViolations.size() + " violations to delete");
                ArrayList<LegacyData> list = new ArrayList<LegacyData>();
                for (int risk_id : loadedViolations.keySet()) {
                    list.add(new LegacyData(loadedViolations.get(risk_id)));
                }
                LegacyUpdater.sendToDatabase(list);
            }
        } else {
            if (!CURRENT_HASH.contentEquals(user.hash)) {
                long causeStart = System.nanoTime();
                CURRENT_JSON_MAP.clear();
                for (Violation v : violations) {
                    CURRENT_JSON_MAP.put(v, v.getAsJSON());
                }
                CURRENT_HASH = user.hash;
                timeSpentMakingCauses += System.nanoTime() - causeStart;
            }
            LegacyComparisonListener.handleViolations(user, violations);
        }
        timeSpent += System.nanoTime() - start;
        return doContinue;
    }

    @Override
    public void close() {
        LegacyUpdater.close();
        Log.log("LegacyComparisonListener Time spent:                   \t" + TimeUnit.NANOSECONDS.toMillis(timeSpent) + " ms.");
        Log.log("LegacyComparisonListener Time spend loading violations:\t" + TimeUnit.NANOSECONDS.toMillis(timeSpendOnLoadingViolations) + " ms.");
        Log.log("LegacyComparisonListener Time spent making causes:     \t" + TimeUnit.NANOSECONDS.toMillis(timeSpentMakingCauses) + " ms.");
        Log.log("LegacyComparisonListener Time spend on handle:         \t" + TimeUnit.NANOSECONDS.toMillis(timeSpendGettingHandles) + " ms.\n");
    }

    private static void handleViolations(AnalysisUser user, Violation[] violations) {
        for (Violation v : violations) {
            if (loadedViolations.containsKey(v.risk.id)) {
                toUpdate.add(v);
            } else {
                toSave.add(v);
                idsForHandles.add(v.risk.id);
            }
            ids_in_violations.add(v.risk.id);
        }
        HashMap pc_handles = checkPreventiveCheckHandle && idsForHandles.size() > 0 ? LegacyComparisonListener.getPreventiveCheckHandles(user.username, idsForHandles) : new HashMap();
        for (Violation v : toSave) {
            boolean approved = v.risk.warning == 4 || v.risk.warning == 2 ? Risk.isUserApprovedForRisk(v.risk.id, user) : false;
            list.add(LegacyComparisonListener.saveViolation(user.getId(), v.risk.id, approved, (String)pc_handles.get(v.risk.id), CURRENT_JSON_MAP.get(v)));
        }
        toSave.clear();
        for (Violation v : toUpdate) {
            boolean approved = v.risk.warning == 4 || v.risk.warning == 2 ? Risk.isUserApprovedForRisk(v.risk.id, user) : false;
            list.add(LegacyComparisonListener.updateViolation(loadedViolations.get(v.risk.id), approved, CURRENT_JSON_MAP.get(v)));
        }
        toUpdate.clear();
        Collection toDelete = CollectionUtils.subtract(loadedViolations.keySet(), ids_in_violations);
        ids_in_violations.clear();
        if (toDelete.size() > 0) {
            Iterator iterator = toDelete.iterator();
            while (iterator.hasNext()) {
                int risk_id = (Integer)iterator.next();
                list.add(new LegacyData(loadedViolations.get(risk_id)));
            }
        }
        LegacyUpdater.sendToDatabase(list);
        list.clear();
    }

    private static LegacyData saveViolation(int user_id, int risk_id, boolean approved, String pc_handle, String causesJSON) {
        String causes = null;
        if (causesJSON == null) {
            causes = null;
        } else if (causesJSON.length() > 0xFFFFF8) {
            causes = null;
            Log.log("LegacyComparisonListener.saveViolation exceeded size limit 16777208B for violation causes by" + (causesJSON.length() - 0xFFFFF8) + "B - " + user_id + " Risk:" + risk_id);
        } else {
            causes = causesJSON;
        }
        if (causes == null) {
            Log.log("WARNING!!! Causes on risk is NULL !!!");
        }
        return new LegacyData(user_id, risk_id, approved, pc_handle, causes);
    }

    private static LegacyData updateViolation(int legacy_id, boolean approved, String causesJSON) {
        String causes = null;
        if (causesJSON == null) {
            causes = null;
        } else if (causesJSON.length() > 0xFFFFF8) {
            causes = null;
            Log.log("LegacyComparisonListener.updateViolation exceeded size limit 16777208B for violation causes by" + (causesJSON.length() - 0xFFFFF8) + "B - " + legacy_id);
        } else {
            causes = causesJSON;
        }
        if (causes == null) {
            Log.log("WARNING!!! causes are NULL for " + legacy_id);
        }
        return new LegacyData(legacy_id, approved, causes);
    }

    private static HashMap<Integer, String> getPreventiveCheckHandles(String username, ArrayList<Integer> risk_ids) {
        long start = System.nanoTime();
        HashMap<Integer, String> pc_handles = new HashMap<Integer, String>();
        try {
            ResultSet rs = DB.getData("SELECT `rule_id`, `handle` FROM `" + LegacyComparisonListener.getPreventiveTable() + "` WHERE `username` = '" + username + "' AND `rule_id` IN (" + Utils.integerListToString(risk_ids) + ");");
            while (rs.next()) {
                pc_handles.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("LegacyComparer.getPreventiveCheckHandle FAILED!");
            Log.logException(e);
        }
        timeSpendGettingHandles += System.nanoTime() - start;
        return pc_handles;
    }

    private static void loadAllExistingViolations(int user_id) {
        long startLoading = System.nanoTime();
        loadedViolations.clear();
        try {
            PS_EXISTING.setInt(1, user_id);
            ResultSet rs = PS_EXISTING.executeQuery();
            while (rs.next()) {
                loadedViolations.put(rs.getInt(2), rs.getInt(1));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("LegacyComparisonListener.loadAllExistingViolations FAILED!");
            Log.logException(e);
        }
        timeSpendOnLoadingViolations = System.nanoTime() - startLoading;
    }

    static String getLegacyTable() {
        return "sod_legacy_" + system.toLowerCase() + "_" + client.toLowerCase();
    }

    private static String getPreventiveTable() {
        return "sod_preventive_check_violation_" + system.toLowerCase() + "_" + client.toLowerCase();
    }

    static {
        timeSpent = 0L;
        timeSpentMakingCauses = 0L;
        timeSpendGettingHandles = 0L;
        timeSpendOnLoadingViolations = 0L;
        ids_in_violations = new ArrayList();
        list = new ArrayList();
        toSave = new ArrayList();
        toUpdate = new ArrayList();
        idsForHandles = new ArrayList();
        PS_EXISTING = null;
    }
}

