/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.reportrole;

import ac.analysis.AnalysisUser;
import ac.analysis.ViolationListener;
import ac.risk.Risk;
import ac.risk.Violation;
import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class RoleViolationAnalyzer
implements ViolationListener {
    private final HashMap<String, Integer> hits = new HashMap();
    private final HashMap<String, Integer> none = new HashMap();
    private final ArrayList<String> roles = new ArrayList();
    private final ArrayList<String> crit_role = new ArrayList();
    private final ArrayList<String> sod_role2 = new ArrayList();
    private final ArrayList<String> crit_tcode = new ArrayList();
    private final ArrayList<String> sod_func = new ArrayList();
    private final HashMap<Integer, ArrayList<String>> crit_role_groupIds = new HashMap();
    private final HashMap<Integer, ArrayList<String>> sod_role2_groupIds = new HashMap();
    private final HashMap<Integer, ArrayList<String>> crit_tcode_groupIds = new HashMap();
    private final HashMap<Integer, ArrayList<String>> sod_func_groupIds = new HashMap();
    private final String system;
    private final String client;

    RoleViolationAnalyzer(String system, String client) {
        this.system = system;
        this.client = client;
    }

    @Override
    public boolean violationFound(AnalysisUser user, Violation[] violations) {
        RoleViolationAnalyzer.handleViolations(this, user, violations);
        return true;
    }

    private static void handleViolations(RoleViolationAnalyzer rva, AnalysisUser user, Violation[] violations) {
        String rolename = user.username;
        if (violations.length > 0) {
            rva.roles.add(rolename);
        }
        block12: for (Violation violation : violations) {
            if (violation.risk.warning == 0) {
                if (rva.none.containsKey(rolename)) {
                    rva.none.put(rolename, rva.none.get(rolename) + 1);
                } else {
                    rva.none.put(rolename, 1);
                }
            } else if (rva.hits.containsKey(rolename)) {
                rva.hits.put(rolename, rva.hits.get(rolename) + 1);
            } else {
                rva.hits.put(rolename, 1);
            }
            switch (violation.risk.type) {
                case "crit_role": {
                    rva.crit_role.add(rolename);
                    if (!rva.crit_role_groupIds.containsKey(violation.risk.group_id)) {
                        rva.crit_role_groupIds.put(violation.risk.group_id, new ArrayList());
                    }
                    rva.crit_role_groupIds.get(violation.risk.group_id).add(rolename);
                    continue block12;
                }
                case "sod_role2": {
                    rva.sod_role2.add(rolename);
                    if (!rva.sod_role2_groupIds.containsKey(violation.risk.group_id)) {
                        rva.sod_role2_groupIds.put(violation.risk.group_id, new ArrayList());
                    }
                    rva.sod_role2_groupIds.get(violation.risk.group_id).add(rolename);
                    continue block12;
                }
                case "crit_tcode": {
                    rva.crit_tcode.add(rolename);
                    if (!rva.crit_tcode_groupIds.containsKey(violation.risk.group_id)) {
                        rva.crit_tcode_groupIds.put(violation.risk.group_id, new ArrayList());
                    }
                    rva.crit_tcode_groupIds.get(violation.risk.group_id).add(rolename);
                    continue block12;
                }
                case "sod_func": {
                    rva.sod_func.add(rolename);
                    if (!rva.sod_func_groupIds.containsKey(violation.risk.group_id)) {
                        rva.sod_func_groupIds.put(violation.risk.group_id, new ArrayList());
                    }
                    rva.sod_func_groupIds.get(violation.risk.group_id).add(rolename);
                }
            }
        }
    }

    @Override
    public void close() {
        this.saveViolationCount();
        RoleViolationAnalyzer.setRolesStats(this);
        RoleViolationAnalyzer.setRoleRisksStats(this);
    }

    private static String getViolationCountTable(String system, String client) {
        String s = system.toLowerCase();
        String c = client.toLowerCase();
        return "sod_role_violation_count_" + s + "_" + c;
    }

    private void saveViolationCount() {
        String[] rolenames;
        String tableName = RoleViolationAnalyzer.getViolationCountTable(this.system, this.client);
        Log.log("ac.dashboard.roleanalysis.RoleListener saving violation counts into " + tableName + ".");
        DB.update("DROP TABLE IF EXISTS " + tableName + " ;");
        DB.update("CREATE TABLE " + tableName + " ( \tid INT NOT NULL AUTO_INCREMENT, \trole VARCHAR(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL, \tviolation_count INT NOT NULL, \tnone_count INT NOT NULL, \tPRIMARY KEY (id) ) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        PreparedStatement ps = DB.prepareStatement("INSERT INTO " + tableName + " (role, violation_count, none_count) VALUES (?, ?, ?)");
        for (String rolename : rolenames = Utils.arrayMerge(this.none.keySet().toArray(Utils.EMPTYSTRINGARRAY), this.hits.keySet().toArray(Utils.EMPTYSTRINGARRAY))) {
            int h = this.hits.containsKey(rolename) ? this.hits.get(rolename) : 0;
            int n = this.none.containsKey(rolename) ? this.none.get(rolename) : 0;
            try {
                ps.setString(1, rolename);
                ps.setInt(2, h);
                ps.setInt(3, n);
                ps.addBatch();
            }
            catch (SQLException e) {
                Log.log("ac.dashboard.roleanalysis.RoleListener cannot save " + rolename + " correctly.");
                Log.logException(e);
            }
        }
        Log.log("ac.dashboard.roleanalysis.RoleListener saving " + rolenames.length + " value sets.");
        try {
            ps.executeBatch();
        }
        catch (SQLException e) {
            Log.log("ac.dashboard.roleanalysis.RoleListener cannot execute batch correctly.");
            Log.logException(e);
        }
        Log.log("ac.dashboard.roleanalysis.RoleListener saved " + rolenames.length + " value sets.");
    }

    private static void setRolesStats(RoleViolationAnalyzer roleViolations) {
        Log.log("Dashboard role analyzer (1/2) RolesStats");
        String system = roleViolations.system;
        String client = roleViolations.client;
        int numberOfRolesInSystem = DB.getOneInt("SELECT COUNT(id) AS total FROM um_role WHERE `system` = '" + system + "' AND client = '" + client + "' AND um_delete=0;");
        Log.log("Roles in system: " + numberOfRolesInSystem);
        int numberOfRoles = Utils.unique(roleViolations.roles).size();
        Log.log("Roles found with risks: " + numberOfRoles);
        int crit_role = Utils.unique(roleViolations.crit_role).size();
        Log.log("Crit_role found: " + crit_role);
        int sod_role2 = Utils.unique(roleViolations.sod_role2).size();
        Log.log("Sod_role2 found: " + sod_role2);
        int crit_tcode = Utils.unique(roleViolations.crit_tcode).size();
        Log.log("Crit_tcode found: " + crit_tcode);
        int sod_func = Utils.unique(roleViolations.sod_func).size();
        Log.log("Sod_func found: " + sod_func);
        DB.update("INSERT INTO sod_dashboard_rolecount (\tdate, `system`, client, total_roles_in_system, total_roles_in_violation, \tcrit_role, sod_role2, crit_tcode, sod_func ) VALUES (\tCURDATE(), '" + system + "', '" + client + "', " + numberOfRolesInSystem + "," + numberOfRoles + ", \t" + crit_role + "," + sod_role2 + "," + crit_tcode + "," + sod_func + ") ON DUPLICATE KEY UPDATE \ttotal_roles_in_system = " + numberOfRolesInSystem + ", total_roles_in_violation = " + numberOfRoles + ",\tcrit_role = " + crit_role + ", sod_role2 = " + sod_role2 + ", crit_tcode = " + crit_tcode + ", sod_func = " + sod_func + ";");
        Log.log("Dashboard role analyzer (1/2) RolesStats Done.");
    }

    /*
     * Could not resolve type clashes
     */
    private static void setRoleRisksStats(RoleViolationAnalyzer roleViolations) {
        Log.log("Dashboard role analyzer (2/2) RoleRisksStats");
        String system = roleViolations.system;
        String client = roleViolations.client;
        DB.update("DELETE FROM sod_dashboard_groupcount_roles WHERE date=CURDATE() AND `system` = '" + system + "' AND client = '" + client + "';");
        for (String ruleType : Risk.getTypes()) {
            boolean check = false;
            for (Map.Entry entry : (switch (ruleType) {
                case "crit_role" -> roleViolations.crit_role_groupIds;
                case "sod_role2" -> roleViolations.sod_role2_groupIds;
                case "crit_tcode" -> roleViolations.crit_tcode_groupIds;
                case "sod_func" -> roleViolations.sod_func_groupIds;
                default -> {
                    Log.log("ac.dashboard.roleanalysis.RoleAnalyzer UNKNOWN rule type " + ruleType + ". FAILURE!");
                    yield roleViolations.sod_func_groupIds;
                }
            }).entrySet()) {
                int group_id = (Integer)entry.getKey();
                int groupcount = Utils.unique((Collection)entry.getValue()).size();
                if (groupcount <= 0) continue;
                check = true;
                DB.update("INSERT INTO sod_dashboard_groupcount_roles (date, `system`, client, group_id, rule_type, count) VALUES(CURDATE(), '" + system + "', '" + client + "', '" + group_id + "', '" + ruleType + "', " + groupcount + ") ON DUPLICATE KEY UPDATE \tdate = CURDATE(), `system` = '" + system + "', client = '" + client + "', \tgroup_id = '" + group_id + "', rule_type = '" + ruleType + "', count = " + groupcount + ";");
            }
            if (check) continue;
            DB.update("INSERT INTO sod_dashboard_groupcount_roles (date, `system`, client, group_id, rule_type, count) VALUES(CURDATE(), '" + system + "', '" + client + "', '0', '" + ruleType + "', '-1') ON DUPLICATE KEY UPDATE \tdate = CURDATE(), `system` = '" + system + "', client = '" + client + "', \tgroup_id = '0', rule_type = '" + ruleType + "', count = '-1'; ");
        }
        Log.log("Dashboard role analyzer (2/2) RoleRisksStats Done.");
    }
}

