/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.reportrole;

import ac.analysis.AnalysisUser;
import ac.analysis.ViolationListener;
import ac.dashboard.DashboardSettings;
import ac.dashboard.TranslateReport;
import ac.dashboard.reportrole.RoleAnalysis;
import ac.report.standard.Report;
import ac.report.tools.Settings;
import ac.risk.Violation;
import cn.Config;
import cn.Language;
import cn.Log;
import cn.task.Task;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

class RoleReportListener
implements ViolationListener {
    private final Report report;

    RoleReportListener(Task task, Settings params) {
        this.report = Report.createReport(task, params);
        this.report.start(RoleAnalysis.getBaseFilename(params.system, params.client) + "en");
    }

    @Override
    public boolean violationFound(AnalysisUser user, Violation[] violations) {
        return this.report.violationFound(user, violations);
    }

    @Override
    public void close() {
        this.report.close();
    }

    static void deleteOldReports(String system, String client) {
        Log.log("Deleting old dashboard role analysis reports.");
        for (Language language : Language.getAvailableLanguages()) {
            Path filepath = RoleReportListener.getDashboardReportFilename(language.isoString, system, client);
            try {
                if (Files.deleteIfExists(filepath)) {
                    Log.log("Deleted " + filepath.toString());
                    continue;
                }
                Log.log("No file " + filepath.toString());
            }
            catch (IOException e) {
                Log.log("ac.dashboard.roleanalysis.DashboardRoleReportListener failed to delete " + filepath.getFileName() + ". Maybe file does not exist.");
                Log.logException(e);
            }
        }
    }

    private static Path getDashboardReportFilename(String languageISO, String system, String client) {
        return Paths.get(Config.getReportPath() + RoleAnalysis.getBaseFilename(system, client) + languageISO + ".xlsx", new String[0]);
    }

    static void translateReports(Task task, DashboardSettings settings) {
        String baseFilename = RoleAnalysis.getBaseFilename(settings.reportParams.system, settings.reportParams.client);
        TranslateReport.translateReport(task, baseFilename, settings);
    }
}

