/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.reportrole;

import ac.dashboard.reportrole.DashboardRoleSettings;
import ac.dashboard.reportrole.RoleAnalysis;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Language;
import cn.Log;
import cn.task.Task;
import cn.task.TaskHandler;

public class RoleAnalysisTaskHandler {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        int task_id = myArgs.getInt("taskid");
        Task task = Task.getById(task_id);
        int exitCode = 0;
        int exitCodeXlsx = 0;
        DashboardRoleSettings settings = new DashboardRoleSettings(task.system, task.client);
        if (settings.doAnalysis()) {
            Log.log("Launching analysis.");
            String params = "inifile=" + Config.getIniPath() + " user=" + Config.getRemoteUser() + " system=" + task.system + " client=" + task.client + " taskid=" + task_id + " ";
            String logfile = "logfile=" + Log.getFilename();
            exitCode = TaskHandler.executeJVM(RoleAnalysis.getExecutionString() + params + logfile + "_content.log", task);
            Log.log("RoleAnalysis had exit code " + exitCode);
            if (exitCode != 1) {
                if (settings.makeReport()) {
                    Log.log("Making Excel files from CSV generated during analysis.");
                    for (Language language : Language.getAvailableLanguages()) {
                        if (!settings.isLanguageActive(language.isoString)) continue;
                        exitCodeXlsx = TaskHandler.executeJVM(TaskHandler.getConverterExecutionString() + logfile + "_content.log " + Config.getReportPath() + RoleAnalysis.getBaseFilename(task.system, task.client) + language.isoString + "_selections.csv Selections " + Config.getReportPath() + RoleAnalysis.getBaseFilename(task.system, task.client) + language.isoString + ".csv Data ", task);
                        Log.log("csvToExcel had exit code " + exitCodeXlsx);
                    }
                } else {
                    Log.log("Make report has been turned off in settings. Will not be creating Excel files.");
                }
            } else {
                Log.log("Role analysis FAILED!!!");
            }
        } else {
            Log.log("Role analysis has been turned off in settings.");
        }
        DB.close();
        Log.close();
        if (exitCode == 1 || exitCodeXlsx == 1) {
            System.exit(1);
        }
        if (exitCode == 2 || exitCodeXlsx == 2) {
            System.exit(2);
        }
        System.exit(0);
    }
}

